"""
a test script for the csi and talos conversion

If you want to use the Python modules Csi2Aria and Talos2Aria,
please have a look at the example code below.

If you want to use it as it is, please change the input filenames
and the output directories and start this file with the Python interpreter.

linge@pasteur.fr
23-08-2001
"""

#input filenames:
csiFN = '/home/linge/projects/aria1.1/example/csi/csi.filt.out'
talosFN = '/home/linge/projects/aria1.1/example/talos/pred_cons.tab'

#output directories:
csiOutputDir    ='/tmp'
talosOutputDir  ='/tmp'

###############################################################################
# usually, you don't have to change anything below this line:
from Aria.DataIO import Csi2Aria, Talos2Aria
import os, string, sys

#1. creating the output filenames:
csiHbondFN = os.path.join(csiOutputDir, 'csi_hbond.tbl')
csiPhiFN = os.path.join(csiOutputDir, 'csi_phi.tbl')
csiPsiFN = os.path.join(csiOutputDir, 'csi_psi.tbl')
talosPhiFN = os.path.join(talosOutputDir, 'talos_phi.tbl')
talosPsiFN = os.path.join(talosOutputDir, 'talos_psi.tbl')

#2. CSI conversion:
print 'reading ' + csiFN
Csilist=Csi2Aria.parseCSI(csiFN)
hbond,csiPhi,psi=Csi2Aria.makeRestraints(Csilist)
print 'writing ' + csiHbondFN
Csi2Aria.writeRestraint(hbond,csiHbondFN)
print 'writing ' +  csiPhiFN
Csi2Aria.writeRestraint(csiPhi,csiPhiFN)
print 'writing ' + csiPsiFN
Csi2Aria.writeRestraint(psi,csiPsiFN)

#3. TALOS conversion:
RT = Talos2Aria.ReadTalos()
RT.parseTalos(talosFN)
print 'writing CNS/ARIA phi restraint file: ' + talosPhiFN
RT.writeCNS(fileName=talosPhiFN,\
            errorFactor=2.5, onlyPhiPsi='phi')
print 'writing CNS/ARIA psi restraint file: ' + talosPsiFN
RT.writeCNS(fileName=talosPsiFN,\
            psiError = 30, onlyPhiPsi='psi')


      
