#!/bin/csh
#
# ana_noe_viol: analysis the output of the xplor script accept.inp
#               for NOE violations with as output for each violated
#               NOE restraints, the average distance, average violation
#               and number of time it is violated in the ensemble of 
#               structures
# ana_noe_viol.awk and count_noe_viol.awk are needed
#
# A. Bonvin, Utrecht University Nov. 99
#
if ($#argv < 1) goto usage

gawk -f ana_noe_viol.awk $1 |sort +1 +0 >ana_noe_tmp1
echo 'DONE' >>ana_noe_tmp1
gawk -f count_noe_viol.awk ana_noe_tmp1 | sort -n +5 
\rm ana_noe_tmp1
goto exit

usage:
echo 'Usage: ana_noe_viol accept.out'
echo ' '
echo '       accept.out contains the NOE violations analysis'
echo '                  from the X-Plor script accept.inp '

exit:
