#!/bin/csh
#
# ana_dihed_viol: analysis the output of the xplor script accept.inp
#               for diehdral angle violations with as output for each violated
#               restraints, the average dihedral, average violation
#               and number of time it is violated in the ensemble of 
#               structures
# ana_dihed_viol.awk and count_dihed_viol.awk are needed
#
# A. Bonvin, Utrecht University Nov. 99
#
if ($#argv < 1) goto usage

cgrep -4,0 "Dihedral=" $1 | awk '{if (NF > 1 && $1 != "Dihedral=") {printf "%4s %4s %4s ",$1,$2,$3} else if (NF >1 && $1 == "Dihedral=") {print $0} }' | sort +1 -n >ana_dihed_tmp1

echo 'DONE' >>ana_dihed_tmp1
gawk -f count_dihed_viol.awk ana_dihed_tmp1 | sort -n +5 
\rm ana_dihed_tmp1
goto exit

usage:
echo 'Usage: ana_dihed_viol accept.out'
echo ' '
echo '       accept.out contains the dihedral angle violations analysis'
echo '                  from the X-Plor script accept.inp '

exit:
