#!/usr/bin/gawk -f
BEGIN { 
n=0
if (ARGC!=2)
{ printf("Usage: talos_to_xplor.gawk file\n\n");
  exit
}
}

FILENAME == ARGV[1] {
if (NF == 9) {
  if ($9 == "Good")
  {
   resn = $1;
   phi  = $3;
   psi  = $4;
   phierr = 2*$5;
   psierr = 2*$6;
   if (psierr < 10) psierr = 10.0;
   if (phierr < 10) phierr = 10.0;
   printf ("! phi residue  %5d\n",resn);
   printf ("assign (resid %4d and name C)  (resid %4d and name N)\n",resn-1,resn );
   printf ("       (resid %4d and name CA) (resid %4d and name C) 1.0 %6.1f %6.1f 2\n",resn,resn,phi,phierr);
   printf ("! psi residue  %5d\n",resn);
   printf ("assign (resid %4d and name N)  (resid %4d and name CA)\n",resn,resn );
   printf ("       (resid %4d and name C)  (resid %4d and name N) 1.0 %6.1f %6.1f 2\n",resn,resn+1,psi,psierr);
  }
}
}
