#!/usr/local/bin/perl

# displays status of your current ARIA project
# checks if the files are all there
# 
#
#
# Version: 20.5.98 Jens Linge
#
##########################################################################################

# define list of all directories of the ARIA program:
@PROGRAM_DIRS=('cgi', 'documentation', 'html', 'python', 'protocols', 'toppar');

# define list of all directories of the current project:
@PROJECT_DIRS=('begin', 'data', 'structures');

# define list of all protocols files in /ARIA/protocols:
@PROTOCOLS=('calib.inp', 'calibrate.cns', 'define_methyls.cns', 'define_methyls_all.cns',
'define_methyls_ini.cns', 'definitions.cns', 'errset.cns', 'flags.cns', 'generate.inp',
'generate_homology.inp', 'generate_template.inp', 'initialize.cns', 'merge.inp',
'planar.cns', 'planarf.cns', 'print_coorheader.cns', 're_l.inp', 'read_data.cns',
'sa_l_change_values.cns', 'sa_l_cool1.cns', 'sa_l_cool2.cns', 'sa_l_hightemp.cns',
'sa_l_initial_values.cns', 'sa_l_randomchain.cns', 'sa_l_reduced.cns', 'setup_swap.cns',
'swap15v.cns', 'xplortodiana3.inp');

##########################################################################################

# call subroutine for parsing the GET and POST data:
&ReadParse(*input);

# get the values of some variables from the associative array %input:
$ARIA_DIR=$input{ARIA_directory};
$PROJECT_DIR=$input{project_directory};
$RUN_NUMBER=$input{run_number};

# more variables:
$PROTOCOLS_DIR="$ARIA_DIR"."/protocols";

##########################################################################################

# start writing HTML document:
print &PrintHeader; 
print "<html>\n<head>\n<title>ARIA - Status of your current ARIA project</title>\
       \n</head>\n";
print "<body BGCOLOR=white>\n";
print "<h2>Status of your current ARIA project.</h2>\n<br>\n";
print "ARIA is now looking for the CNS protocols and the files of your project.\
       If there are any errors, they will be noted explicitly.<BR>\n";

# Checking the input variables:
print "<HR>Checking your current project.<BR>\n";
if (! -d "$ARIA_DIR") {
    print "  The directory $ARIA_DIR does not exist.<br>\n";
}
if (! -d "$PROJECT_DIR") {
    print "  The directory $PROJECT_DIR does not exist.<br>\n";
}
if (! -d "$PROJECT_DIR/run$RUN_NUMBER") {
    print "  The directory $$PROJECT_DIR/run$RUN_NUMBER does not exist.<br>\n";
}

# Are the program directories there?
print "<HR>Checking the program directories.<BR>\n";
foreach $DIR_TO_CHECK (@PROGRAM_DIRS) {
    if (! -d "$ARIA_DIR/$DIR_TO_CHECK") {
	print "The directory $DIR_TO_CHECK does not exist.<br>\n";
    }
}

# Are the project directories there?
print "<HR>Checking the project directories.<BR>\n";
foreach $DIR_TO_CHECK (@PROJECT_DIRS) {
    if (! -d "$PROJECT_DIR/run$RUN_NUMBER/$DIR_TO_CHECK") {
	print "The directory $DIR_TO_CHECK does not exist.<br>\n";
    }
}

# Are the protocol files there?
print "<HR>Checking the protocol files.<BR>\n";
foreach $FILE_TO_CHECK (@PROTOCOLS) {
    if (! -e "$PROTOCOLS_DIR/$FILE_TO_CHECK") {
	print "The file $FILE_TO_CHECK does not exist.<br>\n";
    }
}

# Data control:


# PSF file:


# Template file:

# Looking for the structures:
#loop until no more file.list exists


end:
# The end of your HTML document:
print "</body>\n</html>\n";


##########################################################################################
# subroutines                                                                            #
##########################################################################################
# Perl Routines to Manipulate CGI input
# S.E.Brenner@bioc.cam.ac.uk
# cgi-lib.pl,v 1.8 1995/04/07 21:35:29
#
# Copyright 1994 Steven E. Brenner  
# Unpublished work.
# Permission granted to use and modify this library so long as the
# copyright above is maintained, modifications are documented, and
# credit is given for any use of the library.
#
# Thanks are due to many people for reporting bugs and suggestions
# especially Meng Weng Wong, Maki Watanabe, Bo Frese Rasmussen,
# Andrew Dalke, Mark-Jason Dominus and Dave Dittrich.

# For more information, see:
#     http://www.bio.cam.ac.uk/web/form.html       
#     http://www.seas.upenn.edu/~mengwong/forms/   

# Minimalist http form and script (http://www.bio.cam.ac.uk/web/minimal.cgi):
#
# require "cgi-lib.pl";
# if (&ReadParse(*input)) {
#    print &PrintHeader, &PrintVariables(%input);
# } else {
#   print &PrintHeader,'<form><input type="submit">Data: <input name="myfield">';
#}

# ReadParse
# Reads in GET or POST data, converts it to unescaped text, and puts
# one key=value in each member of the list "@in"
# Also creates key/value pairs in %in, using '\0' to separate multiple
# selections

# Returns TRUE if there was input, FALSE if there was no input 
# UNDEF may be used in the future to indicate some failure.

# Now that cgi scripts can be put in the normal file space, it is useful
# to combine both the form and the script in one place.  If no parameters
# are given (i.e., ReadParse returns FALSE), then a form could be output.

# If a variable-glob parameter (e.g., *cgi_input) is passed to ReadParse,
# information is stored there, rather than in $in, @in, and %in.

# HTML formats from PrintVariables changed by Jens Linge, 25.5.98


sub ReadParse {
  local (*in) = @_ if @_;
  local ($i, $key, $val);

  # Read in text
  if (&MethGet) {
    $in = $ENV{'QUERY_STRING'};
  } elsif ($ENV{'REQUEST_METHOD'} eq "POST") {
    read(STDIN,$in,$ENV{'CONTENT_LENGTH'});
  }

  @in = split(/&/,$in);

  foreach $i (0 .. $#in) {
    # Convert plus's to spaces
    $in[$i] =~ s/\+/ /g;

    # Split into key and value.  
    ($key, $val) = split(/=/,$in[$i],2); # splits on the first =.

    # Convert %XX from hex numbers to alphanumeric
    $key =~ s/%(..)/pack("c",hex($1))/ge;
    $val =~ s/%(..)/pack("c",hex($1))/ge;

    # Associate key and value
    $in{$key} .= "\0" if (defined($in{$key})); # \0 is the multiple separator
    $in{$key} .= $val;

  }

  return length($in); 
}


# PrintHeader
# Returns the magic line which tells WWW that we're an HTML document

sub PrintHeader {
  return "Content-type: text/html\n\n";
}


# MethGet
# Return true if this cgi call was using the GET request, false otherwise

sub MethGet {
  return ($ENV{'REQUEST_METHOD'} eq "GET");
}

# MyURL
# Returns a URL to the script
sub MyURL  {
  return  'http://' . $ENV{'SERVER_NAME'} .  $ENV{'SCRIPT_NAME'};
}

# CgiError
# Prints out an error message which which containes appropriate headers,
# markup, etcetera.
# Parameters:
#  If no parameters, gives a generic error message
#  Otherwise, the first parameter will be the title and the rest will 
#  be given as different paragraphs of the body

sub CgiError {
  local (@msg) = @_;
  local ($i,$name);

  if (!@msg) {
    $name = &MyURL;
    @msg = ("Error: script $name encountered fatal error");
  };

  print &PrintHeader;
  print "<html><head><title>$msg[0]</title></head>\n";
  print "<body><h1>$msg[0]</h1>\n";
  foreach $i (1 .. $#msg) {
    print "<p>$msg[$i]</p>\n";
  }
  print "</body></html>\n";
}

# PrintVariables
# Nicely formats variables in an associative array passed as a parameter
# And returns the HTML string.

sub PrintVariables {
  local (%in) = @_;
  local ($old, $out, $output);
  $old = $*;  $* =1;
  $output .=  "<DL COMPACT>";
  foreach $key (sort keys(%in)) {
    foreach (split("\0", $in{$key})) {
      ($out = $_) =~ s/\n/<BR>/g;
      $output .=  "$key=$out<BR>";
    }
  }
  $output .=  "</DL>";
  $* = $old;

  return $output;
}

1; #return true 
##########################################################################################

