__author__   = "$Author: linge $"
__revision__ = "$Revision: 1.5 $"
__date__     = "$Date: 2000/03/27 11:07:20 $"

import os, re, string, time
from Aria.Analysis import EnergySorter, ProjectStatus
from Aria.Main import ParsePath


def WaterRefine(runDir, protocolsDir, newItDir, tempTrashDir, currit,\
                fileRoot, waterrefine, ariaDir, run):
    """
    the waterrefinement uses the protocol re_h2o.inp
    a new directory /water will be created in which one can find the refined
    structures
    important: waterrefine has to be a number! If you use a string, this
               function will not work properly.
    """
    print '    starting water refinement for the', waterrefine, \
          'best structures regarding energy'
    
    #get the integer values of the cpunumber, set 0 if '' or None:
    if run['cpunumber_1']:
        cpuNumber1 = string.atoi(run['cpunumber_1'])
    else:
        cpuNumber1 = 0
    if run['cpunumber_2']:
        cpuNumber2 = string.atoi(run['cpunumber_2'])
    else:
        cpuNumber2 = 0
    if run['cpunumber_3']:
        cpuNumber3 = string.atoi(run['cpunumber_3'])
    else:
        cpuNumber3 = 0
    if run['cpunumber_4']:
        cpuNumber4 = string.atoi(run['cpunumber_4'])
    else:
        cpuNumber4 = 0
    if run['cpunumber_5']:
        cpuNumber5 = string.atoi(run['cpunumber_5'])
    else:
        cpuNumber5 = 0
    if run['cpunumber_6']:
        cpuNumber6 = string.atoi(run['cpunumber_6'])
    else:
        cpuNumber6 = 0
    if run['cpunumber_7']:
        cpuNumber7 = string.atoi(run['cpunumber_7'])
    else:
        cpuNumber7 = 0
    if run['cpunumber_8']:
        cpuNumber8 = string.atoi(run['cpunumber_8'])
    else:
        cpuNumber8 = 0
    if run['cpunumber_9']:
        cpuNumber9 = string.atoi(run['cpunumber_9'])
    else:
        cpuNumber9 = 0
    if run['cpunumber_10']:
        cpuNumber10 = string.atoi(run['cpunumber_10'])
    else:
        cpuNumber10 = 0

    #create the queueDic:
    queueDic = {}
    if run['queue_1']:
        queueDic[run['queue_1']] = [run['cns_exe_1'], cpuNumber1, []]
    if run['queue_2']:
        queueDic[run['queue_2']] = [run['cns_exe_2'], cpuNumber2, []]
    if run['queue_3']:
        queueDic[run['queue_3']] = [run['cns_exe_3'], cpuNumber3, []]
    if run['queue_4']:
        queueDic[run['queue_4']] = [run['cns_exe_4'], cpuNumber4, []]
    if run['queue_5']:
        queueDic[run['queue_5']] = [run['cns_exe_5'], cpuNumber5, []]
    if run['queue_6']:
        queueDic[run['queue_6']] = [run['cns_exe_6'], cpuNumber6, []]
    if run['queue_7']:
        queueDic[run['queue_7']] = [run['cns_exe_7'], cpuNumber7, []]
    if run['queue_8']:
        queueDic[run['queue_8']] = [run['cns_exe_8'], cpuNumber8, []]
    if run['queue_9']:
        queueDic[run['queue_9']] = [run['cns_exe_9'], cpuNumber9, []]
    if run['queue_10']:
        queueDic[run['queue_10']] = [run['cns_exe_10'], cpuNumber10, []]

    #get the runPlusNumber as string (e.g. 'run12'):
    runPlusNumber = ParsePath.GetTail(runDir)

    #parallel computing of the waterrefined structures:
    structures = string.atoi(run['waterrefine'])

    #for substituting the count and the output filename:
    parseEval = re.compile('!The next line will be changed automatically.*?\n\s*?evaluate.*?\)')

    #read the file.list file and create a list of filenames:
    insideQuotes = re.compile('"(.*?)"')
    wStrucNumber = re.compile('\S+_(\S+)\.pdb')
    fileList = []
    wStrucList = []
    fileListHandle = open(os.path.join(runDir, 'structures/it8/file.list'))
    for eachLine in fileListHandle.readlines():
        fileSearched = insideQuotes.search(eachLine)
        wStrucSearched = wStrucNumber.search(eachLine)
        fileList.append(fileSearched.group(1))
        wStrucList.append(wStrucSearched.group(1))
    fileList = fileList[:structures]
    wStrucList = wStrucList[:structures]
    fileListHandle.close()

    status = ProjectStatus.GetStatus(run)
    queueIndex = 0
    #loop over all the structures (from 1 to 'waterrefine'):
    for strucNumber in range(1, structures + 1):
        #look which structures are already calculated:
#        print len(wStrucList), (strucNumber-1) #test
        if len(wStrucList) < strucNumber:
#            strucNumber = len(wStrucList) + 1
            continue
        if status['wpdb_' + wStrucList[strucNumber-1]] == 1:
            print '    structure', wStrucList[strucNumber-1], 'already exists.'
            continue

            
        startFrom = fileList[strucNumber-1]
        #look which queue is free, take that:
        queueIndex = 0
        while 1:
            queueList = queueDic.keys()
            eachQueue = queueList[queueIndex]
            #1. if empty, take it directly:
            if queueDic[eachQueue][1] > len(queueDic[eachQueue][2]):
                break
            #2. if fileNames exist, check if the file already exists:
            else:
                breakOut = 0
                for eachF in queueDic[eachQueue][2]:
                    if os.path.exists(eachF):
                        queueDic[eachQueue][2].remove(eachF)
                        breakOut = 1
                if breakOut: break
            if queueIndex == (len(queueList) - 1):
                queueIndex = 0
            else:
                queueIndex = queueIndex + 1
            time.sleep(5)

        print '    calculating structure', wStrucList[strucNumber-1]

        #create a temporary protocol file in the tempTrashDir:
        protocolFile = 're_h2o.inp'
        inputHandle = open(os.path.join(protocolsDir, protocolFile))
        outputFileName = os.path.join(tempTrashDir, fileRoot + '_' + runPlusNumber +\
                                      '_' + wStrucList[strucNumber-1] + 'w.inp')
        outputHandle = open(outputFileName, 'w')
        wholeProtocol = string.join(inputHandle.readlines(), '')
        #replace $count and $file:
        wholeProtocol = parseEval.sub('evaluate ($count=' +\
                                      str(strucNumber) + ')', wholeProtocol, 1)
        wholeProtocol = parseEval.sub('evaluate ($file="' +\
                                      startFrom + '")', wholeProtocol, 1)
        outputHandle.write(wholeProtocol)
        outputHandle.close()
        stdoutFN = tempTrashDir + '/' + fileRoot + '_' + runPlusNumber + '_' +\
                   wStrucList[strucNumber-1] + 'w.out'
        
        jobString = """cd %s
setenv ARIA %s
setenv CURRIT %s
setenv NEWIT %s
setenv PREVIT %s
setenv RUN %s
setenv SPECTRUM %s
setenv TEMPTRASH %s
%s < %s > %s
""" % (tempTrashDir,\
       ariaDir,\
       str(currit),\
       newItDir,\
       newItDir,\
       runDir,\
       '',\
       tempTrashDir,\
       queueDic[eachQueue][0],\
       ParsePath.GetTail(outputFileName),\
       ParsePath.GetTail(stdoutFN))
        jobFN = os.path.join(tempTrashDir, fileRoot + '_' +\
                             runPlusNumber +\
                             '_' + wStrucList[strucNumber-1] + 'w.job')
        jobStream = open(jobFN, 'w')
        jobStream.write(jobString)
        jobStream.close()

        #start the queue with the proper command and job file:
        whatToDo = eachQueue + ' ' + ParsePath.GetTail(jobFN) + ' &'
        print '      queue command:\n     ', whatToDo
        os.chdir(tempTrashDir)
        os.system(whatToDo)

        #add the file to the queueDic:
        queueDic[eachQueue][2].append(newItDir + '/water/' + fileRoot + '_' +\
                                      wStrucList[strucNumber-1] + 'w.pdb')
#        print queueDic #test

    #looking for the finished structures:
    print '    wait for the structures...'
#    print '    you should check if your specified queues are actually running!!!'
    while 1:
        status = ProjectStatus.GetStatus(run)
        for strucNumber in range(1, structures + 1):
#            print len(wStrucList), strucNumber #test
            if len(wStrucList) < strucNumber:
#                strucNumber = len(wStrucList) + 1
                continue
            #look which structures are already calculated:
            allStrucExists = 0
            if status['wpdb_' + wStrucList[strucNumber-1]] == 1:
                allStrucExists = 1
            else:
                allStrucExists = 0
                break
        if allStrucExists: break
        time.sleep(5)


    #create the final file.list:
    EnergySorter.WriteFileList(newItDir + '/water')
