"""
a module for checking the status of your project
"""
__author__   = "$Author: linge $"
__revision__ = "$Revision: 1.2 $"
__date__     = "$Date: 1999/09/10 13:33:59 $"

import os, string

def GetStatus(run):
    """
    checks the whole directory tree of your project
    GetStatus is looking for all the files and directories, which are
    necessary to run your project
    it creates an dictionary, in which the value:
    0 means: 'has to been done, not yet finished'
    1 means: 'is o.k., already done'

    INPUT:   run is a dictionary with all the information parsed out of
             run.cns
    OUTPUT:  returns a dictionary with the status (0 or 1)
    USAGE:   status = GetStatus(run)
    """

    status = {}   #the dictionary with all the status information

    #looking for a list of files and directories:
    lookfor = {run['aria_dir']: 'aria_dir',            #ARIA program
	       run['protocolsdir']: 'protocolsDir',
	       run['project_dir']: 'project_dir',      #project directories
	       run['run_dir']: 'run_dir',
	       run['begindir']: 'begindir',
	       run['datadir']: 'datadir',
	       run['sequencedir']: 'sequencedir',
	       run['structuresdir']: 'structuresdir',      
	       run['psffile']: 'psffile',              #project files
	       run['templatefile']: 'templatefile'
	       }
    
    for file in lookfor.keys():
	if os.path.exists(file):
#	    print ' ', file, 'exists'
	    status[lookfor[file]] = 1
	else:
#	    print ' ', file, 'does not exist'
	    status[lookfor[file]] = 0

    #looking for file.list, ambig.tbl and unambig.tbl in the
    #directories of every iteration:
    for currit in range(0, 9):
	currit = str(currit)
	if os.path.exists(run['run_dir'] + '/structures/it' + str(currit) +\
                          '/file.list'):
#	    print ' ', 'file.list of iteration', currit, 'exists'
	    status['filelist' + currit] = 1
	else:
#	    print ' ', 'file.list of iteration', currit, "doesn't exist"
	    status['filelist' + currit] = 0
        if os.path.exists(run['run_dir'] + '/structures/it' + str(currit) + '/unambig.tbl'):
            status['unambigtbl' + currit] = 1
        else:
            status['unambigtbl' + currit] = 0
            
        if os.path.exists(run['run_dir'] + '/structures/it' + str(currit) + '/ambig.tbl'):
            status['ambigtbl' + currit] = 1
        else:
            status['ambigtbl' + currit] = 0
            
    #looking for each structure in each iteration:
    fileRoot = run['fileroot']
    for currit in range(0, 9):
	currit = str(currit)
        iniCount = run['ini_count_' + currit]
        structures = run['structures_' + currit]
        for eachNumber in range(string.atoi(iniCount), string.atoi(structures) + 1):
            eachNumber = str(eachNumber)
            if os.path.exists(run['run_dir'] + '/structures/it' + currit +\
                              '/' + fileRoot + '_' + eachNumber + '.pdb'):
                status['pdb_' + currit + '_' + eachNumber] = 1
	    else:
                status['pdb_' + currit + '_' + eachNumber] = 0
    
    #looking for the finaldata in iteration 8:
    if os.path.exists(run['run_dir'] + '/structures/it8/finaldata/unambig.tbl') and\
       os.path.exists(run['run_dir'] + '/structures/it8/finaldata/ambig.tbl'):
        status['finaldata'] = 1
    else:
        status['finaldata'] = 0
        
    #looking for the analysis files (just look for the 'noe.disp' file)
    #that's a simple check:
    if os.path.exists(run['run_dir'] + '/structures/it8/analysis/noe.disp'):
        status['analysis'] = 1
    else:
        status['analysis'] = 0

    #looking for the waterrefined structures in /structures/it8/water:
    fileRoot = run['fileroot']
    waterRefine = run['waterrefine']
    structures8 = run['structures_8']
    for eachNumber in range(1, string.atoi(structures8) + 1):
        eachNumber = str(eachNumber)
        if os.path.exists(run['run_dir'] + '/structures/it8/water/' +\
                          fileRoot + '_' + eachNumber + 'w.pdb'):
            status['wpdb_' + eachNumber] = 1
        else:
            status['wpdb_' + eachNumber] = 0

    return status
