"""
a module for sorting ARIA .pdb files regarding energy
"""
__author__   = "$Author: linge $"
__revision__ = "$Revision: 1.1.1.1 $"
__date__     = "$Date: 1999/09/02 13:35:22 $"

import glob,  string, sys
from Aria.Main import ParsePath
from Aria.ThirdParty import TextFile

###############################################################################
def WriteFileList(directory, outDir='', howMany=100000, message=1, fileNam=1):
    """
    reads all PDB files in the given directory
    INPUT:   directory=the directory to look for the .pdb files
             outDir=the directory to write the file.list
             howMany=howMany structures to write in file.list
             message=toggle for printing a message (1=on, 0=off)
             fileNam=toggle for printing file.nam (1=on, 0=off)
    writes the file file.list in given directory
    also writes a file called file.nam for MolMol which contains
    a list of all the pdb files
    """
    if outDir == '':
        outDir = directory
    if message == 1:
        print '    creating file.list in', outDir
    if message == 1 and fileNam == 1:
        print '    creating file.nam in', outDir

    #get a list of all the pdb files:
    pdbFiles = glob.glob(directory + '/*.pdb')
    if len(pdbFiles) == 0:
        if fileNam == 1:
            print '    no pdb files found => file.list and file.nam not created'
        else:
            print '    no pdb files found => file.list not created'
        return

    #parse the energies from the pdb files:
    energiesAndFiles = {}  #key: energy, value: list of filename(s)
    for x in pdbFiles:  #loop over all the pdb files in given directory
	for line in TextFile.TextFile(x):
	    if line[0:16] == 'REMARK energies:':
		lineList = string.split(line)
                #get the overall energy:
                overallEnergy = lineList[2]
		#get rid of the comma:
                overallEnergy = overallEnergy[:-1]
		overallEnergy = string.atof(overallEnergy)
                #define a dictionary, use a list for the files:
                if energiesAndFiles.has_key(overallEnergy):
                    energiesAndFiles[overallEnergy].append(ParsePath.GetTail(x))
                else:
                    energiesAndFiles[overallEnergy] = [ParsePath.GetTail(x), ]
		break

    #create a sorted list which contains the energies:
    energies = energiesAndFiles.keys()
    energies.sort()      #numerically sorted because of string.atof() above

    #open file.list and file.nam filehandles:
    try:
        fileListHandle = open (outDir + '/file.list', 'w')
    except IOError:
        print "couldn't create file.list in directory", outDir
        Messages.StopAria()
    if fileNam == 1:
        try:
            namHandle = open (outDir + '/file.nam', 'w')
        except IOError:
            print "couldn't create file.nam in directory", outDir
            Messages.StopAria()

    #output - files sorted regarding energy:
    for value in energies[:min(howMany, len(energies))]:
        xxx = 0
        while xxx < len(energiesAndFiles[value]):
            fileListHandle.write('"PREVIT:' + str(energiesAndFiles[value][xxx]) +\
                                 '"  { ' + str(value) + ' }\n')
            if fileNam == 1:
                namHandle.write(str(energiesAndFiles[value][xxx]) + '\n')
            xxx = xxx + 1
    #close the file handles:
    fileListHandle.close()
    if fileNam == 1:
        namHandle.write('\n')
        namHandle.close()
