/*   File:                /home/schuerer/toppred/src/mloutput.h
 *   Author:              Schuerer <schuerer@pasteur.fr>
 *   Date first visited:  <Thu Jul 12 11:13:35 2001>
 *   Time-stamp:          <Wed Nov 21 2001>
 *   Development Stage :  Under construction
 */

#ifndef __MLOUTPUT_H_
#define __MLOUTPUT_H_

#include <stdlib.h>
#include "loop.h"
#include "params.h"
#include "topoprint.h"
#include "seq-reader.h"

/* xml output functions */
void xml_header(FILE *OUT, char *data_dir);

void xml_parameters (param_t *p);

void xml_header_sequence (FILE *OUT, seq_t *seq);
void xml_plot (FILE *OUT, char *seqname, param_t *p);
void xml_tmsummary (FILE *OUT, int nseg, seg_t *KSseg);
void xml_topology (topoprint_t *topo, int nel, param_t *para);
void xml_tail_sequence(FILE *OUT);

void xml_tail(FILE *OUT);

/* html output functions */
#define start_phrase() (void) fprintf(OUT, "<PRE><P>\n")
#define end_phrase()   (void) fprintf(OUT, "</P></PRE>\n")

FILE *init_html(char *name, char *dir);
void html_header (FILE *OUT, char *name);
void html_parameters (FILE *OUT, param_t *p);

void html_sequence (FILE *OUT, seq_t *seq);
void html_plot (FILE *OUT, char *seqname, param_t *p);
void html_topology (topoprint_t *topo, int nel, param_t *para);

#endif /* _MLOUTPUT_H_ */
