#! @PERL@

use strict;
use warnings;

my $docpath = $ENV{'PROSITEDOC'} || $ENV{'PROSITEDATA'} || "@PROSITEDATA@";

my @docids = ();

# Process prose output, and save documentation ids.
print "Pattern occurences:\n";
while (<>) {
  my @tmp = split /\s+/;
  die "not enough fields in the prose output (use -d option)\n"
    unless $#tmp == 6;
  push @docids, $tmp[5];
  print; }
print "\n";

# Check for needed documentation entries
exit 0
  unless $#docids >= 0;

# Process documentation entries
print "Documentation:\n";
open DOC, "$docpath/prosite.doc" or
  die "$docpath/prosite.doc: $!\n";
my $skip = 1;
while (<DOC>) {
  if (/^\{(PDOC([0-9]){5})\}$/) {
    $skip = not grep /^$1$/, @docids; }
  if ($skip != 0) { next; }
  print; }
close DOC;

exit 0;
