#! /bin/sh

## Verbose mode
test "x$VERBOSE" = xx && set -x

## Check default sequence
../src/prose -p '[livmfy](3)' $srcdir/TAUD_ECOLI.seq >/dev/null || exit 1

## Check for anonymous sequence
sed 's,^>.*$,> comment,' $srcdir/TAUD_ECOLI.seq >_fasta.seq
../src/prose -p '[livmfy](3)' _fasta.seq | grep -v unknown && exit 1
sed 's,^>.*$,> ,' $srcdir/TAUD_ECOLI.seq >_fasta.seq
../src/prose -p '[livmfy](3)' _fasta.seq | grep -v unknown && exit 1
sed 's,^>.*$,>,' $srcdir/TAUD_ECOLI.seq >_fasta.seq
../src/prose -p '[livmfy](3)' _fasta.seq | grep -v unknown && exit 1

## Check for sequence without newline at EOF
sed '$d' $srcdir/TAUD_ECOLI.seq >_fasta.seq
tail -n 1 $srcdir/TAUD_ECOLI.seq | tr -d '\n' >>_fasta.seq
../src/prose -p '[livmfy](3)' _fasta.seq >/dev/null || exit 1

## Check for empty sequence
head -n 1 $srcdir/TAUD_ECOLI.seq >_fasta.seq
../src/prose -p '[livmfy](3)' _fasta.seq >/dev/null || exit 1

## Check for empty line
echo | cat - $srcdir/TAUD_ECOLI.seq >_fasta.seq
../src/prose -p '[livmfy](3)' _fasta.seq >/dev/null || exit 1

## Cleanup
rm -f _fasta.seq

exit 0
