#! /bin/sh

## Verbose mode
test "x$VERBOSE" = xx && set -x

## Check starting/ending anchors
../src/prose -p 'S-E-x' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 3 || exit 1
../src/prose -p '<S-E-x' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1
../src/prose -p 'x-A-G' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 2 || exit 1
../src/prose -p 'x-A-G>' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1
../src/prose -p '<x' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1
../src/prose -p 'x>' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1

## Check positive/negative ambiguities
../src/prose -p 'S-E-[KR]' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 2 || exit 1
../src/prose -p 'S-E-{KR}' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1

## Check for repetition value/range
../src/prose -p 'G-A-x(2)-A-A' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1
../src/prose -p 'G-A-x(2,2)-A-A' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1
../src/prose -p 'G-A-x(1,3)-A-A' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 1 || exit 1
../src/prose -p 'G-A-x(0,1)-A-A' $srcdir/TAUD_ECOLI.seq >_tmp.out || exit 1
test `cat _tmp.out | wc -l` -eq 0 || exit 1

## Check for problems ...
../src/prose -p 'x(0)' $srcdir/TAUD_ECOLI.seq 2>/dev/null || exit 1
../src/prose -p 'x(0,0)' $srcdir/TAUD_ECOLI.seq 2>/dev/null || exit 1
../src/prose -p 'x(0,1)' $srcdir/TAUD_ECOLI.seq >/dev/null 2>&1 || exit 1
../src/prose -p 'x(0,)' $srcdir/TAUD_ECOLI.seq >/dev/null 2>&1 || exit 1

## Cleanup
rm -f _tmp.out

exit 0
