/* fasta.c - FASTA format sequence functions */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ctype.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#include "mytag.h"
#include "error.h"
#include "fasta.h"

#define BUFSIZE 100


int fasta_parse(fasta_t *seq, FILE *f) {
  char *p, *q, *r, *buf, *tmp;
  int c, res, hdr;
  long off;
  size_t len, siz;

  /* FIXME: Temporary init ... */
  seq->nam = seq->dsc = seq->seq = NULL;

  len = BUFSIZE;
  buf = malloc(len);
  if (buf == NULL) {
    error_fatal("memory", NULL); }

  hdr = 1;
  while (/*CONSTCOND*/1) {

    c = fgetc(f);
    if (c == EOF) { res = 1 - hdr; break; }
    c = ungetc(c, f);
    if (c == '>' && hdr == 0) { res = 1; break; }

    off = ftell(f);

    p = fgets(buf, (int)len, f);
    if (p == NULL) { res = 0; break; }

    /* Check for truncated line */
    if (strrchr(p, '\n') == NULL && feof(f) == 0) {
      len += BUFSIZE;
      buf = realloc(buf, len);
      if (buf == NULL) {
	error_fatal("memory", NULL); }
      res = fseek(f, off, SEEK_SET);
      if (res == -1) {
	error_fatal("fseek failed", NULL); }
      continue; }

    /* Skip empty lines */
    while (*p && isspace((int)*p)) { p++; }
    if (*p == '\0') { continue; }

    /* Parse header line */
    if (hdr == 1) {
      if (*p != '>' || p != buf) {
	error_fatal("fasta", "unexpected line"); }
      p++; q = p; while (*q && !isspace((int)*q)) q++;
      siz = q - p;
      if (siz) {
	tmp = malloc(siz + 1); r = tmp;
	while (p < q) { *r++ = *p++; }
	*r = '\0';
	seq->nam = tmp; }
      while (*q && !isspace((int)*q)) { p++; q++; }
      while (*q && *q != '\n') q++;
      siz = q - p;
      if (siz) {
	tmp = malloc(siz + 1); r = tmp;
	while (p < q) { *r++ = *p++; }
	*r = '\0';
	seq->dsc = tmp; }
      hdr = 0; continue; }

    /* Parse sequence line */
    siz = (seq->seq == NULL) ? 0 : strlen(seq->seq);
    tmp = realloc(seq->seq, siz + strlen(p) + 1);
    if (tmp == NULL) {
      error_fatal("memory", NULL); }
    q = tmp + siz;
    while (*p) {
      if (!isalpha((int)*p)) { p++; continue; }
      *q++ = *p++; }
    *q = '\0';
    seq->seq = tmp; }

  free(buf);

  return res; }


void fasta_free(fasta_t *s) {
  free(s->nam);
  free(s->dsc);
  free(s->seq); }
