/* -----------------------------------------------------------------
 file      : /home/schuerer/prosite/src/getpara.c

 author    : Schuerer <schuerer@pasteur.fr>
 creation  : <Wed May 16 17:51:33 2001>
 Time-stamp: <Thu May 02 10:30:28 2002>
 Dev-stage : under construction

 description : 


-------------------------------------------------------------------- */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "error.h"
#include "getpara.h"
#include "mytag.h"

/* internal macros */

/* internal prototypes */

static void usage ();

/* function definition */

static void usage () {
  (void) printf("usage: %s [OPTION] FILE ...\n", PACKAGE);
  (void) printf("\n");
  (void) printf("prosite patterns search in protein sequences\n"); 
  (void) printf("\n");
  (void) printf("example: %s seq.fasta            - search for all patterns in the PROSITE database\n", PACKAGE);
  (void) printf("         %s -p A-[DE]$ seq.fasta - search for AD and AE at the end of the sequence\n", PACKAGE);
  (void) printf("\n");
  (void) printf("-h                print this message\n");
  (void) printf("\n");
  (void) printf("pattern parameters:\n");
  (void) printf("                  default search all patterns in prosite database\n");
  (void) printf("-p <pattern>      search <pattern>\n");
  (void) printf("-l <file>         obtain patterns from <file>, one per line\n");
  (void) printf("-s                include abundant patterns (/skip-flag set)\n");
  (void) printf("-d                include pattern documentation\n");
  (void) printf("\n");
  (void) printf("-w                warn about incorrect pattern syntaxe\n");
  (void) printf("-c                search case-sensitive\n");
  (void) printf("\n");
  (void) printf("-n                use with nucleotid sequence (use N as joker letter)\n");
  (void) printf("-e                patterns to search are regular expressions\n");
  (void) printf("\n");
  (void) printf("-m long|short|all which pattern occurrences to print (default short)\n");
  (void) printf("\n");
  (void) printf("sequence files: all files have to be in fasta format.\n");
  (void) printf("-               takes the sequences from stdin.\n");
}

int parsepara (para_t *pa, int argc, char *argv[]) {

  int o;

  while ((o = getopt(argc, argv, "ensdwchm:p:l:")) != -1) {
   
    switch (o) {
    case 'c':
      pa->case_sens = TRUE;
      break;
    case 'e':
      pa->t_exp = REGEX;
      break;
    case 'h':
      usage();
      exit(OK);
      break;
    case 'l':
      pa->pformat = LIST;
      pa->pattern = optarg;
      break;
    case 'p':
      pa->pformat = PATTERN;
      pa->pattern = optarg;
      break; 
    case 's':
      pa->skip = FALSE;
      break;
    case 'd':
      pa->doc = TRUE;
      break;
    case 'w':
      pa->verif = TRUE;
      break;
    case 'n':
      pa->is_nucl = TRUE;
      break;
    case 'm':
      switch (tolower(*optarg)) { 
      case 'l':
	pa->match = LONG;
	break;
      case 's':
	pa->match = SHORT;
	break;
      default:
	pa->match = ALL;
      }
      break;
    default:
      usage();
      exit(EXIT_FAILURE);
    }
   
  }

  if (pa->pformat == PROSITE && pa->t_exp != PROSITE) {
     (void) fprintf(stderr, "%s: pattern in PROSITE database are in prosite format\n", argv[0]);
     usage();
     exit(EXIT_FAILURE);
  }

  if ( pa->is_nucl && pa->pformat == PROSITE ) {
    (void) fprintf(stderr, "%s: can't search the pattern of the PROSITE database in nucleotid sequences\n", argv[0]);
    usage();
    exit(EXIT_FAILURE);
  }

  if (optind == argc) {
    (void) fprintf(stderr, "%s: missing sequence file\n", argv[0]);
    usage();
    exit(EXIT_FAILURE);
  }
    
  return optind;
}









