/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VueRNAList
extends JPanel
implements TableModelListener,
ActionListener {
    private JTable table;
    private ValueTableModel _tm;
    private ArrayList<RNA> data;
    private ArrayList<Object> columns;
    private ArrayList<Boolean> included;

    public VueRNAList(ArrayList<RNA> rnas) {
        super(new BorderLayout());
        this.data = rnas;
        this.init();
    }

    public ArrayList<RNA> getSelectedRNAs() {
        ArrayList<RNA> result = new ArrayList<RNA>();
        int i = 0;
        while (i < this.data.size()) {
            if (this.included.get(i).booleanValue()) {
                result.add(this.data.get(i));
            }
            ++i;
        }
        return result;
    }

    private void init() {
        Object[] col = new Object[]{"Num", "Selected", "Name", "ID", "Length"};
        this.columns = new ArrayList();
        int i = 0;
        while (i < col.length) {
            this.columns.add(col[i]);
            ++i;
        }
        this.included = new ArrayList();
        i = 0;
        while (i < this.data.size()) {
            this.included.add(new Boolean(true));
            ++i;
        }
        this._tm = new ValueTableModel();
        this.table = new JTable(this._tm);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this.table.setAutoResizeMode(0);
        TableColumn c0 = this.table.getColumnModel().getColumn(0);
        c0.setPreferredWidth(30);
        TableColumn c1 = this.table.getColumnModel().getColumn(1);
        c1.setPreferredWidth(30);
        TableColumn c2 = this.table.getColumnModel().getColumn(2);
        c2.setPreferredWidth(200);
        TableColumn c3 = this.table.getColumnModel().getColumn(3);
        c3.setPreferredWidth(200);
        TableColumn c4 = this.table.getColumnModel().getColumn(4);
        c4.setPreferredWidth(30);
        this.table.setAutoResizeMode(4);
        this.table.getModel().addTableModelListener(this);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        JPanel jp = new JPanel();
        JPanel jpl = new JPanel();
        JPanel jpr = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)jpl, "West");
        jp.add((Component)jpr, "East");
        jp.add((Component)new JLabel("Please select which model(s) should be imported."), "South");
        JButton selectAll = new JButton("Select All");
        selectAll.addActionListener(this);
        selectAll.setActionCommand("all");
        JButton deselectAll = new JButton("Deselect All");
        deselectAll.addActionListener(this);
        deselectAll.setActionCommand("none");
        jpl.add(selectAll);
        jpr.add(deselectAll);
        this.add((Component)scrollPane, "Center");
        this.add((Component)jp, "South");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            this.table.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("none")) {
            int i = 0;
            while (i < this.included.size()) {
                this.included.set(i, false);
                ++i;
            }
            this._tm.fireTableRowsUpdated(0, this.included.size() - 1);
        } else if (e.getActionCommand().equals("all")) {
            int i = 0;
            while (i < this.included.size()) {
                this.included.set(i, true);
                ++i;
            }
            this._tm.fireTableRowsUpdated(0, this.included.size() - 1);
        }
    }

    private class ValueTableModel
    extends AbstractTableModel {
        private ValueTableModel() {
        }

        public String getColumnName(int col) {
            return VueRNAList.this.columns.get(col).toString();
        }

        public int getRowCount() {
            return VueRNAList.this.data.size();
        }

        public int getColumnCount() {
            return VueRNAList.this.columns.size();
        }

        public Object getValueAt(int row, int col) {
            RNA r = (RNA)VueRNAList.this.data.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return new Boolean((Boolean)VueRNAList.this.included.get(row));
            }
            if (col == 2) {
                return new String(r.getName());
            }
            if (col == 3) {
                return new String(r.getID());
            }
            if (col == 4) {
                return new Integer(r.getSize());
            }
            return "N/A";
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                VueRNAList.this.included.set(row, (Boolean)value);
                this.fireTableCellUpdated(row, col);
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

