/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class VueMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private VARNAPanel _vp;
    private ControleurMenu _controlerMenu;
    private JCheckBoxMenuItem _itemOptionSpecialBaseColored = new JCheckBoxMenuItem("Custom colored", false);
    private JCheckBoxMenuItem _itemShowWarnings = new JCheckBoxMenuItem("Show warnings", false);
    private JCheckBoxMenuItem _itemOptionGapsBaseColored = new JCheckBoxMenuItem("Custom colored", false);
    private JCheckBoxMenuItem _itemOptionBondsColored = new JCheckBoxMenuItem("Use base color for base-pairs", false);
    private JCheckBoxMenuItem _itemShowNCBP = new JCheckBoxMenuItem("Show non-canonical BPs", true);
    private JCheckBoxMenuItem _itemShowOnlyPlanar = new JCheckBoxMenuItem("Hide tertiary BPs", false);
    private JCheckBoxMenuItem _itemFlatExteriorLoop = new JCheckBoxMenuItem("Flat exterior loop", false);
    private JCheckBoxMenuItem _itemShowColorMap = new JCheckBoxMenuItem("Show color map", false);
    private JMenuItem _dashBasesColor;
    private ArrayList<JComponent> _disabled = new ArrayList();
    private JMenuItem _rotation;
    private JMenuItem _bpHeightIncrement;
    private Point _spawnOrigin = new Point(-1, -1);
    JMenu _subMenuBases;
    private Component _selectionMenuIndex = null;

    public VueMenu(VARNAPanel vp) {
        this._vp = vp;
        this._controlerMenu = new ControleurMenu(this._vp, this);
    }

    private void addTitle(String title, boolean keep) {
        JSeparator sep = new JSeparator();
        JLabel titleItem = new JLabel(" " + title);
        Font previousFont = titleItem.getFont();
        Font futureFont = previousFont.deriveFont(1).deriveFont((float)previousFont.getSize() + 1.0f);
        titleItem.setFont(futureFont);
        Color current = titleItem.getForeground();
        Color future = current.brighter().brighter();
        titleItem.setForeground(future);
        this.add(titleItem);
        this.add(sep);
        if (!keep) {
            this._disabled.add(sep);
            this._disabled.add(titleItem);
        }
    }

    private void configMenuItem(JMenuItem mi, String command, String keyStroke, Container par) {
        this.configMenuItem(mi, command, keyStroke, par, false);
    }

    private void configMenuItem(JMenuItem mi, String command, String keyStroke, Container par, boolean disabled) {
        mi.setActionCommand(command);
        mi.addActionListener(this._controlerMenu);
        if (keyStroke != null && !keyStroke.equals("")) {
            mi.setAccelerator(KeyStroke.getKeyStroke(keyStroke));
        }
        if (disabled) {
            this._disabled.add(mi);
        }
        par.add(mi);
    }

    private JMenuItem createMenuItem(String caption, String command, String keyStroke, Container par, boolean disabled) {
        JMenuItem mi = new JMenuItem(caption);
        this.configMenuItem(mi, command, keyStroke, par, disabled);
        return mi;
    }

    private JMenuItem createMenuItem(String caption, String command, String keyStroke, Container par) {
        return this.createMenuItem(caption, command, keyStroke, par, false);
    }

    public void updateDialog() {
        int i = 0;
        while (i < this._disabled.size()) {
            JComponent j = this._disabled.get(i);
            j.setVisible(this._vp.isModifiable());
            ++i;
        }
        this._itemOptionSpecialBaseColored.setState(this._vp.getColorSpecialBases());
        this._itemShowWarnings.setState(this._vp.getShowWarnings());
        this._itemOptionGapsBaseColored.setState(this._vp.getColorGapsBases());
        this._itemOptionGapsBaseColored.setEnabled(this._vp.isComparisonMode());
        this._dashBasesColor.setEnabled(this._vp.isComparisonMode());
        this._rotation.setEnabled(this._vp.getDrawMode() != 4);
        this._bpHeightIncrement.setEnabled(this._vp.getDrawMode() == 4);
        this._itemOptionBondsColored.setState(this._vp.getUseBaseColorsForBPs());
        this._itemShowNCBP.setState(this._vp.getShowNonCanonicalBP());
        this._itemShowOnlyPlanar.setState(!this._vp.getShowNonPlanarBP());
        this._itemShowColorMap.setState(this._vp.getColorMapVisible());
        this._itemFlatExteriorLoop.setState(this._vp.getFlatExteriorLoop());
        this._itemFlatExteriorLoop.setEnabled(this._vp.getDrawMode() == 2);
    }

    public void buildPopupMenu() {
        this.addTitle("File", true);
        this.fileMenu();
        this.exportMenu();
        this.createMenuItem("Print...", "print", "control P", this);
        this.addSeparator();
        this.addTitle("Display", true);
        this.viewMenu();
        this.displayMenu();
        JSeparator sep = new JSeparator();
        this.add(sep);
        this._disabled.add(sep);
        this.addTitle("Edit", false);
        this.editRNAMenu();
        this.redrawMenu();
        this.colorClassesMenu();
        this.annotationMenu();
        this._disabled.add(this._itemShowNCBP);
        this._disabled.add(this._itemShowOnlyPlanar);
        this.aboutMenu();
    }

    private void annotationMenu() {
        JMenu submenuAnnotations = new JMenu("Annotations");
        JMenu addAnnotations = new JMenu("New");
        this.createMenuItem("Here", "annotationsaddPosition", "", addAnnotations);
        this.createMenuItem("Base", "annotationsaddBase", "", addAnnotations);
        this.createMenuItem("Loop", "annotationsaddLoop", "", addAnnotations);
        this.createMenuItem("Helix", "annotationsaddHelix", "", addAnnotations);
        JSeparator sep = new JSeparator();
        addAnnotations.add(sep);
        this.createMenuItem("Region", "annotationsaddRegion", "", addAnnotations);
        this.createMenuItem("Chem. prob.", "annotationsaddChemProb", "", addAnnotations);
        submenuAnnotations.add(addAnnotations);
        this.createMenuItem("Edit from list...", "annotationsedit", "", submenuAnnotations);
        this.createMenuItem("Remove from list...", "annotationsremove", "", submenuAnnotations);
        submenuAnnotations.addSeparator();
        this.createMenuItem("Auto 5'/3'", "annotationsautoextremites", "control alt Q", submenuAnnotations);
        this.createMenuItem("Auto helices", "annotationsautohelices", "control Q", submenuAnnotations);
        this.createMenuItem("Auto interior loops", "annotationsautointerior", "alt shift Q", submenuAnnotations);
        this.createMenuItem("Auto terminal loops", "annotationsautoterminal", "control shift Q", submenuAnnotations);
        this.add(submenuAnnotations);
    }

    private void fileMenu() {
        this.createMenuItem("New...", "userInput", "control N", this, true);
        this.createMenuItem("Open...", "file", "control O", this, true);
        this.createMenuItem("Save...", "saveas", "control S", this, true);
        JMenu submenuSave = new JMenu("Save as");
        this.createMenuItem("DBN (Vienna)", "dbn", "", submenuSave);
        this.createMenuItem("BPSEQ", "bpseq", "", submenuSave);
        this.createMenuItem("CT", "ct", "", submenuSave);
        this.add(submenuSave);
    }

    private void exportMenu() {
        JMenu submenuExport = new JMenu("Export");
        this.createMenuItem("SVG", "svg", "", submenuExport);
        this.createMenuItem("XFIG", "xfig", "", submenuExport);
        submenuExport.addSeparator();
        this.createMenuItem("EPS", "eps", "", submenuExport);
        submenuExport.addSeparator();
        this.createMenuItem("PNG", "png", "", submenuExport);
        this.createMenuItem("JPEG", "jpeg", "", submenuExport);
        this.add(submenuExport);
    }

    private void displayMenu() {
        JMenu subMenuBasePairs = new JMenu("Base Pairs");
        this.createMenuItem("BP style...", "bpstyle", "control shift P", subMenuBasePairs);
        this.configMenuItem(this._itemShowNCBP, "shownc", "control W", subMenuBasePairs);
        this.configMenuItem(this._itemShowOnlyPlanar, "shownp", "control E", subMenuBasePairs);
        JMenu subMenuNSBases = new JMenu("Non-standard bases");
        this.configMenuItem(this._itemOptionSpecialBaseColored, "specialbasecolored", "control J", subMenuNSBases);
        this.createMenuItem("Color", "specialBasesColor", "control shift J", subMenuNSBases);
        JMenu subMenuGapsBases = new JMenu("'Gaps' bases");
        this.configMenuItem(this._itemOptionGapsBaseColored, "dashbasecolored", "control D", subMenuGapsBases);
        this._dashBasesColor = this.createMenuItem("Color", "dashBasesColor", "control shift D", subMenuGapsBases);
        JSeparator sep = new JSeparator();
        this._disabled.add(sep);
        JMenu submenuStyle = new JMenu("RNA style");
        this.createMenuItem("Toggle 'Gaspin' mode", "gaspin", "alt G", submenuStyle, true);
        submenuStyle.add(subMenuBasePairs);
        submenuStyle.addSeparator();
        submenuStyle.add(subMenuNSBases);
        submenuStyle.add(subMenuGapsBases);
        submenuStyle.add(sep);
        this.createMenuItem("Backbone color", "backbone", "control K", submenuStyle, true);
        JMenu submenuTitle = new JMenu("Title");
        this.createMenuItem("Set Title", "setTitle", "control T", submenuTitle, true);
        this.createMenuItem("Font", "titleDisplay", "control shift T", submenuTitle, true);
        this.createMenuItem("Color", "titleColor", "control alt T", submenuTitle, true);
        this._disabled.add(submenuTitle);
        JMenu submenuColorMap = new JMenu("Color map");
        this.configMenuItem(this._itemShowColorMap, "toggleshowcolormap", "control shift L", submenuColorMap, false);
        this.createMenuItem("Caption", "colormapcaption", "control shift C", submenuColorMap, true);
        this.createMenuItem("Style...", "colormapstyle", "control L", submenuColorMap, false);
        submenuColorMap.addSeparator();
        this.createMenuItem("Edit values...", "colormapvalues", "shift L", submenuColorMap, true);
        this.createMenuItem("Load values...", "colormaploadvalues", "control shift K", submenuColorMap, true);
        this._disabled.add(submenuColorMap);
        JMenu submenuMisc = new JMenu("Misc");
        this.createMenuItem("Num. period.", "numPeriod", "control M", submenuMisc);
        this.createMenuItem("Background color", "background", "control G", submenuMisc);
        submenuMisc.add(submenuTitle);
        this.add(submenuStyle);
        this.add(submenuColorMap);
        this.add(submenuMisc);
    }

    private void editRNAMenu() {
        this.createMenuItem("Bases...", "editallbases", "", this, true);
        this.createMenuItem("BasePairs...", "editallbps", "", this, true);
    }

    private void redrawMenu() {
        JMenu submenuRedraw = new JMenu("Redraw");
        this._disabled.add(submenuRedraw);
        JMenu submenuAlgorithms = new JMenu("Algorithm");
        this._disabled.add(submenuAlgorithms);
        this.createMenuItem("Linear", "line", "control 1", submenuAlgorithms, true);
        this.createMenuItem("Circular", "circular", "control 2", submenuAlgorithms, true);
        this.createMenuItem("Radiate", "radiate", "control 3", submenuAlgorithms, true);
        this.createMenuItem("NAView", "naview", "control 4", submenuAlgorithms, true);
        submenuRedraw.add(submenuAlgorithms);
        this._bpHeightIncrement = this.createMenuItem("BP height increment", "bpheightincrement", "control H", submenuRedraw);
        this.configMenuItem(this._itemFlatExteriorLoop, "flat", "control F", submenuRedraw, true);
        this.createMenuItem("Space between bases", "spaceBetweenBases", "control shift S", submenuRedraw, true);
        this.createMenuItem("Reset", "reset", "control shift R", submenuRedraw, true);
        this.add(submenuRedraw);
    }

    private void warningMenu() {
        this.configMenuItem(this._itemShowWarnings, "showwarnings", "", this, true);
    }

    private void viewMenu() {
        JMenu submenuView = new JMenu("View");
        JMenu zoomDisplay = new JMenu("Zoom");
        this.createMenuItem("25%", "zoom25", "", zoomDisplay);
        this.createMenuItem("50%", "zoom50", "", zoomDisplay);
        this.createMenuItem("100%", "zoom100", "", zoomDisplay);
        this.createMenuItem("150%", "zoom150", "", zoomDisplay);
        this.createMenuItem("200%", "zoom200", "", zoomDisplay);
        this.createMenuItem("Custom", "zoom", "control Z", zoomDisplay);
        submenuView.add(zoomDisplay);
        this._rotation = this.createMenuItem("Rotation...", "rotation", "control R", submenuView);
        submenuView.addSeparator();
        this.createMenuItem("Border size", "borderSize", "control B", submenuView);
        this.add(submenuView);
    }

    public void addSelectionMenu(JMenuItem s) {
        this._selectionMenuIndex = s;
        this._disabled.add(s);
        this.insert(s, this.getComponentCount() - 2);
    }

    public void removeSelectionMenu() {
        if (this._selectionMenuIndex != null) {
            this.remove(this._selectionMenuIndex);
            this._selectionMenuIndex = null;
        }
    }

    private void colorClassesMenu() {
        this._subMenuBases = new JMenu("Colors");
        this._disabled.add(this._subMenuBases);
        this.createMenuItem("By Base", "eachKind", "control U", this._subMenuBases, true);
        this.createMenuItem("By BP", "eachCouple", "shift U", this._subMenuBases, true);
        this.createMenuItem("By Position", "eachBase", "alt U", this._subMenuBases, true);
        this.add(this._subMenuBases);
    }

    public void addColorOptions(JMenu submenu) {
        this.createMenuItem("Fill Color", String.valueOf(submenu.getActionCommand()) + ",InnerColor", "", submenu, true);
        this.createMenuItem("Stroke Color", String.valueOf(submenu.getActionCommand()) + ",OutlineColor", "", submenu, true);
        this.createMenuItem("Label Color", String.valueOf(submenu.getActionCommand()) + ",NameColor", "", submenu, true);
        submenu.addSeparator();
        this.createMenuItem("BP Color", String.valueOf(submenu.getActionCommand()) + ",BPColor", "", submenu, true);
        this.createMenuItem("BP Thickness", String.valueOf(submenu.getActionCommand()) + ",BPThickness", "", submenu, true);
        submenu.addSeparator();
        this.createMenuItem("Number Color", String.valueOf(submenu.getActionCommand()) + ",NumberColor", "", submenu, true);
    }

    private void aboutMenu() {
        this.addSeparator();
        this.createMenuItem("About VARNA", "about", "control A", this);
    }

    public void addAnnotationMenu(JMenu menu) {
        this.addAnnotationMenu(menu, false);
    }

    public void addAnnotationMenu(JMenu menu, boolean existingAnnot) {
        String title = "Annotation";
        if (existingAnnot) {
            String debut = "";
            String texte = this._vp.get_selectedAnnotation().getTexte();
            debut = texte.length() < 5 ? texte : String.valueOf(texte.substring(0, 5)) + "...";
            title = "Annotation: " + debut;
        }
        JMenu menuAnnotation = new JMenu(title);
        if (!existingAnnot) {
            this.createMenuItem("Add", String.valueOf(menu.getActionCommand()) + "annotationadd", "", menuAnnotation, true);
        }
        this.createMenuItem("Edit", String.valueOf(menu.getActionCommand()) + "annotationedit", "", menuAnnotation, true);
        this.createMenuItem("Remove", String.valueOf(menu.getActionCommand()) + "annotationremove", "", menuAnnotation, true);
        menu.add(menuAnnotation);
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public ControleurMenu get_controleurMenu() {
        return this._controlerMenu;
    }

    public JCheckBoxMenuItem get_itemOptionSpecialBaseColored() {
        return this._itemOptionSpecialBaseColored;
    }

    public JCheckBoxMenuItem get_itemShowWarnings() {
        return this._itemShowWarnings;
    }

    public JCheckBoxMenuItem get_itemOptionDashBaseColored() {
        return this._itemOptionGapsBaseColored;
    }

    public void set_controleurMenu(ControleurMenu menu) {
        this._controlerMenu = menu;
    }

    public void set_itemOptionSpecialBaseColored(JCheckBoxMenuItem optionSpecialBaseColored) {
        this._itemOptionSpecialBaseColored = optionSpecialBaseColored;
    }

    public void set_itemShowWarnings(JCheckBoxMenuItem showWarnings) {
        this._itemShowWarnings = showWarnings;
    }

    public void set_itemOptionDashBaseColored(JCheckBoxMenuItem optionDashBaseColored) {
        this._itemOptionGapsBaseColored = optionDashBaseColored;
    }

    public JMenuItem get_rotation() {
        return this._rotation;
    }

    public void set_rotation(JMenuItem _rotation) {
        this._rotation = _rotation;
    }

    public JCheckBoxMenuItem get_itemOptionBondsColored() {
        return this._itemOptionBondsColored;
    }

    public void set_itemOptionBondsColored(JCheckBoxMenuItem optionBondsColored) {
        this._itemOptionBondsColored = optionBondsColored;
    }

    public void show(Component invoker, int x, int y) {
        this._spawnOrigin = new Point(x, y);
        super.show(invoker, x, y);
    }

    public Point getSpawnPoint() {
        return this._spawnOrigin;
    }
}

