/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.GradientEditorPanel;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VueColorMapStyle
extends JPanel
implements ActionListener,
ItemListener,
PropertyChangeListener {
    private VARNAPanel _vp;
    private GradientEditorPanel _gp;
    private JComboBox _cb;
    private JTextField _code;
    private ModeleColorMap _backup;

    public VueColorMapStyle(VARNAPanel vp) {
        this._vp = vp;
        this.init();
    }

    private void init() {
        JLabel gradientCaption = new JLabel("Click gradient to add new color...");
        this._gp = new GradientEditorPanel(this._vp.getColorMap().clone());
        this._backup = this._vp.getColorMap();
        this._gp.setPreferredSize(new Dimension(300, 70));
        this._gp.addPropertyChangeListener(this);
        JPanel codePanel = new JPanel();
        JLabel codeCaption = new JLabel("Param. code: ");
        this._code = new JTextField("");
        this._code.setFont(Font.decode("Monospaced-PLAIN-12"));
        this._code.setEditable(false);
        this._code.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                VueColorMapStyle.this._code.setSelectionStart(0);
                VueColorMapStyle.this._code.setSelectionEnd(VueColorMapStyle.this._code.getText().length());
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        ModeleColorMap.NamedColorMapTypes[] palettes = ModeleColorMap.NamedColorMapTypes.values();
        Arrays.sort(palettes, new Comparator<ModeleColorMap.NamedColorMapTypes>(){

            @Override
            public int compare(ModeleColorMap.NamedColorMapTypes arg0, ModeleColorMap.NamedColorMapTypes arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        });
        Object[] finalArray = new Object[palettes.length + 1];
        int selected = -1;
        int i = 0;
        while (i < palettes.length) {
            if (palettes[i].getColorMap().equals(this._vp.getColorMap())) {
                selected = i;
            }
            finalArray[i] = palettes[i];
            ++i;
        }
        String custom = new String("Custom...");
        finalArray[palettes.length] = custom;
        this._cb = new JComboBox<Object>(finalArray);
        if (selected != -1) {
            this._cb.setSelectedIndex(selected);
            this._code.setText(palettes[selected].getId());
        } else {
            this._cb.setSelectedItem(finalArray.length - 1);
            this._code.setText(this._gp.getColorMap().getParamEncoding());
        }
        this._cb.addItemListener(this);
        codePanel.setLayout(new BoxLayout(codePanel, 2));
        codePanel.add(codeCaption);
        codePanel.add(this._code);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this._cb);
        this.add(gradientCaption);
        this.add(this._gp);
        this.add(codePanel);
    }

    public void cancelChanges() {
        this._vp.setColorMap(this._backup);
    }

    public ModeleColorMap getColorMap() {
        return this._gp.getColorMap();
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void refreshCode() {
        int selected = -1;
        ModeleColorMap.NamedColorMapTypes n = null;
        int i = 0;
        while (i < this._cb.getItemCount() - 1) {
            ModeleColorMap.NamedColorMapTypes ni;
            Object o = this._cb.getItemAt(i);
            if (o instanceof ModeleColorMap.NamedColorMapTypes && (ni = (ModeleColorMap.NamedColorMapTypes)((Object)o)).getColorMap().equals(this._gp.getColorMap())) {
                selected = i;
                n = ni;
            }
            ++i;
        }
        if (selected != -1) {
            this._code.setText(n.getId());
            this._cb.setSelectedIndex(selected);
        } else {
            this._code.setText(this._gp.getColorMap().getParamEncoding());
        }
        this._vp.setColorMap(this._gp.getColorMap());
        this._gp.repaint();
    }

    public void itemStateChanged(ItemEvent arg0) {
        Object o;
        if (arg0.getStateChange() == 1 && (o = arg0.getItem()) instanceof ModeleColorMap.NamedColorMapTypes) {
            ModeleColorMap.NamedColorMapTypes n = (ModeleColorMap.NamedColorMapTypes)((Object)o);
            this._gp.setColorMap(n.getColorMap().clone());
            this.refreshCode();
        }
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals("PaletteChanged")) {
            this._cb.setSelectedIndex(this._cb.getItemCount() - 1);
            this.refreshCode();
        }
    }
}

