/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.BaseSpecialColorEditor;
import fr.orsay.lri.varna.components.BaseTableModel;
import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VueBases
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int KIND_MODE = 1;
    public static final int ALL_MODE = 2;
    public static final int COUPLE_MODE = 3;
    private int _mode;
    private VARNAPanel _vp;
    private ArrayList<BaseList> data = new ArrayList();
    private Hashtable<String, BaseList> revdata = new Hashtable();
    private JTable table;
    private BaseTableModel specialTableModel;

    public VueBases(VARNAPanel vp, int mode) {
        super(new GridLayout(1, 0));
        this._vp = vp;
        switch (mode) {
            case 1: {
                this._mode = 1;
                this.kindMode();
                break;
            }
            case 2: {
                this._mode = 2;
                this.allMode();
                break;
            }
            case 3: {
                this._mode = 3;
                this.coupleMode();
                break;
            }
        }
    }

    private BaseList locateOrAddList(String caption) {
        if (!this.revdata.containsKey(caption)) {
            BaseList mbl = new BaseList(caption);
            this.revdata.put(caption, mbl);
            this.data.add(mbl);
        }
        return this.revdata.get(caption);
    }

    private void coupleMode() {
        int i = 0;
        while (i < this._vp.getRNA().get_listeBases().size()) {
            int j = this._vp.getRNA().get_listeBases().get(i).getElementStructure();
            if (j > i) {
                String tmp1 = this._vp.getRNA().get_listeBases().get(i).getContent();
                String tmp2 = this._vp.getRNA().get_listeBases().get(j).getContent();
                String pairString = String.valueOf(tmp1) + "-" + tmp2;
                BaseList bl = this.locateOrAddList(pairString);
                bl.addBase(this._vp.getRNA().get_listeBases().get(i));
                bl.addBase(this._vp.getRNA().get_listeBases().get(j));
            }
            ++i;
        }
        this.createView();
    }

    private void allMode() {
        int i = 0;
        while (i < this._vp.getRNA().get_listeBases().size()) {
            ModeleBase mb = this._vp.getRNA().get_listeBases().get(i);
            BaseList bl = this.locateOrAddList("" + i);
            bl.addBase(mb);
            ++i;
        }
        this.createView();
    }

    private void kindMode() {
        int i = 0;
        while (i < this._vp.getRNA().get_listeBases().size()) {
            ModeleBase mb = this._vp.getRNA().get_listeBases().get(i);
            String tmp1 = mb.getContent();
            BaseList bl = this.locateOrAddList(tmp1);
            bl.addBase(mb);
            ++i;
        }
        this.createView();
    }

    private void createView() {
        this.specialTableModel = new BaseTableModel(this.data);
        this.table = new JTable(this.specialTableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultEditor(Color.class, new BaseSpecialColorEditor(this));
        this.specialTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                VueBases.this._vp.repaint();
            }
        });
        this.add(scrollPane);
        this.UIvueBases();
    }

    public void UIvueBases() {
        VueBases newContentPane = this;
        newContentPane.setOpaque(true);
        JOptionPane.showMessageDialog(this._vp, newContentPane, "Base Colors Edition", -1);
    }

    public int getMode() {
        return this._mode;
    }

    public BaseList getDataAt(int i) {
        return this.data.get(i);
    }

    public ArrayList<BaseList> getData() {
        return this.data;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public BaseTableModel getSpecialTableModel() {
        return this.specialTableModel;
    }

    public void setSpecialTableModel(BaseTableModel specialTableModel) {
        this.specialTableModel = specialTableModel;
    }
}

