/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class VueBaseValues
extends JPanel
implements TableModelListener {
    private JTable table;
    private ValueTableModel _tm;
    private VARNAPanel _vp;
    private ArrayList<ModeleBase> data;
    private ArrayList<Double> _backup;
    private ArrayList<Object> columns;

    public VueBaseValues(VARNAPanel vp) {
        super(new GridLayout(1, 0));
        this._vp = vp;
        this.init();
    }

    private void init() {
        Object[] col = new Object[]{"Number", "Base", "Value", "Preview"};
        this.columns = new ArrayList();
        int i = 0;
        while (i < col.length) {
            this.columns.add(col[i]);
            ++i;
        }
        this._backup = new ArrayList();
        this.data = new ArrayList();
        i = 0;
        while (i < this._vp.getRNA().get_listeBases().size()) {
            ModeleBase mb = this._vp.getRNA().get_listeBases().get(i);
            this.data.add(mb);
            this._backup.add(mb.getValue());
            ++i;
        }
        this._tm = new ValueTableModel();
        this.table = new JTable(this._tm);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.table.getModel().addTableModelListener(this);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
    }

    public void cancelChanges() {
        int i = 0;
        while (i < this._vp.getRNA().get_listeBases().size()) {
            ModeleBase mb = this._vp.getRNA().get_listeBases().get(i);
            mb.setValue(this._backup.get(i));
            ++i;
        }
        this._vp.getRNA().rescaleColorMap(this._vp.getColorMap());
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            this.table.repaint();
        }
    }

    private class ValueTableModel
    extends AbstractTableModel {
        private ValueTableModel() {
        }

        public String getColumnName(int col) {
            return VueBaseValues.this.columns.get(col).toString();
        }

        public int getRowCount() {
            return VueBaseValues.this.data.size();
        }

        public int getColumnCount() {
            return VueBaseValues.this.columns.size();
        }

        public Object getValueAt(int row, int col) {
            ModeleBase mb = (ModeleBase)VueBaseValues.this.data.get(row);
            if (col == 0) {
                return new Integer(mb.getBaseNumber());
            }
            if (col == 1) {
                return new String(mb.getContent());
            }
            if (col == 2) {
                return new Double(mb.getValue());
            }
            if (col == 3) {
                return VueBaseValues.this._vp.getColorMap().getColorForValue(mb.getValue());
            }
            return "N/A";
        }

        public boolean isCellEditable(int row, int col) {
            return this.getColumnName(col).equals("Value");
        }

        public void setValueAt(Object value, int row, int col) {
            if (this.getColumnName(col).equals("Value")) {
                ((ModeleBase)VueBaseValues.this.data.get(row)).setValue((Double)value);
                VueBaseValues.this._vp.getRNA().rescaleColorMap(VueBaseValues.this._vp.getColorMap());
                VueBaseValues.this._vp.repaint();
                this.fireTableCellUpdated(row, col);
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

