/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurSliderLabel;
import fr.orsay.lri.varna.controlers.ControleurVueAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.views.VueFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicBorders;

public class VueAnnotation {
    private VARNAPanel _vp;
    private JSlider ySlider;
    private JSlider xSlider;
    private JButton colorButton;
    private JTextArea textArea;
    private JPanel panel;
    private TextAnnotation textAnnotation;
    private TextAnnotation textAnnotationSave;
    private VueFont vueFont;
    private ControleurVueAnnotation _controleurVueAnnotation;
    private boolean newAnnotation;
    private boolean limited;
    private Point2D.Double position;
    private JSlider rotationSlider;

    public VueAnnotation(VARNAPanel vp, boolean limited) {
        this(vp, (int)(vp.getExtendedRNABBox().x + vp.getExtendedRNABBox().width / 2.0), (int)(vp.getExtendedRNABBox().y + vp.getExtendedRNABBox().height / 2.0), limited);
    }

    public VueAnnotation(VARNAPanel vp) {
        this(vp, false);
    }

    public VueAnnotation(VARNAPanel vp, int x, int y) {
        this(vp, x, y, false);
    }

    public VueAnnotation(VARNAPanel vp, int x, int y, boolean limited) {
        this(vp, new TextAnnotation("", x, y), false, true);
    }

    public VueAnnotation(VARNAPanel vp, TextAnnotation textAnnot, boolean newAnnotation) {
        this(vp, textAnnot, textAnnot.getType() != TextAnnotation.AnchorType.POSITION, newAnnotation);
    }

    public VueAnnotation(VARNAPanel vp, TextAnnotation textAnnot, boolean reduite, boolean newAnnotation) {
        this.limited = reduite;
        this.newAnnotation = newAnnotation;
        this._vp = vp;
        this.textAnnotation = textAnnot;
        this.textAnnotationSave = this.textAnnotation.clone();
        if (!this._vp.getListeAnnotations().contains(textAnnot)) {
            this._vp.addAnnotation(this.textAnnotation);
        }
        this._controleurVueAnnotation = new ControleurVueAnnotation(this);
        this.position = this.textAnnotation.getCenterPosition();
        JPanel py = new JPanel();
        JPanel px = new JPanel();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(0, 1));
        py.setLayout(new FlowLayout(0));
        px.setLayout(new FlowLayout(0));
        this.ySlider = new JSlider(0, 0, (int)this._vp.getExtendedRNABBox().height, Math.max(0, Math.min((int)this._vp.getExtendedRNABBox().height, (int)(this.position.y - this._vp.getExtendedRNABBox().y))));
        this.ySlider.setMajorTickSpacing(500);
        this.ySlider.setMinorTickSpacing(100);
        this.ySlider.setPaintTicks(true);
        this.ySlider.setPaintLabels(true);
        this.ySlider.setPreferredSize(new Dimension(400, this.ySlider.getPreferredSize().height));
        JLabel yValueLabel = new JLabel(String.valueOf((double)((int)this.position.y) - this._vp.getExtendedRNABBox().y));
        yValueLabel.setPreferredSize(new Dimension(50, yValueLabel.getPreferredSize().height));
        this.ySlider.addChangeListener(new ControleurSliderLabel(yValueLabel, false));
        this.ySlider.addChangeListener(this._controleurVueAnnotation);
        this.xSlider = new JSlider(0, 0, (int)this._vp.getExtendedRNABBox().width, Math.max(0, Math.min((int)this._vp.getExtendedRNABBox().width, (int)(this.position.x - this._vp.getExtendedRNABBox().x))));
        this.xSlider.setMajorTickSpacing(500);
        this.xSlider.setMinorTickSpacing(100);
        this.xSlider.setPaintTicks(true);
        this.xSlider.setPaintLabels(true);
        this.xSlider.setPreferredSize(new Dimension(400, this.xSlider.getPreferredSize().height));
        JLabel xValueLabel = new JLabel(String.valueOf((double)((int)this.position.x) - this._vp.getExtendedRNABBox().x));
        xValueLabel.setPreferredSize(new Dimension(50, xValueLabel.getPreferredSize().height));
        this.xSlider.addChangeListener(new ControleurSliderLabel(xValueLabel, false));
        this.xSlider.addChangeListener(this._controleurVueAnnotation);
        JLabel labelY = new JLabel("Y:");
        JLabel labelX = new JLabel("X:");
        py.add(labelY);
        py.add(this.ySlider);
        py.add(yValueLabel);
        px.add(labelX);
        px.add(this.xSlider);
        px.add(xValueLabel);
        JPanel panelTexte = new JPanel();
        panelTexte.setLayout(new BorderLayout());
        this.textArea = new JTextArea(this.textAnnotation.getTexte());
        this.textArea.addCaretListener(this._controleurVueAnnotation);
        this.textArea.setPreferredSize(panelTexte.getSize());
        BasicBorders.FieldBorder border = new BasicBorders.FieldBorder(Color.black, Color.black, Color.black, Color.black);
        this.textArea.setBorder(border);
        JLabel labelTexte = new JLabel("Text:");
        panelTexte.add((Component)this.textArea, "Center");
        panelTexte.add((Component)labelTexte, "North");
        this.panel.add(panelTexte);
        this.vueFont = new VueFont(textAnnot.getFont());
        this.vueFont.getBoxPolice().addActionListener(this._controleurVueAnnotation);
        this.vueFont.getSizeSlider().addChangeListener(this._controleurVueAnnotation);
        this.vueFont.getStylesBox().addActionListener(this._controleurVueAnnotation);
        this.colorButton = new JButton("Set color");
        this.colorButton.setActionCommand("setcolor");
        this.colorButton.setForeground(textAnnot.getColor());
        this.colorButton.addActionListener(this._controleurVueAnnotation);
        JPanel fontAndColor = new JPanel();
        fontAndColor.add(this.vueFont.getPanel());
        fontAndColor.add(this.colorButton);
        this.panel.add(fontAndColor);
        JPanel rotationPanel = new JPanel();
        this.rotationSlider = new JSlider(0, -360, 360, (int)this.textAnnotation.getAngleInDegres());
        this.rotationSlider.setMajorTickSpacing(60);
        this.rotationSlider.setPaintTicks(true);
        this.rotationSlider.setPaintLabels(true);
        this.rotationSlider.setPreferredSize(new Dimension(500, 50));
        JLabel rotationLabel = new JLabel(String.valueOf(0));
        rotationLabel.setPreferredSize(new Dimension(50, rotationLabel.getPreferredSize().height));
        this.rotationSlider.addChangeListener(new ControleurSliderLabel(rotationLabel, false));
        this.rotationSlider.addChangeListener(this._controleurVueAnnotation);
        JLabel labelZ = new JLabel("Rotation (degrees):");
        rotationPanel.add(labelZ);
        rotationPanel.add(this.rotationSlider);
        rotationPanel.add(rotationLabel);
        if (this.limited) {
            this.ySlider.setEnabled(false);
            this.xSlider.setEnabled(false);
            this.rotationSlider.setEnabled(false);
        }
        this.textArea.requestFocusInWindow();
    }

    private void applyFont() {
        this.textAnnotation.setFont(this.vueFont.getFont());
    }

    public void update() {
        this.applyFont();
        if (this.textAnnotation.getType() == TextAnnotation.AnchorType.POSITION) {
            this.textAnnotation.setAncrage((double)this.xSlider.getValue() + this._vp.getExtendedRNABBox().x, (double)this.ySlider.getValue() + this._vp.getExtendedRNABBox().y);
        }
        this.textAnnotation.setText(this.textArea.getText());
        this.textAnnotation.setAngleInDegres(this.rotationSlider.getValue());
        this._vp.clearSelection();
        this._vp.repaint();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public TextAnnotation getTextAnnotation() {
        return this.textAnnotation;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public void show() {
        this._vp.set_selectedAnnotation(this.textAnnotation);
        this._vp.highlightSelectedAnnotation();
        if (JOptionPane.showConfirmDialog(this._vp, this.getPanel(), "Add/edit annotation", 2, -1) == 0) {
            this.update();
        } else if (this.newAnnotation) {
            this._vp.set_selectedAnnotation(null);
            if (!this._vp.removeAnnotation(this.textAnnotation)) {
                this._vp.errorDialog(new Exception("Impossible de supprimer"));
            }
        } else {
            this.textAnnotation.copy(this.textAnnotationSave);
        }
        this._vp.resetAnnotationHighlight();
        this._vp.set_selectedAnnotation(null);
        this._vp.repaint();
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public boolean isNewAnnotation() {
        return this.newAnnotation;
    }

    public void updateColor(Color c) {
        this.colorButton.setForeground(c);
        this.textAnnotation.setColor(c);
    }
}

