/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.utils;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBPStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VARNASessionParser
extends DefaultHandler {
    StringBuffer _buffer = null;
    ModeleBaseNucleotide mbn = null;
    ModeleBasesComparison mbc = null;
    ModeleBP mbp = null;
    ModeleBPStyle mbps = null;
    ModelBaseStyle msb = null;
    TextAnnotation ta = null;
    HighlightRegionAnnotation hra = null;
    RNA rna = null;
    Font f = null;
    VARNAConfig config = null;
    private TreeSet<String> _context = new TreeSet();

    public InputSource createSourceFromURL(String path) {
        URL url = null;
        try {
            url = new URL(path);
            URLConnection connexion = url.openConnection();
            connexion.setUseCaches(false);
            InputStream r = connexion.getInputStream();
            InputStreamReader inr = new InputStreamReader(r);
            return new InputSource(inr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new InputSource(new StringReader(""));
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new StringReader(""));
    }

    private void addToContext(String s) {
        this._context.add(s);
    }

    private void removeFromContext(String s) {
        this._context.remove(s);
    }

    private boolean contextContains(String s) {
        return this._context.contains(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!qName.equals(VARNAPanel.XML_ELEMENT_NAME)) {
            if (qName.equals(VARNAConfig.XML_ELEMENT_NAME)) {
                this.config = new VARNAConfig();
                this.config.loadFromXMLAttributes(attributes);
            } else if (qName.equals(RNA.XML_ELEMENT_NAME)) {
                this.rna = new RNA();
            } else if (qName.equals(ModeleBaseNucleotide.XML_ELEMENT_NAME)) {
                if (this.rna != null) {
                    this.mbn = new ModeleBaseNucleotide(this.rna.getSize());
                    if (this.mbn.getIndex() != Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_INDEX_NAME))) {
                        throw new SAXException("Index mismatch for Base");
                    }
                    this.mbn.setBaseNumber(Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_NUMBER_NAME)));
                    this.mbn.setColorie(Boolean.parseBoolean(attributes.getValue(ModeleBase.XML_VAR_CUSTOM_DRAWN_NAME)));
                    this.mbn.setValue(Double.parseDouble(attributes.getValue(ModeleBase.XML_VAR_VALUE_NAME)));
                    this.rna.addBase(this.mbn);
                }
            } else if (qName.equals(XMLUtils.XML_FONT_ELEMENT_NAME)) {
                this.f = XMLUtils.getFont(qName, attributes);
                if (this.contextContains(TextAnnotation.XML_ELEMENT_NAME)) {
                    this.ta.setFont(this.f);
                    this.f = null;
                } else if (this.contextContains(VARNAConfig.XML_ELEMENT_NAME)) {
                    String role = attributes.getValue(XMLUtils.XML_ROLE_NAME);
                    if (role.equals(VARNAConfig.XML_VAR_TITLE_FONT)) {
                        this.config._titleFont = XMLUtils.getFont(qName, attributes);
                    } else if (role.equals(VARNAConfig.XML_VAR_NUMBERS_FONT)) {
                        this.config._numbersFont = XMLUtils.getFont(qName, attributes);
                    } else if (role.equals(VARNAConfig.XML_VAR_FONT_BASES)) {
                        this.config._fontBasesGeneral = XMLUtils.getFont(qName, attributes);
                    }
                }
            } else if (qName.equals(ModeleBaseNucleotide.XML_VAR_CONTENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (qName.equals(ModeleBasesComparison.XML_VAR_FIRST_CONTENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (qName.equals(ModeleBasesComparison.XML_VAR_SECOND_CONTENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (qName.equals(ModeleBasesComparison.XML_ELEMENT_NAME)) {
                if (this.rna != null) {
                    this.mbc = new ModeleBasesComparison(this.rna.getSize());
                    if (this.mbc.getIndex() != Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_INDEX_NAME))) {
                        throw new SAXException("Index mismatch for Base");
                    }
                    this.mbc.setBaseNumber(Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_NUMBER_NAME)));
                    this.mbc.set_appartenance(Integer.parseInt(attributes.getValue(ModeleBasesComparison.XML_VAR_MEMBERSHIP_NAME)));
                    this.mbc.setColorie(Boolean.parseBoolean(attributes.getValue(ModeleBase.XML_VAR_CUSTOM_DRAWN_NAME)));
                    this.mbc.setValue(Double.parseDouble(attributes.getValue(ModeleBase.XML_VAR_VALUE_NAME)));
                    this.rna.addBase(this.mbc);
                }
            } else if (qName.equals(ModeleBP.XML_ELEMENT_NAME)) {
                ModeleBP.Edge e5 = ModeleBP.Edge.valueOf(attributes.getValue(ModeleBP.XML_VAR_EDGE5_NAME));
                ModeleBP.Edge e3 = ModeleBP.Edge.valueOf(attributes.getValue(ModeleBP.XML_VAR_EDGE3_NAME));
                ModeleBP.Stericity s = ModeleBP.Stericity.valueOf(attributes.getValue(ModeleBP.XML_VAR_STERICITY_NAME));
                int i5 = Integer.parseInt(attributes.getValue(ModeleBP.XML_VAR_PARTNER5_NAME));
                int i3 = Integer.parseInt(attributes.getValue(ModeleBP.XML_VAR_PARTNER3_NAME));
                boolean inSecStr = Boolean.parseBoolean(attributes.getValue(ModeleBP.XML_VAR_SEC_STR_NAME));
                this.mbp = new ModeleBP(this.rna.getBaseAt(i5), this.rna.getBaseAt(i3), e5, e3, s);
                if (inSecStr) {
                    this.rna.addBP(i5, i3, this.mbp);
                } else {
                    this.rna.addBPAux(i5, i3, this.mbp);
                }
            } else if (qName.equals(ChemProbAnnotation.XML_ELEMENT_NAME)) {
                int i5 = Integer.parseInt(attributes.getValue(ChemProbAnnotation.XML_VAR_INDEX5_NAME));
                int i3 = Integer.parseInt(attributes.getValue(ChemProbAnnotation.XML_VAR_INDEX3_NAME));
                ChemProbAnnotation cpa = new ChemProbAnnotation(this.rna.getBaseAt(i5), this.rna.getBaseAt(i3));
                cpa.setColor(Color.decode(attributes.getValue(ChemProbAnnotation.XML_VAR_COLOR_NAME)));
                cpa.setIntensity(Double.parseDouble(attributes.getValue(ChemProbAnnotation.XML_VAR_INTENSITY_NAME)));
                cpa.setType(ChemProbAnnotation.ChemProbAnnotationType.valueOf(attributes.getValue(ChemProbAnnotation.XML_VAR_TYPE_NAME)));
                cpa.setOut(Boolean.parseBoolean(attributes.getValue(ChemProbAnnotation.XML_VAR_OUTWARD_NAME)));
                this.rna.addChemProbAnnotation(cpa);
            } else if (qName.equals(TextAnnotation.XML_VAR_TEXT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (qName.equals(VARNAConfig.XML_VAR_TITLE)) {
                this._buffer = new StringBuffer();
            } else if (qName.equals(VARNAConfig.XML_VAR_CM_CAPTION)) {
                this._buffer = new StringBuffer();
            } else if (qName.equals(TextAnnotation.XML_ELEMENT_NAME)) {
                TextAnnotation.AnchorType t = TextAnnotation.AnchorType.valueOf(attributes.getValue(TextAnnotation.XML_VAR_TYPE_NAME));
                this.ta = new TextAnnotation("");
                this.ta.setColor(Color.decode(attributes.getValue(TextAnnotation.XML_VAR_COLOR_NAME)));
                this.ta.setAngleInDegres(Double.parseDouble(attributes.getValue(TextAnnotation.XML_VAR_ANGLE_NAME)));
                this.ta.setType(t);
            } else if (qName.equals(HighlightRegionAnnotation.XML_ELEMENT_NAME)) {
                this.hra = new HighlightRegionAnnotation();
                this.rna.addHighlightRegion(this.hra);
                this.hra.setOutlineColor(Color.decode(attributes.getValue(HighlightRegionAnnotation.XML_VAR_OUTLINE_NAME)));
                this.hra.setFillColor(Color.decode(attributes.getValue(HighlightRegionAnnotation.XML_VAR_FILL_NAME)));
                this.hra.setRadius(Double.parseDouble(attributes.getValue(HighlightRegionAnnotation.XML_VAR_RADIUS_NAME)));
            } else if (qName.equals(XMLUtils.XML_BASELIST_ELEMENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (qName.equals(VARNAPoint.XML_ELEMENT_NAME)) {
                Point2D.Double vp = new Point2D.Double();
                vp.x = Double.parseDouble(attributes.getValue(VARNAPoint.XML_VAR_X_NAME));
                vp.y = Double.parseDouble(attributes.getValue(VARNAPoint.XML_VAR_Y_NAME));
                String role = attributes.getValue(VARNAPoint.XML_VAR_ROLE_NAME);
                if (this.contextContains(ModeleBaseNucleotide.XML_ELEMENT_NAME) && role != null) {
                    if (role.equals(ModeleBase.XML_VAR_POSITION_NAME)) {
                        if (this.mbn == null) throw new SAXException("No Base model for this position Point");
                        this.mbn.setCoords(vp);
                    } else if (role.equals(ModeleBase.XML_VAR_CENTER_NAME)) {
                        if (this.mbn == null) throw new SAXException("No Base model for this center Point");
                        this.mbn.setCenter(vp);
                    }
                }
                if (this.contextContains(ModeleBasesComparison.XML_ELEMENT_NAME) && role != null) {
                    if (role.equals(ModeleBase.XML_VAR_POSITION_NAME)) {
                        if (this.mbc == null) throw new SAXException("No Base model for this position Point");
                        this.mbc.setCoords(vp);
                    } else if (role.equals(ModeleBase.XML_VAR_CENTER_NAME)) {
                        if (this.mbc == null) throw new SAXException("No Base model for this center Point");
                        this.mbc.setCenter(vp);
                    }
                }
                if (this.contextContains(TextAnnotation.XML_ELEMENT_NAME)) {
                    if (this.ta == null) throw new SAXException("No TextAnnotation model for this Point");
                    this.ta.setAncrage(vp.x, vp.y);
                }
            } else if (qName.equals(ModelBaseStyle.XML_ELEMENT_NAME)) {
                this.msb = new ModelBaseStyle();
                this.msb.setBaseOutlineColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_OUTLINE_NAME)));
                this.msb.setBaseInnerColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_INNER_NAME)));
                this.msb.setBaseNameColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_NAME_NAME)));
                this.msb.setBaseNumberColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_NUMBER_NAME)));
                if (this.mbn != null) {
                    this.mbn.setStyleBase(this.msb);
                } else if (this.mbc != null) {
                    this.mbc.setStyleBase(this.msb);
                }
                this.msb = null;
            } else if (qName.equals(ModeleBPStyle.XML_ELEMENT_NAME)) {
                this.mbps = new ModeleBPStyle();
                boolean customColor = Boolean.parseBoolean(attributes.getValue(ModeleBPStyle.XML_VAR_CUSTOM_STYLED_NAME));
                if (customColor) {
                    this.mbps.setCustomColor(Color.decode(attributes.getValue(ModeleBPStyle.XML_VAR_COLOR_NAME)));
                }
                this.mbps.setThickness(Double.parseDouble(attributes.getValue(ModeleBPStyle.XML_VAR_THICKNESS_NAME)));
                this.mbps.setBent(Double.parseDouble(attributes.getValue(ModeleBPStyle.XML_VAR_BENT_NAME)));
                if (this.mbp != null) {
                    this.mbp.setStyle(this.mbps);
                }
                this.mbps = null;
            }
        }
        this.addToContext(qName);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(ModeleBaseNucleotide.XML_VAR_CONTENT_NAME)) {
            if (this._buffer == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            if (this.mbn == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            String val = this._buffer.toString();
            this.mbn.setContent(val);
        } else if (qName.equals(ModeleBasesComparison.XML_VAR_FIRST_CONTENT_NAME)) {
            if (this._buffer == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            if (this.mbc == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            String val = this._buffer.toString();
            this.mbc.setBase1(Character.valueOf(val.trim().charAt(0)));
        } else if (qName.equals(ModeleBasesComparison.XML_VAR_SECOND_CONTENT_NAME)) {
            if (this._buffer == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            if (this.mbc == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            String val = this._buffer.toString();
            this.mbc.setBase2(Character.valueOf(val.trim().charAt(0)));
        } else if (qName.equals(ModeleBaseNucleotide.XML_ELEMENT_NAME)) {
            this.mbn = null;
        } else if (qName.equals(ModeleBP.XML_ELEMENT_NAME)) {
            this.mbp = null;
        } else if (qName.equals(HighlightRegionAnnotation.XML_ELEMENT_NAME)) {
            this.hra = null;
        } else if (qName.equals(TextAnnotation.XML_VAR_TEXT_NAME)) {
            String text = this._buffer.toString();
            this.ta.setText(text);
            this._buffer = null;
        } else if (qName.equals(VARNAConfig.XML_VAR_TITLE)) {
            this.config._title = this._buffer.toString();
            this._buffer = null;
        } else if (qName.equals(VARNAConfig.XML_VAR_CM_CAPTION)) {
            this.config._colorMapCaption = this._buffer.toString();
            this._buffer = null;
        } else if (qName.equals(TextAnnotation.XML_ELEMENT_NAME)) {
            this.rna.addAnnotation(this.ta);
            this.ta = null;
        } else if (qName.equals(XMLUtils.XML_BASELIST_ELEMENT_NAME)) {
            String result = this._buffer.toString();
            ArrayList<ModeleBase> al = XMLUtils.toModeleBaseArray(result, this.rna);
            if (this.contextContains(TextAnnotation.XML_ELEMENT_NAME)) {
                switch (this.ta.getType()) {
                    case POSITION: {
                        break;
                    }
                    case BASE: {
                        this.ta.setAncrage(al.get(0));
                        break;
                    }
                    case HELIX: 
                    case LOOP: {
                        try {
                            this.ta.setAncrage(al, this.ta.getType());
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (this.contextContains(HighlightRegionAnnotation.XML_ELEMENT_NAME)) {
                this.hra.setBases(al);
            }
            this._buffer = null;
        }
        this.removeFromContext(qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String lecture = new String(ch, start, length);
        if (this._buffer != null) {
            this._buffer.append(lecture);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public RNA getRNA() {
        return this.rna;
    }

    public VARNAConfig getVARNAConfig() {
        return this.config;
    }
}

