/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.models.treealign.GraphvizDrawableNodeValue;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeGraphviz {
    public static void treeToGraphvizPostscript(Tree<? extends GraphvizDrawableNodeValue> tree, String filename, String title) throws IOException {
        String graphvizSource = TreeGraphviz.treeToGraphviz(tree, title);
        BufferedWriter fbw = new BufferedWriter(new FileWriter(filename));
        Process proc = Runtime.getRuntime().exec("dot -Tps");
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        bw.write(graphvizSource);
        bw.close();
        String line = null;
        while ((line = br.readLine()) != null) {
            fbw.write(String.valueOf(line) + "\n");
        }
        line = null;
        while ((line = bre.readLine()) != null) {
            System.err.println(line);
        }
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        fbw.close();
    }

    public static void treeToGraphvizPostscript(Tree<? extends GraphvizDrawableNodeValue> tree, String filename) throws IOException {
        TreeGraphviz.treeToGraphvizPostscript(tree, filename, filename);
    }

    public static void treeToGraphvizFile(Tree<? extends GraphvizDrawableNodeValue> tree, String filename, String title) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.write(TreeGraphviz.treeToGraphviz(tree, filename));
        bw.close();
    }

    public static void treeToGraphvizFile(Tree<? extends GraphvizDrawableNodeValue> tree, String filename) throws IOException {
        TreeGraphviz.treeToGraphvizFile(tree, filename, filename);
    }

    public static String treeToGraphviz(Tree<? extends GraphvizDrawableNodeValue> tree, String title) {
        return "digraph \"" + title + "\" {\n" + TreeGraphviz.subtreeToGraphviz(tree) + "}\n";
    }

    private static String subtreeToGraphviz(Tree<? extends GraphvizDrawableNodeValue> tree) {
        String s = "";
        String myId = tree.toGraphvizNodeId();
        s = String.valueOf(s) + "\"" + myId + "\" [label=\"" + (tree.getValue() != null ? tree.getValue().toGraphvizNodeName() : "null") + "\"]\n";
        for (Tree<? extends GraphvizDrawableNodeValue> child : tree.getChildren()) {
            s = String.valueOf(s) + "\"" + myId + "\" -> \"" + child.toGraphvizNodeId() + "\"\n";
            s = String.valueOf(s) + TreeGraphviz.subtreeToGraphviz(child);
        }
        return s;
    }
}

