/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.Tree;
import fr.orsay.lri.varna.models.treealign.TreeAlignException;
import fr.orsay.lri.varna.models.treealign.TreeAlignLabelDistanceAsymmetric;
import fr.orsay.lri.varna.models.treealign.TreeAlignResult;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAlign<ValueType1, ValueType2> {
    private TreeAlignLabelDistanceAsymmetric<ValueType1, ValueType2> labelDist;

    public TreeAlign(TreeAlignLabelDistanceAsymmetric<ValueType1, ValueType2> labelDist) {
        this.labelDist = labelDist;
    }

    public TreeAlignResult<ValueType1, ValueType2> align(Tree<ValueType1> T1, Tree<ValueType2> T2) throws TreeAlignException {
        TreeAlignResult result = new TreeAlignResult();
        Aligner aligner = new Aligner(T1, T2);
        result.setDistance(aligner.align());
        result.setAlignment(aligner.computeAlignment());
        return result;
    }

    public float distanceFromAlignment(Tree<AlignedNode<ValueType1, ValueType2>> alignment) {
        Tree<ValueType1> originalT1Node = alignment.getValue().getLeftNode();
        Tree<ValueType2> originalT2Node = alignment.getValue().getRightNode();
        float d = (float)this.labelDist.f(originalT1Node != null ? (Object)originalT1Node.getValue() : null, originalT2Node != null ? (Object)originalT2Node.getValue() : null);
        for (Tree<AlignedNode<ValueType1, ValueType2>> child : alignment.getChildren()) {
            d += this.distanceFromAlignment(child);
        }
        return d;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Aligner {
        private TreeData<ValueType1> treeData1;
        private TreeData<ValueType2> treeData2;
        private float[][][][] DF1;
        private float[][][][] DF2;
        private byte[][][][] DF1Decisions1;
        private short[][][][] DF1Decisions2;
        private byte[][][][] DF2Decisions1;
        private short[][][][] DF2Decisions2;
        private float[][] DT;
        private byte[][] DTDecisions1;
        private short[][] DTDecisions2;
        private float[][] DL;
        private float[] DET1;
        private float[] DET2;
        private float[] DEF1;
        private float[] DEF2;

        private void computeAlignmentP1(int i, int s, int m_i, int j, int t, int n_j, int DFx) {
            float[][] DFL = new float[m_i - s + 2][n_j - t + 2];
            DFL[0][0] = 0.0f;
            byte[][] DFLDecisions1 = new byte[m_i - s + 2][n_j - t + 2];
            short[][] DFLDecisions2 = new short[m_i - s + 2][n_j - t + 2];
            int i_s = m_i != 0 ? this.treeData1.children[i][s] : -1;
            int j_t = n_j != 0 ? this.treeData2.children[j][t] : -1;
            int p = s;
            while (p < m_i) {
                DFL[p - s + 1][0] = DFL[p - s][0] + this.DET1[this.treeData1.children[i][p]];
                ++p;
            }
            int q = t;
            while (q < n_j) {
                DFL[0][q - t + 1] = DFL[0][q - t] + this.DET2[this.treeData2.children[j][q]];
                ++q;
            }
            p = s;
            while (p < m_i) {
                int i_p = this.treeData1.children[i][p];
                int q2 = t;
                while (q2 < n_j) {
                    float d;
                    int j_q = this.treeData2.children[j][q2];
                    float min = Float.POSITIVE_INFINITY;
                    int decision1 = -1;
                    int decision2 = -1;
                    float minCandidate = DFL[p - s][q2 - t + 1] + this.DET1[i_p];
                    if (minCandidate < min) {
                        min = minCandidate;
                        decision1 = 1;
                    }
                    if ((minCandidate = DFL[p - s + 1][q2 - t] + this.DET2[j_q]) < min) {
                        min = minCandidate;
                        decision1 = 2;
                    }
                    if ((minCandidate = DFL[p - s][q2 - t] + this.DT[i_p][j_q]) < min) {
                        min = minCandidate;
                        decision1 = 3;
                    }
                    minCandidate = Float.POSITIVE_INFINITY;
                    int best_k = -1;
                    int k = s;
                    while (k < p) {
                        d = DFL[k - s][q2 - t] + this.DF2[j_q][this.treeData1.children[i][k]][p - k + 1][this.treeData2.degrees[j_q]];
                        if (d < minCandidate) {
                            minCandidate = d;
                            best_k = k;
                        }
                        ++k;
                    }
                    if ((minCandidate += this.DL[this.treeData1.size][j_q]) < min) {
                        min = minCandidate;
                        decision1 = 4;
                        decision2 = best_k;
                    }
                    minCandidate = Float.POSITIVE_INFINITY;
                    best_k = -1;
                    k = t;
                    while (k < q2) {
                        d = DFL[p - s][k - t] + this.DF1[i_p][this.treeData2.children[j][k]][this.treeData1.degrees[i_p]][q2 - k + 1];
                        if (d < minCandidate) {
                            minCandidate = d;
                            best_k = k;
                        }
                        ++k;
                    }
                    if ((minCandidate += this.DL[i_p][this.treeData2.size]) < min) {
                        min = minCandidate;
                        decision1 = 5;
                        decision2 = best_k;
                    }
                    DFL[p - s + 1][q2 - t + 1] = min;
                    DFLDecisions1[p - s + 1][q2 - t + 1] = (byte)decision1;
                    DFLDecisions2[p - s + 1][q2 - t + 1] = (short)decision2;
                    ++q2;
                }
                ++p;
            }
            if (DFx == 2) {
                this.DF2[j][i_s] = DFL;
                this.DF2Decisions1[j][i_s] = DFLDecisions1;
                this.DF2Decisions2[j][i_s] = DFLDecisions2;
            } else {
                this.DF1[i][j_t] = DFL;
                this.DF1Decisions1[i][j_t] = DFLDecisions1;
                this.DF1Decisions2[i][j_t] = DFLDecisions2;
            }
        }

        public float align() throws TreeAlignException {
            int k;
            int m_i;
            new ConvertTreeToArray(this.treeData1).convert();
            new ConvertTreeToArray(this.treeData2).convert();
            this.DT = new float[this.treeData1.size][this.treeData2.size];
            this.DTDecisions1 = new byte[this.treeData1.size][this.treeData2.size];
            this.DTDecisions2 = new short[this.treeData1.size][this.treeData2.size];
            this.DL = new float[this.treeData1.size + 1][this.treeData2.size + 1];
            this.DET1 = new float[this.treeData1.size];
            this.DET2 = new float[this.treeData2.size];
            this.DEF1 = new float[this.treeData1.size];
            this.DEF2 = new float[this.treeData2.size];
            this.DF1 = new float[this.treeData1.size][this.treeData2.size][][];
            this.DF1Decisions1 = new byte[this.treeData1.size][this.treeData2.size][][];
            this.DF1Decisions2 = new short[this.treeData1.size][this.treeData2.size][][];
            this.DF2 = new float[this.treeData2.size][this.treeData1.size][][];
            this.DF2Decisions1 = new byte[this.treeData2.size][this.treeData1.size][][];
            this.DF2Decisions2 = new short[this.treeData2.size][this.treeData1.size][][];
            this.DL[this.treeData1.size][this.treeData2.size] = (float)TreeAlign.this.labelDist.f(null, null);
            int i = 0;
            while (i < this.treeData1.size) {
                m_i = this.treeData1.degrees[i];
                this.DEF1[i] = 0.0f;
                k = 0;
                while (k < m_i) {
                    int n = i;
                    this.DEF1[n] = this.DEF1[n] + this.DET1[this.treeData1.children[i][k]];
                    ++k;
                }
                this.DL[i][this.treeData2.size] = (float)TreeAlign.this.labelDist.f(this.treeData1.values[i], null);
                this.DET1[i] = this.DEF1[i] + this.DL[i][this.treeData2.size];
                ++i;
            }
            int j = 0;
            while (j < this.treeData2.size) {
                int n_j = this.treeData2.degrees[j];
                this.DEF2[j] = 0.0f;
                k = 0;
                while (k < n_j) {
                    int n = j;
                    this.DEF2[n] = this.DEF2[n] + this.DET2[this.treeData2.children[j][k]];
                    ++k;
                }
                this.DL[this.treeData1.size][j] = (float)TreeAlign.this.labelDist.f(null, this.treeData2.values[j]);
                this.DET2[j] = this.DEF2[j] + this.DL[this.treeData1.size][j];
                ++j;
            }
            i = 0;
            while (i < this.treeData1.size) {
                m_i = this.treeData1.degrees[i];
                int j2 = 0;
                while (j2 < this.treeData2.size) {
                    float d;
                    int n_j = this.treeData2.degrees[j2];
                    this.DL[i][j2] = (float)TreeAlign.this.labelDist.f(this.treeData1.values[i], this.treeData2.values[j2]);
                    int s = 0;
                    while (s < m_i) {
                        this.computeAlignmentP1(i, s, m_i, j2, 0, n_j, 2);
                        ++s;
                    }
                    int t = 0;
                    while (t < n_j) {
                        this.computeAlignmentP1(i, 0, m_i, j2, t, n_j, 1);
                        ++t;
                    }
                    this.DT[i][j2] = Float.POSITIVE_INFINITY;
                    float minCandidate = Float.POSITIVE_INFINITY;
                    int best_r = -1;
                    int r = 0;
                    while (r < n_j) {
                        d = this.DT[i][this.treeData2.children[j2][r]] - this.DET2[this.treeData2.children[j2][r]];
                        if (d < minCandidate) {
                            minCandidate = d;
                            best_r = r;
                        }
                        ++r;
                    }
                    if ((minCandidate += this.DET2[j2]) < this.DT[i][j2]) {
                        this.DT[i][j2] = minCandidate;
                        this.DTDecisions1[i][j2] = 1;
                        this.DTDecisions2[i][j2] = (short)best_r;
                    }
                    minCandidate = Float.POSITIVE_INFINITY;
                    best_r = -1;
                    r = 0;
                    while (r < m_i) {
                        d = this.DT[this.treeData1.children[i][r]][j2] - this.DET1[this.treeData1.children[i][r]];
                        if (d < minCandidate) {
                            minCandidate = d;
                            best_r = r;
                        }
                        ++r;
                    }
                    if ((minCandidate += this.DET1[i]) < this.DT[i][j2]) {
                        this.DT[i][j2] = minCandidate;
                        this.DTDecisions1[i][j2] = 2;
                        this.DTDecisions2[i][j2] = (short)best_r;
                    }
                    minCandidate = n_j != 0 ? this.DF1[i][this.treeData2.children[j2][0]][m_i][n_j] : (m_i != 0 ? this.DF2[j2][this.treeData1.children[i][0]][m_i][n_j] : 0.0f);
                    if ((minCandidate += this.DL[i][j2]) < this.DT[i][j2]) {
                        this.DT[i][j2] = minCandidate;
                        this.DTDecisions1[i][j2] = 3;
                    }
                    ++j2;
                }
                ++i;
            }
            return this.DT[this.treeData1.size - 1][this.treeData2.size - 1];
        }

        public Aligner(Tree<ValueType1> T1, Tree<ValueType2> T2) {
            this.treeData1 = new TreeData();
            this.treeData1.tree = T1;
            this.treeData2 = new TreeData();
            this.treeData2.tree = T2;
        }

        private List<Tree<AlignedNode<ValueType1, ValueType2>>> computeForestAlignment(int i, int s, int p, int j, int t, int q) {
            short k;
            byte decision1;
            if (p == s - 1) {
                ArrayList result = new ArrayList();
                int k2 = t;
                while (k2 <= q) {
                    result.add(this.treeInserted(this.treeData2.children[j][k2]));
                    ++k2;
                }
                return result;
            }
            if (q == t - 1) {
                ArrayList result = new ArrayList();
                int k3 = s;
                while (k3 <= p) {
                    result.add(this.treeDeleted(this.treeData1.children[i][k3]));
                    ++k3;
                }
                return result;
            }
            if (s == 0) {
                decision1 = this.DF1Decisions1[i][this.treeData2.children[j][t]][p - s + 1][q - t + 1];
                k = this.DF1Decisions2[i][this.treeData2.children[j][t]][p - s + 1][q - t + 1];
            } else if (t == 0) {
                decision1 = this.DF2Decisions1[j][this.treeData1.children[i][s]][p - s + 1][q - t + 1];
                k = this.DF2Decisions2[j][this.treeData1.children[i][s]][p - s + 1][q - t + 1];
            } else {
                throw new Error("TreeAlignSymmetric bug: both s and t are non-zero");
            }
            switch (decision1) {
                case 1: {
                    List result = this.computeForestAlignment(i, s, p - 1, j, t, q);
                    result.add(this.treeDeleted(this.treeData1.children[i][p]));
                    return result;
                }
                case 2: {
                    List result = this.computeForestAlignment(i, s, p, j, t, q - 1);
                    result.add(this.treeInserted(this.treeData2.children[j][q]));
                    return result;
                }
                case 3: {
                    List result = this.computeForestAlignment(i, s, p - 1, j, t, q - 1);
                    result.add(this.computeTreeAlignment(this.treeData1.children[i][p], this.treeData2.children[j][q]));
                    return result;
                }
                case 4: {
                    List result = this.computeForestAlignment(i, s, k - 1, j, t, q - 1);
                    int j_q = this.treeData2.children[j][q];
                    Tree insertedNode = new Tree();
                    AlignedNode insertedNodeValue = new AlignedNode();
                    insertedNodeValue.setLeftNode(null);
                    insertedNodeValue.setRightNode(this.treeData2.nodes[j_q]);
                    insertedNode.setValue(insertedNodeValue);
                    insertedNode.replaceChildrenListBy(this.computeForestAlignment(i, k, p, j_q, 0, this.treeData2.degrees[j_q] - 1));
                    result.add(insertedNode);
                    return result;
                }
                case 5: {
                    List result = this.computeForestAlignment(i, s, p - 1, j, t, k - 1);
                    int i_p = this.treeData1.children[i][p];
                    Tree deletedNode = new Tree();
                    AlignedNode deletedNodeValue = new AlignedNode();
                    deletedNodeValue.setLeftNode(this.treeData1.nodes[i_p]);
                    deletedNodeValue.setRightNode(null);
                    deletedNode.setValue(deletedNodeValue);
                    deletedNode.replaceChildrenListBy(this.computeForestAlignment(i_p, 0, this.treeData1.degrees[i_p] - 1, j, k, q));
                    result.add(deletedNode);
                    return result;
                }
            }
            throw new Error("TreeAlign: decision1 = " + decision1);
        }

        private Tree<AlignedNode<ValueType1, ValueType2>> treeDeleted(int i) {
            Tree root = new Tree();
            AlignedNode alignedNode = new AlignedNode();
            alignedNode.setLeftNode(this.treeData1.nodes[i]);
            alignedNode.setRightNode(null);
            root.setValue(alignedNode);
            int r = 0;
            while (r < this.treeData1.degrees[i]) {
                root.getChildren().add(this.treeDeleted(this.treeData1.children[i][r]));
                ++r;
            }
            return root;
        }

        private Tree<AlignedNode<ValueType1, ValueType2>> treeInserted(int j) {
            Tree root = new Tree();
            AlignedNode alignedNode = new AlignedNode();
            alignedNode.setLeftNode(null);
            alignedNode.setRightNode(this.treeData2.nodes[j]);
            root.setValue(alignedNode);
            int r = 0;
            while (r < this.treeData2.degrees[j]) {
                root.getChildren().add(this.treeInserted(this.treeData2.children[j][r]));
                ++r;
            }
            return root;
        }

        private Tree<AlignedNode<ValueType1, ValueType2>> computeTreeAlignment(int i, int j) {
            switch (this.DTDecisions1[i][j]) {
                case 1: {
                    Tree root = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(null);
                    alignedNode.setRightNode(this.treeData2.nodes[j]);
                    root.setValue(alignedNode);
                    int r = 0;
                    while (r < this.treeData2.degrees[j]) {
                        if (r == this.DTDecisions2[i][j]) {
                            root.getChildren().add(this.computeTreeAlignment(i, this.treeData2.children[j][r]));
                        } else {
                            root.getChildren().add(this.treeInserted(this.treeData2.children[j][r]));
                        }
                        ++r;
                    }
                    return root;
                }
                case 2: {
                    Tree root = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(this.treeData1.nodes[i]);
                    alignedNode.setRightNode(null);
                    root.setValue(alignedNode);
                    int r = 0;
                    while (r < this.treeData1.degrees[i]) {
                        if (r == this.DTDecisions2[i][j]) {
                            root.getChildren().add(this.computeTreeAlignment(this.treeData1.children[i][r], j));
                        } else {
                            root.getChildren().add(this.treeDeleted(this.treeData1.children[i][r]));
                        }
                        ++r;
                    }
                    return root;
                }
                case 3: {
                    Tree root = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(this.treeData1.nodes[i]);
                    alignedNode.setRightNode(this.treeData2.nodes[j]);
                    root.setValue(alignedNode);
                    List children = this.computeForestAlignment(i, 0, this.treeData1.degrees[i] - 1, j, 0, this.treeData2.degrees[j] - 1);
                    root.replaceChildrenListBy(children);
                    return root;
                }
            }
            throw new Error("TreeAlign: DTDecisions1[i][j] = " + this.DTDecisions1[i][j]);
        }

        public Tree<AlignedNode<ValueType1, ValueType2>> computeAlignment() {
            return this.computeTreeAlignment(this.treeData1.size - 1, this.treeData2.size - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertTreeToArray<ValueType> {
        private int nextNodeIndex = 0;
        private TreeData<ValueType> treeData;

        public ConvertTreeToArray(TreeData<ValueType> treeData) {
            this.treeData = treeData;
        }

        private void convertTreeToArrayAux(Tree<ValueType> subtree, int[] siblingIndexes, int siblingNumber) throws TreeAlignException {
            List<Tree<ValueType>> children = subtree.getChildren();
            int numberOfChildren = children.size();
            int[] childrenIndexes = new int[numberOfChildren];
            int myIndex = -1;
            int i = 0;
            for (Tree<ValueType> child : children) {
                this.convertTreeToArrayAux(child, childrenIndexes, i);
                ++i;
            }
            if (numberOfChildren > this.treeData.degree) {
                this.treeData.degree = numberOfChildren;
            }
            myIndex = this.nextNodeIndex++;
            this.treeData.nodes[myIndex] = subtree;
            this.treeData.degrees[myIndex] = numberOfChildren;
            ValueType v = subtree.getValue();
            this.treeData.values[myIndex] = v;
            siblingIndexes[siblingNumber] = myIndex;
            this.treeData.children[myIndex] = childrenIndexes;
        }

        public void convert() throws TreeAlignException {
            this.treeData.degree = 0;
            this.treeData.size = this.treeData.tree.countNodes();
            this.treeData.nodes = new Tree[this.treeData.size];
            this.treeData.children = new int[this.treeData.size][];
            this.treeData.degrees = new int[this.treeData.size];
            this.treeData.values = new Object[this.treeData.size];
            int[] rootIndex = new int[1];
            this.convertTreeToArrayAux(this.treeData.tree, rootIndex, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeData<ValueType> {
        public Tree<ValueType> tree;
        public int size = -1;
        public int degree = -1;
        public int[] degrees;
        public Tree<ValueType>[] nodes;
        public int[][] children;
        public ValueType[] values;

        private TreeData() {
        }
    }
}

