/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.exceptions.MappingException;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNATree {
    public static Tree<RNANodeValue> RNATreeFromRNA(RNA rna) {
        ConvertToTree converter = new ConvertToTree(rna);
        return converter.toTreeAux(0);
    }

    public static Mapping mappingFromAlignment(Tree<AlignedNode<RNANodeValue, RNANodeValue>> alignment) throws MappingException {
        ConvertToMapping converter = new ConvertToMapping();
        return converter.convert(alignment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvertToMapping {
        private Mapping m;

        private ConvertToMapping() {
        }

        public Mapping convert(Tree<AlignedNode<RNANodeValue, RNANodeValue>> tree) throws MappingException {
            this.m = new Mapping();
            this.convertSubTree(tree);
            return this.m;
        }

        private void convertSubTree(Tree<AlignedNode<RNANodeValue, RNANodeValue>> tree) throws MappingException {
            AlignedNode<RNANodeValue, RNANodeValue> alignedNode = tree.getValue();
            Tree<RNANodeValue> leftNode = alignedNode.getLeftNode();
            Tree<RNANodeValue> rightNode = alignedNode.getRightNode();
            if (leftNode != null && rightNode != null) {
                RNANodeValue v1 = leftNode.getValue();
                RNANodeValue v2 = rightNode.getValue();
                int l1 = v1.getLeftBasePosition();
                int r1 = v1.getRightBasePosition();
                int l2 = v2.getLeftBasePosition();
                int r2 = v2.getRightBasePosition();
                if (l1 >= 0 && l2 >= 0) {
                    this.m.addCouple(l1, l2);
                }
                if (r1 >= 0 && r2 >= 0) {
                    this.m.addCouple(r1, r2);
                }
            }
            for (Tree<AlignedNode<RNANodeValue, RNANodeValue>> child : tree.getChildren()) {
                this.convertSubTree(child);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvertToTree {
        private RNA rna;
        private int i = 0;

        public Tree<RNANodeValue> toTreeAux(int depth) {
            Tree<RNANodeValue> tree = new Tree<RNANodeValue>();
            List children = tree.getChildren();
            tree.setValue(null);
            int length = this.rna.getSize();
            while (this.i < length) {
                ModeleBase base = this.rna.getBaseAt(this.i);
                int indexOfAssociatedBase = base.getElementStructure();
                if (indexOfAssociatedBase >= 0) {
                    if (indexOfAssociatedBase > this.i) {
                        RNANodeValue childValue = new RNANodeValue();
                        childValue.setLeftBasePosition(this.i);
                        childValue.setRightBasePosition(indexOfAssociatedBase);
                        childValue.setOrigin(RNANodeValue.Origin.BASE_PAIR_FROM_HELIX);
                        if (base instanceof ModeleBaseNucleotide) {
                            childValue.setLeftNucleotide(((ModeleBaseNucleotide)base).getBase());
                            childValue.setRightNucleotide(((ModeleBaseNucleotide)this.rna.getBaseAt(indexOfAssociatedBase)).getBase());
                        }
                        ++this.i;
                        Tree<RNANodeValue> child = this.toTreeAux(depth + 1);
                        child.setValue(childValue);
                        children.add(child);
                        continue;
                    }
                    ++this.i;
                    break;
                }
                Tree<RNANodeValue> child = new Tree<RNANodeValue>();
                RNANodeValue childValue = new RNANodeValue();
                childValue.setLeftBasePosition(this.i);
                if (base instanceof ModeleBaseNucleotide) {
                    childValue.setLeftNucleotide(((ModeleBaseNucleotide)base).getBase());
                }
                childValue.setOrigin(RNANodeValue.Origin.BASE_FROM_UNPAIRED_REGION);
                ArrayList<ModeleBP> auxBasePairs = this.rna.getAuxBPs(this.i);
                for (ModeleBP auxBasePair : auxBasePairs) {
                    if (!auxBasePair.isCanonical()) continue;
                    int partner5 = ((ModeleBaseNucleotide)auxBasePair.getPartner5()).getIndex();
                    int partner3 = ((ModeleBaseNucleotide)auxBasePair.getPartner3()).getIndex();
                    if (this.i == partner5) {
                        childValue.setOrigin(RNANodeValue.Origin.BASE_FROM_HELIX_STRAND5);
                        continue;
                    }
                    if (this.i == partner3) {
                        childValue.setOrigin(RNANodeValue.Origin.BASE_FROM_HELIX_STRAND3);
                        continue;
                    }
                    System.err.println("Warning: Base index is " + this.i + " but neither endpoint matches it (edge endpoints are " + partner5 + " and " + partner3 + ").");
                }
                child.setValue(childValue);
                children.add(child);
                ++this.i;
            }
            return tree;
        }

        public ConvertToTree(RNA rna) {
            this.rna = rna;
        }
    }
}

