/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.TreeAlignLabelDistanceSymmetric;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleDistance3
implements TreeAlignLabelDistanceSymmetric<RNANodeValue2> {
    @Override
    public double f(RNANodeValue2 v1, RNANodeValue2 v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0.0;
            }
            if (!v2.isSingleNode()) {
                return v2.getNodes().size();
            }
            return 2.0;
        }
        if (!v1.isSingleNode()) {
            if (v2 == null) {
                return v1.getNodes().size();
            }
            if (!v2.isSingleNode()) {
                return this.alignSequenceNodes(v1, v2).getDistance();
            }
            return 2 + v1.getNodes().size();
        }
        if (v2 == null) {
            return 2.0;
        }
        if (!v2.isSingleNode()) {
            return 2 + v2.getNodes().size();
        }
        String l1 = v1.getNode().getLeftNucleotide();
        String r1 = v1.getNode().getRightNucleotide();
        String l2 = v2.getNode().getLeftNucleotide();
        String r2 = v2.getNode().getRightNucleotide();
        return (!l1.equals(l2) ? 0.5 : 0.0) + (!r1.equals(r2) ? 0.5 : 0.0);
    }

    public SequenceAlignResult alignSequenceNodes(RNANodeValue2 v1, RNANodeValue2 v2) {
        char[] A = v1.computeSequence();
        char[] B = v2.computeSequence();
        return this.alignSequences(A, B);
    }

    public SequenceAlignResult alignSequences(char[] A, char[] B) {
        SequenceAlignResult result = new SequenceAlignResult();
        int la = A.length;
        int lb = B.length;
        double[][] F = new double[la + 1][lb + 1];
        int[][] decisions = new int[la + 1][lb + 1];
        double d = 1.0;
        double substCost = 1.0;
        int i = 0;
        while (i <= la) {
            F[i][0] = 1.0 * (double)i;
            ++i;
        }
        int j = 0;
        while (j <= lb) {
            F[0][j] = 1.0 * (double)j;
            ++j;
        }
        i = 1;
        while (i <= la) {
            int j2 = 1;
            while (j2 <= lb) {
                double min;
                int decision;
                double delete;
                double match = F[i - 1][j2 - 1] + (A[i - 1] == B[j2 - 1] ? 0.0 : 1.0);
                if (match < (delete = F[i - 1][j2] + 1.0)) {
                    decision = 1;
                    min = match;
                } else {
                    decision = 2;
                    min = delete;
                }
                double insert = F[i][j2 - 1] + 1.0;
                if (insert < min) {
                    decision = 3;
                    min = insert;
                }
                F[i][j2] = min;
                decisions[i][j2] = decision;
                ++j2;
            }
            ++i;
        }
        result.setDistance(F[la][lb]);
        int[][] alignment = this.computeAlignment(F, decisions, A, B);
        result.setAlignment(alignment);
        return result;
    }

    private int[][] computeAlignment(double[][] F, int[][] decisions, char[] A, char[] B) {
        ArrayList<Integer> AlignmentA = new ArrayList<Integer>(A.length + B.length);
        ArrayList<Integer> AlignmentB = new ArrayList<Integer>(A.length + B.length);
        int i = A.length;
        int j = B.length;
        while (i > 0 && j > 0) {
            int decision = decisions[i][j];
            switch (decision) {
                case 1: {
                    AlignmentA.add(i - 1);
                    AlignmentB.add(j - 1);
                    --i;
                    --j;
                    break;
                }
                case 2: {
                    AlignmentA.add(i - 1);
                    AlignmentB.add(-1);
                    --i;
                    break;
                }
                case 3: {
                    AlignmentA.add(-1);
                    AlignmentB.add(j - 1);
                    --j;
                    break;
                }
                default: {
                    throw new Error("Bug in ExampleDistance3: decision = " + decision);
                }
            }
        }
        while (i > 0) {
            AlignmentA.add(i - 1);
            AlignmentB.add(-1);
            --i;
        }
        while (j > 0) {
            AlignmentA.add(-1);
            AlignmentB.add(j - 1);
            --j;
        }
        int l = AlignmentA.size();
        int[][] result = new int[2][l];
        i = 0;
        while (i < l) {
            result[0][i] = (Integer)AlignmentA.get(l - 1 - i);
            result[1][i] = (Integer)AlignmentB.get(l - 1 - i);
            ++i;
        }
        return result;
    }

    public class SequenceAlignResult {
        private double distance;
        private int[][] alignment;

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }

        public int[][] getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int[][] alignment) {
            this.alignment = alignment;
        }
    }
}

