/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateMappingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNATemplateMapping {
    private Map<Integer, RNATemplate.RNATemplateElement> map = new HashMap<Integer, RNATemplate.RNATemplateElement>();
    private Map<RNATemplate.RNATemplateElement, ArrayList<Integer>> invmap = new HashMap<RNATemplate.RNATemplateElement, ArrayList<Integer>>();
    private double distance;

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void addCouple(int baseIndex, RNATemplate.RNATemplateElement templateElement) throws RNATemplateMappingException {
        if (this.map.containsKey(baseIndex)) {
            throw new RNATemplateMappingException("Base index already in mapping: " + baseIndex);
        }
        if (baseIndex < 0) {
            throw new RNATemplateMappingException("Invalid base index: " + baseIndex);
        }
        this.map.put(baseIndex, templateElement);
        if (!this.invmap.containsKey(templateElement)) {
            this.invmap.put(templateElement, new ArrayList());
        }
        this.invmap.get(templateElement).add(baseIndex);
    }

    public String showCompact(RNA r) {
        HashMap<String, Couple<Integer, Integer>> ranges = new HashMap<String, Couple<Integer, Integer>>();
        for (int i : this.map.keySet()) {
            RNATemplate.RNATemplateElement t = this.map.get(i);
            String k = t.getName();
            if (t instanceof RNATemplate.RNATemplateHelix) {
                k = String.valueOf(k) + " (" + ((RNATemplate.RNATemplateHelix)t).getCaption() + ")";
                ModeleBase mb = r.getBaseAt(i);
                k = mb.getElementStructure() > i ? String.valueOf(k) + ":5'" : String.valueOf(k) + ":3'";
            }
            if (!ranges.containsKey(k)) {
                ranges.put(k, new Couple<Integer, Integer>(Integer.MAX_VALUE, Integer.MIN_VALUE));
            }
            Couple c = (Couple)ranges.get(k);
            c.first = Math.min((Integer)c.first, i);
            c.second = Math.max((Integer)c.second, i);
        }
        String result = "";
        for (String k : ranges.keySet()) {
            String type;
            Couple c = (Couple)ranges.get(k);
            RNATemplate.RNATemplateElement t = this.map.get(c.first);
            String string = type = t instanceof RNATemplate.RNATemplateHelix ? "strand" : "loop";
            if (t instanceof RNATemplate.RNATemplateHelix) {
                if (!k.endsWith("5'")) continue;
                Couple c3 = (Couple)ranges.get(k.replace("5'", "3'"));
                result = String.valueOf(result) + "dummyID\t1\t" + k.replace(":5'", "") + "\t" + type + "\t" + c.first + "-" + c.second + ":" + c3.first + "-" + c3.second + "\n";
                continue;
            }
            if (!(t instanceof RNATemplate.RNATemplateUnpairedSequence)) continue;
            result = String.valueOf(result) + "dummyID\t1\t" + k + "\t" + type + "\t" + c.first + "-" + c.second + "\n";
        }
        result = String.valueOf(result) + "alignment distance = " + this.distance;
        return result;
    }

    public RNATemplate.RNATemplateElement getPartner(int baseIndex) {
        if (this.map.containsKey(baseIndex)) {
            return this.map.get(baseIndex);
        }
        return null;
    }

    public ArrayList<Integer> getAncestor(RNATemplate.RNATemplateElement templateElement) {
        if (this.invmap.containsKey(templateElement)) {
            return this.invmap.get(templateElement);
        }
        return null;
    }

    public Set<Integer> getSourceElemsAsSet() {
        return this.map.keySet();
    }

    public Set<RNATemplate.RNATemplateElement> getTargetElemsAsSet() {
        return this.invmap.keySet();
    }
}

