/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBrokenBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateSequence;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.TreeAlignLabelDistanceAsymmetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNANodeValue2TemplateDistance
implements TreeAlignLabelDistanceAsymmetric<RNANodeValue2, RNANodeValueTemplate> {
    public double delete(RNANodeValue2 v) {
        if (v == null) {
            return 0.0;
        }
        if (v.isSingleNode()) {
            if (v.getNode().getRightBasePosition() < 0) {
                return 1.0;
            }
            return 2.0;
        }
        return v.getNodes().size();
    }

    public double insert(RNANodeValueTemplate v) {
        if (v == null) {
            return 0.0;
        }
        if (v instanceof RNANodeValueTemplateSequence) {
            return ((RNANodeValueTemplateSequence)v).getSequence().getLength();
        }
        if (v instanceof RNANodeValueTemplateBrokenBasePair) {
            return 1.0;
        }
        return 2.0;
    }

    @Override
    public double f(RNANodeValue2 v1, RNANodeValueTemplate v2) {
        if (v1 == null) {
            return this.insert(v2);
        }
        if (v2 == null) {
            return this.delete(v1);
        }
        if (!v1.isSingleNode()) {
            if (v2 instanceof RNANodeValueTemplateSequence) {
                return Math.abs(v1.getNodes().size() - ((RNANodeValueTemplateSequence)v2).getSequence().getLength());
            }
            return Double.POSITIVE_INFINITY;
        }
        if (v1.getNode().getRightBasePosition() >= 0) {
            if (v2 instanceof RNANodeValueTemplateBasePair) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (v2 instanceof RNANodeValueTemplateBrokenBasePair) {
            boolean strand3onRNASide;
            RNANodeValueTemplateBrokenBasePair brokenBasePair = (RNANodeValueTemplateBrokenBasePair)v2;
            boolean strand5onTemplateSide = brokenBasePair.getPositionInHelix() < brokenBasePair.getHelix().getLength();
            boolean strand3onTemplateSide = !strand5onTemplateSide;
            boolean strand5onRNASide = v1.getNode().getOrigin() == RNANodeValue.Origin.BASE_FROM_HELIX_STRAND5;
            boolean bl = strand3onRNASide = v1.getNode().getOrigin() == RNANodeValue.Origin.BASE_FROM_HELIX_STRAND3;
            if (strand5onTemplateSide && strand5onRNASide || strand3onTemplateSide && strand3onRNASide) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }
}

