/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VARNASecDraw {
    public static VARNAPanel _vp = null;
    public int _depth = 0;
    public static Random _rnd = new Random();
    private static int MAX_NUM_DIR = 8;

    private void buildTree(int i, int j, RNATree parent, RNA r) {
        if (i >= j) {
            parent.addPortion(new UnpairedPortion(i, j - i + 1));
        }
        if (r.get_listeBases().get(i).getElementStructure() == j) {
            int i1 = i;
            int j1 = j;
            boolean over = false;
            while (i + 1 < r.get_listeBases().size() && j - 1 >= 0 && i + 1 <= j - 1 && !over) {
                if (r.get_listeBases().get(i).getElementStructure() != j) {
                    over = true;
                    continue;
                }
                ++i;
                --j;
            }
            int i2 = i;
            int j2 = j;
            RNATree t = new RNATree();
            if (i < j - 1) {
                this.buildTree(i2, j2, t, r);
            }
            PairedPortion p = new PairedPortion(i1, j1, i2 - i1, t);
            parent.addPortion(p);
        } else {
            int k;
            int start = k = i;
            int len = 0;
            while (k <= j) {
                int l = r.get_listeBases().get(k).getElementStructure();
                if (l != -1) {
                    if (len > 0) {
                        parent.addPortion(new UnpairedPortion(start, len));
                    }
                    this.buildTree(k, l, parent, r);
                    start = k = l + 1;
                    len = 0;
                    continue;
                }
                ++len;
                ++k;
            }
            if (len > 0) {
                parent.addPortion(new UnpairedPortion(start, len));
            }
        }
    }

    public int[] nextPlacement(int[] p) throws Exception {
        int i = p.length - 1;
        int prev = MAX_NUM_DIR;
        boolean stop = false;
        while (i >= 0 && !stop) {
            if (p[i] == prev - 1) {
                prev = p[i];
                --i;
                continue;
            }
            stop = true;
        }
        if (i < 0) {
            throw new Exception("No more placement available");
        }
        int n = i++;
        p[n] = p[n] + 1;
        while (i < p.length) {
            p[i] = p[i - 1] + 1;
            ++i;
        }
        return p;
    }

    public void drawTree(double x0, double y0, RNATree t, double dir, RNA r) throws Exception {
        double inc;
        boolean collision = true;
        double x = x0;
        double y = y0;
        int numHelices = 0;
        int nbHel = 1;
        int nbUn = 0;
        double totCirc = 65.0 + 40.0;
        int i = 0;
        while (i < t.getNumPortions()) {
            Portion p = t.getPortion(i);
            if (p instanceof PairedPortion) {
                totCirc += 65.0 + 40.0;
                ++nbHel;
            } else {
                totCirc += 40.0 * (double)p.getNumBases();
                nbUn += p.getNumBases() + 1;
            }
            ++i;
        }
        double radius = r.determineRadius(nbHel, nbUn, totCirc / (Math.PI * 2));
        int i2 = 0;
        while (i2 < t.getNumPortions()) {
            Portion p = t.getPortion(i2);
            if (p instanceof PairedPortion) {
                ++numHelices;
            }
            ++i2;
        }
        int[] placement = new int[numHelices];
        double val = inc = (double)MAX_NUM_DIR / ((double)numHelices + 1.0);
        int i3 = 0;
        while (i3 < numHelices) {
            placement[i3] = (int)Math.round(val);
            val += inc;
            ++i3;
        }
        System.out.println();
        double angleIncr = Math.PI * 2 / (double)MAX_NUM_DIR;
        while (collision) {
            x = x0 + radius * Math.cos(dir + Math.PI);
            y = y0 + radius * Math.sin(dir + Math.PI);
            ArrayList<GeneralPath> shapes = new ArrayList<GeneralPath>();
            int curH = 0;
            int i4 = 0;
            while (i4 < t.getNumPortions()) {
                Portion p = t.getPortion(i4);
                if (p instanceof PairedPortion) {
                    double ndir = dir + (double)placement[curH] * angleIncr;
                    ++curH;
                    PairedPortion pp = (PairedPortion)p;
                    int j = 0;
                    while (j < pp._len) {
                        int i1 = pp._pos1 + j;
                        int i22 = pp._pos2 - j;
                        double vx = Math.cos(ndir);
                        double vy = Math.sin(ndir);
                        double nx = x + ((double)j * 40.0 + radius) * vx;
                        double ny = y + ((double)j * 40.0 + radius) * vy;
                        r.get_listeBases().get(i1).setCoords(new Point2D.Double(nx + 65.0 * vy / 2.0, ny - 65.0 * vx / 2.0));
                        r.get_listeBases().get(i22).setCoords(new Point2D.Double(nx - 65.0 * vy / 2.0, ny + 65.0 * vx / 2.0));
                        ++j;
                    }
                    double nx = x + ((double)(pp._len - 1) * 40.0 + radius) * Math.cos(ndir);
                    double ny = y + ((double)(pp._len - 1) * 40.0 + radius) * Math.sin(ndir);
                    this.drawTree(nx, ny, pp._r, ndir + Math.PI, r);
                    shapes.add(pp.getOutline(r));
                } else if (p instanceof UnpairedPortion) {
                    UnpairedPortion up = (UnpairedPortion)p;
                    int j = 0;
                    while (j < up._len) {
                        r.get_listeBases().get(up._pos + j).setCoords(new Point2D.Double(x, y));
                        ++j;
                    }
                }
                ++i4;
            }
            if (shapes.size() > 0) {
                collision = false;
                i4 = 0;
                while (i4 < shapes.size() && !collision) {
                    Area a1 = new Area((Shape)shapes.get(i4));
                    int j = i4 + 1;
                    while (j < shapes.size() && !collision) {
                        Area a2 = new Area((Shape)shapes.get(j));
                        a1.intersect(a2);
                        if (!a1.isEmpty()) {
                            collision = true;
                        }
                        ++j;
                    }
                    ++i4;
                }
                if (!collision) continue;
                placement = this.nextPlacement(placement);
                continue;
            }
            collision = false;
        }
    }

    public double determineRadius(int numHelices, int numUnpaired, RNA r) {
        double circ = (double)numHelices * 65.0 + (double)(numHelices + numUnpaired) * 40.0;
        return circ / (Math.PI * 2);
    }

    public void predrawTree(double x0, double y0, RNATree t, double dir, RNA r, HelixEmbedding parent, ArrayList<HelixEmbedding> all) throws Exception {
        double inc;
        double x = x0;
        double y = y0;
        int numHelices = 0;
        int numUBases = 0;
        double totCirc = 65.0 + 40.0;
        int i = 0;
        while (i < t.getNumPortions()) {
            Portion p = t.getPortion(i);
            if (p instanceof PairedPortion) {
                totCirc += 65.0 + 40.0;
                ++numHelices;
            } else {
                totCirc += 40.0 * (double)p.getNumBases();
                numUBases += p.getNumBases();
            }
            ++i;
        }
        double radius = this.determineRadius(numHelices + 1, numUBases, r);
        int[] placement = new int[numHelices];
        double val = inc = (double)MAX_NUM_DIR / ((double)numHelices + 1.0);
        int i2 = 0;
        while (i2 < numHelices) {
            placement[i2] = (int)Math.round(val);
            val += inc;
            ++i2;
        }
        double angleIncr = Math.PI * 2 / (double)MAX_NUM_DIR;
        x = x0 + radius * Math.cos(dir + Math.PI);
        y = y0 + radius * Math.sin(dir + Math.PI);
        int curH = 0;
        int i3 = 0;
        while (i3 < t.getNumPortions()) {
            Portion p = t.getPortion(i3);
            if (p instanceof PairedPortion) {
                double ndir = dir + (double)placement[curH] * angleIncr;
                PairedPortion pp = (PairedPortion)p;
                int j = 0;
                while (j < pp._len) {
                    int i1 = pp._pos1 + j;
                    int i22 = pp._pos2 - j;
                    double vx = Math.cos(ndir);
                    double vy = Math.sin(ndir);
                    double nx = x + ((double)j * 40.0 + radius) * vx;
                    double ny = y + ((double)j * 40.0 + radius) * vy;
                    r.get_listeBases().get(i1).setCoords(new Point2D.Double(nx + 65.0 * vy / 2.0, ny - 65.0 * vx / 2.0));
                    r.get_listeBases().get(i22).setCoords(new Point2D.Double(nx - 65.0 * vy / 2.0, ny + 65.0 * vx / 2.0));
                    ++j;
                }
                double nx = x + ((double)(pp._len - 1) * 40.0 + radius) * Math.cos(ndir);
                double ny = y + ((double)(pp._len - 1) * 40.0 + radius) * Math.sin(ndir);
                HelixEmbedding nh = new HelixEmbedding(new Point2D.Double(x, y), pp, r, parent);
                parent.addHelixEmbedding(nh, placement[curH]);
                all.add(nh);
                this.predrawTree(nx, ny, pp._r, ndir + Math.PI, r, nh, all);
                ++curH;
            } else if (p instanceof UnpairedPortion) {
                UnpairedPortion up = (UnpairedPortion)p;
                int j = 0;
                while (j < up._len) {
                    r.get_listeBases().get(up._pos + j).setCoords(new Point2D.Double(x, y));
                    ++j;
                }
            }
            ++i3;
        }
    }

    public RNATree drawRNA(double dirAngle, RNA r) {
        RNATree t = new RNATree();
        this.buildTree(0, r.get_listeBases().size() - 1, t, r);
        System.out.println(t);
        ArrayList<HelixEmbedding> all = new ArrayList<HelixEmbedding>();
        HelixEmbedding root = null;
        try {
            root = new HelixEmbedding(new Point2D.Double(0.0, 0.0), new PairedPortion(0, 0, 0, t), r, null);
            this.predrawTree(0.0, 0.0, t, 0.0, r, root, all);
            int steps = 1000;
            double prevbadness = Double.MAX_VALUE;
            while (steps > 0 && prevbadness > 0.0) {
                HelixEmbedding chosen = all.get(_rnd.nextInt(all.size()));
                int delta = chosen.chooseNextMove();
                if (_vp != null) {
                    GeneralPath p = new GeneralPath();
                    int i = 0;
                    while (i < all.size()) {
                        p.append(all.get(i).getShape(), false);
                        ++i;
                    }
                    r._debugShape = p;
                    _vp.paintImmediately(0, 0, _vp.getWidth(), _vp.getHeight());
                }
                double badness = 0.0;
                int i = 0;
                while (i < all.size()) {
                    GeneralPath s1 = all.get(i).getShape();
                    int j = i + 1;
                    while (j < all.size()) {
                        GeneralPath s2 = all.get(j).getShape();
                        Area a = new Area(s1);
                        a.intersect(new Area(s2));
                        if (!a.isEmpty()) {
                            badness += 1.0;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (badness - prevbadness > 0.0) {
                    chosen.cancelMove(delta);
                } else {
                    prevbadness = badness;
                }
                System.out.println(badness);
                --steps;
            }
            root.reflectCoordinates();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HelixEmbedding {
        private GeneralPath _clip;
        Point2D.Double _support;
        ArrayList<HelixEmbedding> _children = new ArrayList();
        ArrayList<Integer> _indices = new ArrayList();
        PairedPortion _p;
        RNA _r;
        HelixEmbedding _parent;

        public HelixEmbedding(Point2D.Double support, PairedPortion p, RNA r, HelixEmbedding parent) {
            this._support = support;
            this._clip = p.getLocalOutline(r);
            this._p = p;
            this._r = r;
            this._parent = parent;
        }

        public void addHelixEmbedding(HelixEmbedding h, int index) {
            this._children.add(h);
            this._indices.add(index);
        }

        public GeneralPath getShape() {
            return this._clip;
        }

        public int chooseNextMove() {
            int i = this._parent._children.indexOf(this);
            if (this._parent._children.size() < MAX_NUM_DIR - 1) {
                int max;
                int min;
                if (this._parent._children.size() == 1) {
                    min = 1;
                    max = MAX_NUM_DIR - 1;
                } else {
                    min = i == 0 ? 1 : this._parent._indices.get(i - 1) + 1;
                    max = i == this._parent._children.size() - 1 ? MAX_NUM_DIR - 1 : this._parent._indices.get(i + 1) - 1;
                }
                int prevIndex = this._parent._indices.get(i);
                int newIndex = min + _rnd.nextInt(max + 1 - min);
                double rot = (double)(newIndex - prevIndex) * Math.PI * 2.0 / (double)MAX_NUM_DIR;
                this._parent._indices.set(i, newIndex);
                this.rotate(rot);
                return newIndex - prevIndex;
            }
            return 0;
        }

        public void cancelMove(int delta) {
            int i = this._parent._children.indexOf(this);
            int prevIndex = this._parent._indices.get(i);
            double rot = (double)(-delta) * Math.PI * 2.0 / (double)MAX_NUM_DIR;
            this._parent._indices.set(i, prevIndex - delta);
            this.rotate(rot);
        }

        public void rotate(double angle) {
            this.transform(AffineTransform.getRotateInstance(angle, this._support.x, this._support.y));
        }

        private void transform(AffineTransform a) {
            this._clip.transform(a);
            Point2D p = a.transform(this._support, null);
            this._support.setLocation(p.getX(), p.getY());
            int i = 0;
            while (i < this._children.size()) {
                this._children.get(i).transform(a);
                ++i;
            }
        }

        public void reflectCoordinates() {
            ArrayList<ModeleBase> mbl = this._r.get_listeBases();
            if (this._p._len > 0) {
                PathIterator pi = this._clip.getPathIterator(AffineTransform.getRotateInstance(0.0));
                ArrayList<Point2D.Double> p = new ArrayList<Point2D.Double>();
                while (!pi.isDone()) {
                    double[] args = new double[6];
                    int type = pi.currentSegment(args);
                    if (type == 0 || type == 1) {
                        Point2D.Double np = new Point2D.Double(args[0], args[1]);
                        p.add(np);
                        System.out.println(Arrays.toString(args));
                    }
                    pi.next();
                }
                if (p.size() < 4) {
                    return;
                }
                Point2D.Double startLeft = (Point2D.Double)p.get(0);
                Point2D.Double endLeft = (Point2D.Double)p.get(1);
                Point2D.Double endRight = (Point2D.Double)p.get(2);
                Point2D.Double startRight = (Point2D.Double)p.get(3);
                double d = startLeft.distance(endLeft);
                double vx = endLeft.x - startLeft.x;
                double vy = endLeft.y - startLeft.y;
                double interval = 0.0;
                if (this._p._len > 1) {
                    vx /= d;
                    vy /= d;
                    interval = d / ((double)this._p._len - 1.0);
                    System.out.println("DELTA: " + interval + " " + 40.0);
                }
                int n = 0;
                while (n < this._p._len) {
                    int i = this._p._pos1 + n;
                    int j = this._p._pos2 - n;
                    ModeleBase mbLeft = mbl.get(i);
                    mbLeft.setCoords(new Point2D.Double(startLeft.x + (double)n * vx * interval, startLeft.y + (double)n * vy * interval));
                    ModeleBase mbRight = mbl.get(j);
                    mbRight.setCoords(new Point2D.Double(startRight.x + (double)n * vx * interval, startRight.y + (double)n * vy * interval));
                    ++n;
                }
            }
            int i = 0;
            while (i < this._children.size()) {
                this._children.get(i).reflectCoordinates();
                ++i;
            }
            if (this._children.size() > 0) {
                Point2D.Double center = this._children.get((int)0)._support;
                int i2 = 0;
                while (i2 < this._p._r.getNumPortions()) {
                    Portion p = this._p._r.getPortion(i2);
                    if (p instanceof UnpairedPortion) {
                        UnpairedPortion up = (UnpairedPortion)p;
                        int j = 0;
                        while (j < up._len) {
                            int n = up._pos + j;
                            ModeleBase mbLeft = mbl.get(n);
                            mbLeft.setCoords(center);
                            ++j;
                        }
                    }
                    ++i2;
                }
            } else {
                this.placeTerminalLoop(mbl, this._r);
            }
        }

        private void placeTerminalLoop(ArrayList<ModeleBase> mbl, RNA r) {
            Portion p;
            if (this._children.size() == 0 && this._p._r.getNumPortions() == 1 && (p = this._p._r.getPortion(0)) instanceof UnpairedPortion) {
                UnpairedPortion up = (UnpairedPortion)p;
                double rad = VARNASecDraw.this.determineRadius(1, up.getNumBases(), this._r);
                int a = this._p._pos1 + this._p._len - 1;
                int b = this._p._pos2 - (this._p._len - 1);
                ModeleBase mbLeft = mbl.get(a);
                ModeleBase mbRight = mbl.get(b);
                Point2D.Double pl = mbLeft.getCoords();
                Point2D.Double pr = mbRight.getCoords();
                Point2D.Double pm = new Point2D.Double((pl.x + pr.x) / 2.0, (pl.y + pr.y) / 2.0);
                double vx = (pl.x - pr.x) / pl.distance(pr);
                double vy = (pl.y - pr.y) / pl.distance(pr);
                double vnx = -vy;
                double vny = vx;
                Point2D.Double pc = new Point2D.Double(pm.x + rad * vnx, pm.y + rad * vny);
                double circ = 40.0 * (1.0 + (double)up.getNumBases()) + 65.0;
                double incrLoop = Math.PI * 2 * 40.0 / circ;
                double angle = Math.PI * 2 * 65.0 / (2.0 * circ);
                int j = 0;
                while (j < up._len) {
                    int n = up._pos + j;
                    ModeleBase mb = mbl.get(n);
                    double dx = -Math.cos(angle += incrLoop) * vnx + Math.sin(angle) * vx;
                    double dy = -Math.cos(angle) * vny + Math.sin(angle) * vy;
                    Point2D.Double pf = new Point2D.Double(pc.x + rad * dx, pc.y + rad * dy);
                    mb.setCoords(pf);
                    ++j;
                }
            }
        }

        public String toString() {
            return "Emb.Hel.: " + this._p.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PairedPortion
    extends Portion {
        int _pos1;
        int _pos2;
        int _len;
        RNATree _r;

        public PairedPortion(int pos1, int pos2, int len, RNATree r) {
            this._pos1 = pos1;
            this._pos2 = pos2;
            this._len = len;
            this._r = r;
        }

        @Override
        public ArrayList<Integer> getBaseList() {
            return null;
        }

        public String toString() {
            return "H[" + this._pos1 + "," + (this._pos1 + this._len - 1) + "][" + (this._pos2 - this._len + 1) + "," + this._pos2 + "]\n" + this._r.toString();
        }

        @Override
        public int getNumBases() {
            return 2 * this._len;
        }

        public GeneralPath getLocalOutline(RNA r) {
            GeneralPath gp = new GeneralPath();
            if (this._len > 0) {
                ArrayList<ModeleBase> l = r.get_listeBases();
                Point2D.Double p1 = l.get(this._pos1).getCoords();
                Point2D.Double p2 = l.get(this._pos1 + this._len - 1).getCoords();
                Point2D.Double p3 = l.get(this._pos2 - this._len + 1).getCoords();
                Point2D.Double p4 = l.get(this._pos2).getCoords();
                gp.moveTo((float)p1.x, (float)p1.y);
                gp.lineTo((float)p2.x, (float)p2.y);
                gp.lineTo((float)p3.x, (float)p3.y);
                gp.lineTo((float)p4.x, (float)p4.y);
            }
            return gp;
        }

        @Override
        public GeneralPath getOutline(RNA r) {
            return this.getOutline(r, false);
        }

        public GeneralPath getOutline(RNA r, boolean local) {
            ArrayList<ModeleBase> l = r.get_listeBases();
            Point2D.Double p1 = l.get(this._pos1).getCoords();
            Point2D.Double p2 = l.get(this._pos1 + this._len - 1).getCoords();
            Point2D.Double p3 = l.get(this._pos2 - this._len + 1).getCoords();
            Point2D.Double p4 = l.get(this._pos2).getCoords();
            GeneralPath gp = new GeneralPath();
            gp.moveTo((float)p1.x, (float)p1.y);
            gp.lineTo((float)p2.x, (float)p2.y);
            if (!local) {
                gp.append(this._r.getOutline(r), true);
            }
            gp.lineTo((float)p3.x, (float)p3.y);
            gp.lineTo((float)p4.x, (float)p4.y);
            return gp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Portion {
        public abstract ArrayList<Integer> getBaseList();

        public abstract int getNumBases();

        public abstract GeneralPath getOutline(RNA var1);
    }

    public class RNATree {
        ArrayList<Portion> _portions = new ArrayList();
        int _numPairedPortions = 0;

        public void addPortion(Portion p) {
            this._portions.add(p);
            if (p instanceof PairedPortion) {
                ++this._numPairedPortions;
            }
        }

        public int getNumPortions() {
            return this._portions.size();
        }

        public Portion getPortion(int i) {
            return this._portions.get(i);
        }

        public String toString() {
            String result = "";
            ++VARNASecDraw.this._depth;
            int i = 0;
            while (i < this._portions.size()) {
                result = String.valueOf(result) + String.format("%1$#" + VARNASecDraw.this._depth + "s", Character.valueOf(' '));
                result = String.valueOf(result) + this._portions.get(i).toString();
                if (i < this._portions.size() - 1) {
                    result = String.valueOf(result) + "\n";
                }
                ++i;
            }
            --VARNASecDraw.this._depth;
            return result;
        }

        public GeneralPath getOutline(RNA r) {
            GeneralPath result = new GeneralPath();
            int i = 0;
            while (i < this._portions.size()) {
                result.append(this._portions.get(i).getOutline(r), true);
                ++i;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnpairedPortion
    extends Portion {
        int _pos;
        int _len;

        public UnpairedPortion(int pos, int len) {
            this._len = len;
            this._pos = pos;
        }

        @Override
        public ArrayList<Integer> getBaseList() {
            return null;
        }

        public String toString() {
            return "U[" + this._pos + "," + (this._pos + this._len - 1) + "]";
        }

        @Override
        public int getNumBases() {
            return this._len;
        }

        @Override
        public GeneralPath getOutline(RNA r) {
            GeneralPath gp = new GeneralPath();
            ArrayList<ModeleBase> l = r.get_listeBases();
            Point2D.Double p0 = l.get(this._pos).getCoords();
            gp.moveTo((float)p0.x, (float)p0.y);
            int i = 1;
            while (i < this._len) {
                Point2D.Double p = l.get(this._pos + i).getCoords();
                gp.lineTo((float)p.x, (float)p.y);
                ++i;
            }
            return gp;
        }
    }
}

