/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeleColorMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4055062096061553106L;
    private Vector<Color> _map;
    private Vector<Double> _values;
    public static final Color DEFAULT_COLOR = Color.GREEN;

    public ModeleColorMap() {
        this(new Vector<Color>(), new Vector<Double>());
    }

    public ModeleColorMap(Vector<Color> map, Vector<Double> values) {
        this._map = map;
        this._values = values;
    }

    public void addColor(double val, Color col) {
        int offset = Arrays.binarySearch(this._values.toArray(), (Object)val);
        if (offset < 0) {
            int inspoint = -offset - 1;
            this._map.insertElementAt(col, inspoint);
            this._values.insertElementAt(val, inspoint);
        }
    }

    public double getMinValue() {
        if (this._values.size() > 0) {
            return this._values.get(0);
        }
        return 0.0;
    }

    public double getMaxValue() {
        if (this._values.size() > 0) {
            return this._values.get(this._values.size() - 1);
        }
        return 0.0;
    }

    public Color getMinColor() {
        if (this._map.size() > 0) {
            return this._map.get(0);
        }
        return DEFAULT_COLOR;
    }

    public Color getMaxColor() {
        if (this._map.size() > 0) {
            return this._map.get(this._map.size() - 1);
        }
        return DEFAULT_COLOR;
    }

    public int getNumColors() {
        return this._map.size();
    }

    public Color getColorAt(int i) {
        return this._map.get(i);
    }

    public Double getValueAt(int i) {
        return this._values.get(i);
    }

    public Color getColorForValue(double val) {
        Color result;
        if (val <= this.getMinValue()) {
            result = this.getMinColor();
        } else if (val >= this.getMaxValue()) {
            result = this.getMaxColor();
        } else {
            int offset = Arrays.binarySearch(this._values.toArray(), (Object)val);
            if (offset >= 0) {
                result = this._map.get(offset);
            } else {
                int inspoint = -offset - 1;
                Color c1 = this._map.get(inspoint);
                double v1 = this._values.get(inspoint);
                if (inspoint > 0) {
                    Color c2 = this._map.get(inspoint - 1);
                    double v2 = this._values.get(inspoint - 1);
                    double blendCoeff = (v2 - val) / (v2 - v1);
                    result = new Color((int)(blendCoeff * (double)c1.getRed() + (1.0 - blendCoeff) * (double)c2.getRed()), (int)(blendCoeff * (double)c1.getGreen() + (1.0 - blendCoeff) * (double)c2.getGreen()), (int)(blendCoeff * (double)c1.getBlue() + (1.0 - blendCoeff) * (double)c2.getBlue()));
                } else {
                    result = c1;
                }
            }
        }
        return result;
    }

    public static ModeleColorMap energyColorMap() {
        ModeleColorMap cm = new ModeleColorMap();
        cm.addColor(1.0, new Color(128, 50, 50).brighter());
        cm.addColor(0.9, new Color(255, 50, 50).brighter());
        cm.addColor(0.65, new Color(255, 255, 50).brighter());
        cm.addColor(0.55, new Color(20, 255, 50).brighter());
        cm.addColor(0.2, new Color(50, 50, 255).brighter());
        cm.addColor(0.0, new Color(50, 50, 128).brighter());
        return cm;
    }

    public static ModeleColorMap bwColorMap() {
        ModeleColorMap cm = new ModeleColorMap();
        cm.addColor(0.0, Color.white);
        cm.addColor(1.0, Color.gray.darker());
        return cm;
    }

    public static ModeleColorMap greenColorMap() {
        ModeleColorMap cm = new ModeleColorMap();
        cm.addColor(0.0, Color.gray.brighter().brighter());
        cm.addColor(1.0, Color.green.darker());
        return cm;
    }

    public static ModeleColorMap blueColorMap() {
        ModeleColorMap cm = new ModeleColorMap();
        cm.addColor(0.0, Color.gray.brighter().brighter());
        cm.addColor(1.0, Color.blue);
        return cm;
    }

    public static ModeleColorMap redColorMap() {
        ModeleColorMap cm = new ModeleColorMap();
        cm.addColor(0.0, Color.gray.brighter().brighter());
        cm.addColor(1.0, Color.red);
        return cm;
    }

    public static ModeleColorMap heatColorMap() {
        ModeleColorMap cm = new ModeleColorMap();
        cm.addColor(0.0, Color.yellow);
        cm.addColor(1.0, Color.red);
        return cm;
    }

    public static ModeleColorMap rockNRollColorMap() {
        ModeleColorMap cm = new ModeleColorMap();
        cm.addColor(0.0, Color.red.brighter());
        cm.addColor(1.0, Color.black);
        cm.addColor(2.0, Color.green.brighter());
        return cm;
    }

    public static ModeleColorMap defaultColorMap() {
        return ModeleColorMap.energyColorMap();
    }

    public static ModeleColorMap parseColorMap(String s) {
        String[] data = s.split("[;,]");
        if (data.length == 1) {
            String name = data[0].toLowerCase();
            NamedColorMapTypes[] namedColorMapTypesArray = NamedColorMapTypes.values();
            int n = namedColorMapTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamedColorMapTypes p = namedColorMapTypesArray[n2];
                if (name.equals(p.getId().toLowerCase())) {
                    return p.getColorMap();
                }
                ++n2;
            }
            return ModeleColorMap.defaultColorMap();
        }
        ModeleColorMap cm = new ModeleColorMap();
        int i = 0;
        while (i < data.length) {
            String[] data2 = data[i].split(":");
            if (data2.length == 2) {
                try {
                    Double val = Double.parseDouble(data2[0]);
                    Color col = Color.decode(data2[1]);
                    cm.addColor(val, col);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (cm.getNumColors() > 1) {
            return cm;
        }
        return ModeleColorMap.defaultColorMap();
    }

    public void setMinValue(double newMin) {
        this.rescale(newMin, this.getMaxValue());
    }

    public void setMaxValue(double newMax) {
        this.rescale(this.getMinValue(), newMax);
    }

    public void rescale(double newMin, double newMax) {
        double minBck = this.getMinValue();
        double maxBck = this.getMaxValue();
        double spanBck = maxBck - minBck;
        if (newMax != newMin) {
            newMax = Math.max(newMax, newMin + 1.0);
            int i = 0;
            while (i < this._values.size()) {
                double valBck = this._values.get(i);
                this._values.set(i, newMin + (newMax - newMin) * (valBck - minBck) / spanBck);
                ++i;
            }
        }
    }

    public ModeleColorMap clone() {
        ModeleColorMap cm = new ModeleColorMap();
        cm._map = (Vector)this._map.clone();
        cm._values = (Vector)this._values.clone();
        return cm;
    }

    public boolean equals(ModeleColorMap cm) {
        if (this.getNumColors() != cm.getNumColors()) {
            return false;
        }
        int i = 0;
        while (i < this.getNumColors()) {
            if (!this.getColorAt(i).equals(cm.getColorAt(i)) || !this.getValueAt(i).equals(cm.getValueAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getParamEncoding() {
        String result = "";
        Formatter f = new Formatter();
        int i = 0;
        while (i < this.getNumColors()) {
            if (i != 0) {
                f.format(",", new Object[0]);
            }
            f.format("%.2f:#%02X%02X%02X", this._values.get(i), this._map.get(i).getRed(), this._map.get(i).getGreen(), this._map.get(i).getBlue());
            ++i;
        }
        return f.out().toString();
    }

    public String toString() {
        return this.getParamEncoding();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NamedColorMapTypes {
        RED("red", ModeleColorMap.redColorMap()),
        BLUE("blue", ModeleColorMap.blueColorMap()),
        GREEN("green", ModeleColorMap.greenColorMap()),
        HEAT("heat", ModeleColorMap.heatColorMap()),
        ENERGY("energy", ModeleColorMap.energyColorMap()),
        ROCKNROLL("rocknroll", ModeleColorMap.rockNRollColorMap()),
        BW("bw", ModeleColorMap.bwColorMap());

        String _id;
        ModeleColorMap _cm;

        private NamedColorMapTypes(String id, ModeleColorMap cm) {
            this._id = id;
            this._cm = cm;
        }

        public String getId() {
            return this._id;
        }

        public ModeleColorMap getColorMap() {
            return this._cm;
        }

        public String toString() {
            return this._id;
        }
    }
}

