/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBasesComparison
extends ModeleBase {
    private static final long serialVersionUID = -2733063250714562463L;
    private Character _base1;
    private Character _base2;
    private int _appartenance = -1;
    private int _index;
    public static String XML_ELEMENT_NAME = "NTPair";
    public static String XML_VAR_FIRST_CONTENT_NAME = "base1";
    public static String XML_VAR_SECOND_CONTENT_NAME = "base2";
    public static String XML_VAR_MEMBERSHIP_NAME = "type";
    public static Color FIRST_RNA_COLOR = Color.decode("#FFDD99");
    public static Color SECOND_RNA_COLOR = Color.decode("#99DDFF");
    public static Color BOTH_RNA_COLOR = Color.decode("#99DD99");
    public static Color DEFAULT_RNA_COLOR = Color.white;

    public void toXML(TransformerHandler hd) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", XML_VAR_INDEX_NAME, "CDATA", "" + this._index);
        atts.addAttribute("", "", XML_VAR_NUMBER_NAME, "CDATA", "" + this._realIndex);
        atts.addAttribute("", "", XML_VAR_CUSTOM_DRAWN_NAME, "CDATA", "" + this._colorie);
        atts.addAttribute("", "", XML_VAR_MEMBERSHIP_NAME, "CDATA", "" + this._appartenance);
        atts.addAttribute("", "", "VALUE", "CDATA", "" + this._value);
        hd.startElement("", "", XML_ELEMENT_NAME, atts);
        atts.clear();
        hd.startElement("", "", XML_VAR_FIRST_CONTENT_NAME, atts);
        XMLUtils.exportCDATAString(hd, "" + this._base1);
        hd.endElement("", "", XML_VAR_FIRST_CONTENT_NAME);
        atts.clear();
        hd.startElement("", "", XML_VAR_SECOND_CONTENT_NAME, atts);
        XMLUtils.exportCDATAString(hd, "" + this._base2);
        hd.endElement("", "", XML_VAR_SECOND_CONTENT_NAME);
        this._coords.toXML(hd, XML_VAR_POSITION_NAME);
        this._center.toXML(hd, XML_VAR_CENTER_NAME);
        if (this._colorie.booleanValue()) {
            this._styleBase.toXML(hd);
        }
        hd.endElement("", "", XML_ELEMENT_NAME);
    }

    public ModeleBasesComparison(int index) {
        this(' ', ' ', index);
    }

    public ModeleBasesComparison(Point2D coords, int index) {
        this(' ', ' ', new Point2D.Double(coords.getX(), coords.getY()), index);
    }

    public ModeleBasesComparison(char base1, char base2, int index) {
        this(base1, base2, -1, index);
    }

    public ModeleBasesComparison(char base1, char base2, Point2D coords, int index) {
        this(new Point2D.Double(coords.getX(), coords.getY()), base1, base2, true, new ModelBaseStyle(), -1, index);
    }

    public ModeleBasesComparison(char base1, char base2, int elementStructure, int index) {
        this(new Point2D.Double(), base1, base2, true, new ModelBaseStyle(), elementStructure, index);
    }

    public ModeleBasesComparison(Point2D coords, char base1, char base2, boolean colorie, ModelBaseStyle mb, int elementStructure, int index) {
        this._colorie = colorie;
        this._base1 = Character.valueOf(base1);
        this._base2 = Character.valueOf(base2);
        this._styleBase = mb;
        this._coords = new VARNAPoint(coords.getX(), coords.getY());
        this._index = index;
    }

    public ModelBaseStyle getStyleBase() {
        if (this._colorie.booleanValue()) {
            return this._styleBase;
        }
        return new ModelBaseStyle();
    }

    public Boolean getColored() {
        return this._colorie;
    }

    public void set_colored(Boolean colored) {
        this._colorie = colored;
    }

    public Character getBase1() {
        return this._base1;
    }

    public void setBase1(Character _base1) {
        this._base1 = _base1;
    }

    public Character getBase2() {
        return this._base2;
    }

    public void setBase2(Character _base2) {
        this._base2 = _base2;
    }

    public String getBases() {
        return String.valueOf(String.valueOf(this._base1)) + String.valueOf(this._base2);
    }

    public String getContent() {
        return this.getBases();
    }

    public int get_appartenance() {
        return this._appartenance;
    }

    public void set_appartenance(int _appartenance) {
        if (_appartenance == 0) {
            this.getStyleBase().setBaseInnerColor(BOTH_RNA_COLOR);
        } else if (_appartenance == 1) {
            this.getStyleBase().setBaseInnerColor(FIRST_RNA_COLOR);
        } else if (_appartenance == 2) {
            this.getStyleBase().setBaseInnerColor(SECOND_RNA_COLOR);
        } else {
            this.getStyleBase().setBaseInnerColor(DEFAULT_RNA_COLOR);
        }
        this._appartenance = _appartenance;
    }

    public int getIndex() {
        return this._index;
    }

    public void setContent(String s) {
        this.setBase1(Character.valueOf(s.charAt(0)));
        this.setBase2(Character.valueOf(s.charAt(1)));
    }
}

