/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBaseNucleotide
extends ModeleBase {
    private static final long serialVersionUID = -5493938366569588113L;
    private String _c;
    private int _index;
    public static String XML_ELEMENT_NAME = "nt";
    public static String XML_VAR_CONTENT_NAME = "base";
    private static HashMap<Character, Character> _subscripts = new HashMap();
    private static HashMap<Character, Character> _superscripts = new HashMap();
    private static HashMap<String, Character> _commands = new HashMap();

    public void toXML(TransformerHandler hd) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", XML_VAR_INDEX_NAME, "CDATA", "" + this._index);
        atts.addAttribute("", "", XML_VAR_NUMBER_NAME, "CDATA", "" + this._realIndex);
        atts.addAttribute("", "", XML_VAR_CUSTOM_DRAWN_NAME, "CDATA", "" + this._colorie);
        atts.addAttribute("", "", XML_VAR_VALUE_NAME, "CDATA", "" + this._value);
        hd.startElement("", "", XML_ELEMENT_NAME, atts);
        atts.clear();
        hd.startElement("", "", XML_VAR_CONTENT_NAME, atts);
        XMLUtils.exportCDATAString(hd, this._c);
        hd.endElement("", "", XML_VAR_CONTENT_NAME);
        this._coords.toXML(hd, XML_VAR_POSITION_NAME);
        this._center.toXML(hd, XML_VAR_CENTER_NAME);
        if (this._colorie.booleanValue()) {
            this._styleBase.toXML(hd);
        }
        hd.endElement("", "", XML_ELEMENT_NAME);
    }

    public ModeleBaseNucleotide(int index) {
        this(" ", index);
    }

    public ModeleBaseNucleotide(String s, int index) {
        this(s, new ModelBaseStyle(), index);
    }

    public ModeleBaseNucleotide(String s, int index, int baseNumber) {
        this(s, new ModelBaseStyle(), index);
        this._realIndex = baseNumber;
    }

    public ModeleBaseNucleotide(String s, ModelBaseStyle msb, int index) {
        this(new Point2D.Double(), new Point2D.Double(), true, s, msb, -1, index);
    }

    public ModeleBaseNucleotide(ModelBaseStyle msb, int index, int baseNumber) {
        this("", msb, index);
        this._realIndex = baseNumber;
    }

    public ModeleBaseNucleotide(Point2D.Double coord, int index) {
        this(new Point2D.Double(coord.getX(), coord.getY()), new Point2D.Double(), true, "", new ModelBaseStyle(), -1, index);
    }

    public ModeleBaseNucleotide(ModeleBaseNucleotide mb, int index) {
        this(new Point2D.Double(mb.getCoords().getX(), mb.getCoords().getY()), new Point2D.Double(mb.getCenter().getX(), mb.getCenter().getY()), true, mb.getBase(), mb.getStyleBase(), mb.getElementStructure(), index);
    }

    public ModeleBaseNucleotide(Point2D.Double coords, Point2D.Double center, boolean colorie, String label, ModelBaseStyle mb, int elementStruct, int index) {
        _subscripts.put(Character.valueOf('0'), Character.valueOf('\u2080'));
        _subscripts.put(Character.valueOf('1'), Character.valueOf('\u2081'));
        _subscripts.put(Character.valueOf('2'), Character.valueOf('\u2082'));
        _subscripts.put(Character.valueOf('3'), Character.valueOf('\u2083'));
        _subscripts.put(Character.valueOf('4'), Character.valueOf('\u2084'));
        _subscripts.put(Character.valueOf('5'), Character.valueOf('\u2085'));
        _subscripts.put(Character.valueOf('6'), Character.valueOf('\u2086'));
        _subscripts.put(Character.valueOf('7'), Character.valueOf('\u2087'));
        _subscripts.put(Character.valueOf('8'), Character.valueOf('\u2088'));
        _subscripts.put(Character.valueOf('9'), Character.valueOf('\u2089'));
        _subscripts.put(Character.valueOf('+'), Character.valueOf('\u208a'));
        _subscripts.put(Character.valueOf('-'), Character.valueOf('\u208b'));
        _subscripts.put(Character.valueOf('a'), Character.valueOf('\u2090'));
        _subscripts.put(Character.valueOf('e'), Character.valueOf('\u2091'));
        _subscripts.put(Character.valueOf('o'), Character.valueOf('\u2092'));
        _subscripts.put(Character.valueOf('i'), Character.valueOf('\u1d62'));
        _subscripts.put(Character.valueOf('r'), Character.valueOf('\u1d63'));
        _subscripts.put(Character.valueOf('u'), Character.valueOf('\u1d64'));
        _subscripts.put(Character.valueOf('v'), Character.valueOf('\u1d65'));
        _subscripts.put(Character.valueOf('x'), Character.valueOf('\u2093'));
        _superscripts.put(Character.valueOf('0'), Character.valueOf('\u2070'));
        _superscripts.put(Character.valueOf('1'), Character.valueOf('\u00b9'));
        _superscripts.put(Character.valueOf('2'), Character.valueOf('\u00b2'));
        _superscripts.put(Character.valueOf('3'), Character.valueOf('\u00b3'));
        _superscripts.put(Character.valueOf('4'), Character.valueOf('\u2074'));
        _superscripts.put(Character.valueOf('5'), Character.valueOf('\u2075'));
        _superscripts.put(Character.valueOf('6'), Character.valueOf('\u2076'));
        _superscripts.put(Character.valueOf('7'), Character.valueOf('\u2077'));
        _superscripts.put(Character.valueOf('8'), Character.valueOf('\u2078'));
        _superscripts.put(Character.valueOf('9'), Character.valueOf('\u2079'));
        _superscripts.put(Character.valueOf('+'), Character.valueOf('\u207a'));
        _superscripts.put(Character.valueOf('-'), Character.valueOf('\u207b'));
        _superscripts.put(Character.valueOf('i'), Character.valueOf('\u2071'));
        _superscripts.put(Character.valueOf('n'), Character.valueOf('\u207f'));
        _commands.put("alpha", Character.valueOf('\u03b1'));
        _commands.put("beta", Character.valueOf('\u03b2'));
        _commands.put("gamma", Character.valueOf('\u03b3'));
        _commands.put("delta", Character.valueOf('\u03b4'));
        _commands.put("epsilon", Character.valueOf('\u03b5'));
        _commands.put("zeta", Character.valueOf('\u03b6'));
        _commands.put("eta", Character.valueOf('\u03b7'));
        _commands.put("theta", Character.valueOf('\u03b8'));
        _commands.put("iota", Character.valueOf('\u03b9'));
        _commands.put("kappa", Character.valueOf('\u03ba'));
        _commands.put("lambda", Character.valueOf('\u03bb'));
        _commands.put("mu", Character.valueOf('\u03bc'));
        _commands.put("nu", Character.valueOf('\u03bd'));
        _commands.put("xi", Character.valueOf('\u03be'));
        _commands.put("omicron", Character.valueOf('\u03bf'));
        _commands.put("pi", Character.valueOf('\u03c1'));
        _commands.put("rho", Character.valueOf('\u03c2'));
        _commands.put("sigma", Character.valueOf('\u03c3'));
        _commands.put("tau", Character.valueOf('\u03c4'));
        _commands.put("upsilon", Character.valueOf('\u03c5'));
        _commands.put("phi", Character.valueOf('\u03c6'));
        _commands.put("chi", Character.valueOf('\u03c7'));
        _commands.put("psi", Character.valueOf('\u03c8'));
        _commands.put("omega", Character.valueOf('\u03c9'));
        _commands.put("Psi", Character.valueOf('\u03a8'));
        _commands.put("Phi", Character.valueOf('\u03a6'));
        _commands.put("Sigma", Character.valueOf('\u03a3'));
        _commands.put("Pi", Character.valueOf('\u03a0'));
        _commands.put("Theta", Character.valueOf('\u0398'));
        _commands.put("Omega", Character.valueOf('\u03a9'));
        _commands.put("Gamma", Character.valueOf('\u0393'));
        _commands.put("Delta", Character.valueOf('\u0394'));
        _commands.put("Lambda", Character.valueOf('\u039b'));
        this._colorie = colorie;
        this._c = label;
        this._styleBase = mb;
        this._coords = new VARNAPoint(coords);
        this._center = new VARNAPoint(center);
        this._index = index;
        this._realIndex = index + 1;
        this._value = 0.0;
    }

    public ModelBaseStyle getStyleBase() {
        if (this._colorie.booleanValue()) {
            return this._styleBase;
        }
        return new ModelBaseStyle();
    }

    public String getBase() {
        return ModeleBaseNucleotide.decode(this._c);
    }

    public void setBase(String _s) {
        this._c = _s;
    }

    public String getContent() {
        return this.getBase();
    }

    public void setContent(String s) {
        this.setBase(s);
    }

    public int getIndex() {
        return this._index;
    }

    public String toString() {
        return this._realIndex + " (" + this._index + ") (x,y):" + this._coords + " C:" + this._center;
    }

    private static String decode(String s) {
        if (s.length() <= 1) {
            return s;
        }
        STATE_SPECIAL_CHARS_STATES state = STATE_SPECIAL_CHARS_STATES.NORMAL;
        String result = "";
        String buffer = "";
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            block0 : switch (state) {
                case NORMAL: {
                    switch (c) {
                        case '_': {
                            state = STATE_SPECIAL_CHARS_STATES.SUBSCRIPT;
                            break block0;
                        }
                        case '^': {
                            state = STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT;
                            break block0;
                        }
                        case '\\': {
                            buffer = "";
                            state = STATE_SPECIAL_CHARS_STATES.COMMAND;
                            break block0;
                        }
                    }
                    result = String.valueOf(result) + c;
                    state = STATE_SPECIAL_CHARS_STATES.NORMAL;
                    break;
                }
                case SUBSCRIPT: 
                case SUPERSCRIPT: {
                    switch (c) {
                        case '_': {
                            state = STATE_SPECIAL_CHARS_STATES.SUBSCRIPT;
                            break block0;
                        }
                        case '^': {
                            state = STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT;
                            break block0;
                        }
                        case '\\': {
                            buffer = "";
                            state = STATE_SPECIAL_CHARS_STATES.COMMAND;
                            break block0;
                        }
                    }
                    result = state == STATE_SPECIAL_CHARS_STATES.SUBSCRIPT && _subscripts.containsKey(Character.valueOf(c)) ? String.valueOf(result) + _subscripts.get(Character.valueOf(c)) : (state == STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT && _superscripts.containsKey(Character.valueOf(c)) ? String.valueOf(result) + _superscripts.get(Character.valueOf(c)) : String.valueOf(result) + c);
                    state = STATE_SPECIAL_CHARS_STATES.NORMAL;
                    break;
                }
                case COMMAND: {
                    switch (c) {
                        case '_': {
                            result = _commands.containsKey(buffer) ? String.valueOf(result) + _commands.get(buffer) : String.valueOf(result) + buffer;
                            buffer = "";
                            state = STATE_SPECIAL_CHARS_STATES.SUBSCRIPT;
                            break block0;
                        }
                        case '^': {
                            result = _commands.containsKey(buffer) ? String.valueOf(result) + _commands.get(buffer) : String.valueOf(result) + buffer;
                            buffer = "";
                            state = STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT;
                            break block0;
                        }
                        case '\\': {
                            result = _commands.containsKey(buffer) ? String.valueOf(result) + _commands.get(buffer) : String.valueOf(result) + buffer;
                            buffer = "";
                            state = STATE_SPECIAL_CHARS_STATES.COMMAND;
                            break block0;
                        }
                        case ' ': {
                            state = STATE_SPECIAL_CHARS_STATES.NORMAL;
                            result = _commands.containsKey(buffer) ? String.valueOf(result) + _commands.get(buffer) : String.valueOf(result) + buffer;
                            buffer = "";
                            break block0;
                        }
                    }
                    buffer = String.valueOf(buffer) + c;
                }
            }
            ++i;
        }
        result = _commands.containsKey(buffer) ? String.valueOf(result) + _commands.get(buffer) : String.valueOf(result) + buffer;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STATE_SPECIAL_CHARS_STATES {
        NORMAL,
        SUBSCRIPT,
        SUPERSCRIPT,
        COMMAND;

    }
}

