/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.io.Serializable;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBPStyle
implements Serializable {
    private static final long serialVersionUID = 3006493290669550139L;
    private boolean _isCustomColored = false;
    private Color _color = VARNAConfig.DEFAULT_BOND_COLOR;
    private double _thickness = -1.0;
    private double _bent = 0.0;
    public static String XML_ELEMENT_NAME = "BPstyle";
    public static String XML_VAR_CUSTOM_STYLED_NAME = "custom";
    public static String XML_VAR_COLOR_NAME = "color";
    public static String XML_VAR_THICKNESS_NAME = "thickness";
    public static String XML_VAR_BENT_NAME = "bent";

    public void toXML(TransformerHandler hd) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", XML_VAR_CUSTOM_STYLED_NAME, "CDATA", "" + this._isCustomColored);
        atts.addAttribute("", "", XML_VAR_COLOR_NAME, "CDATA", XMLUtils.toHTMLNotation(this._color));
        atts.addAttribute("", "", XML_VAR_THICKNESS_NAME, "CDATA", "" + this._thickness);
        atts.addAttribute("", "", XML_VAR_BENT_NAME, "CDATA", "" + this._bent);
        hd.startElement("", "", XML_ELEMENT_NAME, atts);
        hd.endElement("", "", XML_ELEMENT_NAME);
    }

    public double getBent() {
        return this._bent;
    }

    public boolean isBent() {
        return this._bent != 0.0;
    }

    public void setBent(double b) {
        this._bent = b;
    }

    public void setCustomColor(Color c) {
        this._isCustomColored = true;
        this._color = c;
    }

    public void useDefaultColor() {
        this._isCustomColored = false;
    }

    public boolean isCustomColored() {
        return this._isCustomColored;
    }

    public Color getCustomColor() {
        return this._color;
    }

    public Color getColor(Color def) {
        if (this.isCustomColored()) {
            return this._color;
        }
        return def;
    }

    public double getThickness(double def) {
        if (this._thickness > 0.0) {
            return this._thickness;
        }
        return def;
    }

    public void setThickness(double thickness) {
        this._thickness = thickness;
    }
}

