/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.ArcCommand;
import fr.orsay.lri.varna.models.export.CircleCommand;
import fr.orsay.lri.varna.models.export.ColorCommand;
import fr.orsay.lri.varna.models.export.FillCircleCommand;
import fr.orsay.lri.varna.models.export.FillPolygonCommand;
import fr.orsay.lri.varna.models.export.FontCommand;
import fr.orsay.lri.varna.models.export.GraphicElement;
import fr.orsay.lri.varna.models.export.LineCommand;
import fr.orsay.lri.varna.models.export.PolygonCommand;
import fr.orsay.lri.varna.models.export.RectangleCommand;
import fr.orsay.lri.varna.models.export.TextCommand;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public abstract class SecStrDrawingProducer {
    public static final int FONT_TIMES_ROMAN = 0;
    public static final int FONT_TIMES_BOLD = 1;
    public static final int FONT_TIMES_ITALIC = 2;
    public static final int FONT_TIMES_BOLD_ITALIC = 3;
    public static final int FONT_HELVETICA = 16;
    public static final int FONT_HELVETICA_OBLIQUE = 17;
    public static final int FONT_HELVETICA_BOLD = 18;
    public static final int FONT_HELVETICA_BOLD_OBLIQUE = 19;
    public static final int FONT_COURIER = 12;
    public static final int FONT_COURIER_BOLD = 13;
    public static final int FONT_COURIER_OBLIQUE = 14;
    public static final int FONT_COURIER_BOLD_OBLIQUE = 15;
    private Vector<GraphicElement> _commands = new Vector();
    private double _scale = 1.0;
    private double _xmin = Double.MAX_VALUE;
    private double _ymin = Double.MAX_VALUE;
    private double _xmax = -1.7976931348623157E308;
    private double _ymax = -1.7976931348623157E308;
    protected Color _curColor = Color.black;
    protected Color _backgroundColor = null;
    protected double _fontsize = 10.0;
    protected int _font = 18;

    public Color getCurrentColor() {
        return this._curColor;
    }

    public double getCurFontSize() {
        return this._fontsize;
    }

    public int getCurrentFont() {
        return this._font;
    }

    public abstract String drawLineS(Point2D.Double var1, Point2D.Double var2, double var3);

    public abstract String drawArcS(Point2D.Double var1, double var2, double var4, double var6, double var8);

    public abstract String drawTextS(Point2D.Double var1, String var2);

    public abstract String drawRectangleS(Point2D.Double var1, Point2D.Double var2, double var3);

    public abstract String drawCircleS(Point2D.Double var1, double var2, double var4);

    public abstract String fillCircleS(Point2D.Double var1, double var2, double var4, Color var6);

    public abstract String drawPolygonS(Point2D.Double[] var1, double var2);

    public abstract String fillPolygonS(Point2D.Double[] var1, Color var2);

    public abstract String setFontS(int var1, double var2);

    public String setColorS(Color col) {
        this._curColor = col;
        return "";
    }

    public abstract String headerS(Rectangle2D.Double var1);

    public abstract String footerS();

    private void resetBoundingBox() {
        this._xmin = Double.MAX_VALUE;
        this._ymin = Double.MAX_VALUE;
        this._xmax = -1.7976931348623157E308;
        this._ymax = -1.7976931348623157E308;
    }

    private void updateBoundingBox(double x, double y) {
        this._xmin = Math.min(this._xmin, x - 10.0);
        this._ymin = Math.min(this._ymin, y - 10.0);
        this._xmax = Math.max(this._xmax, x + 10.0);
        this._ymax = Math.max(this._ymax, y + 10.0);
    }

    public void drawLine(double x0, double y0, double x1, double y1, double thickness) {
        this.updateBoundingBox(x0, y0);
        this.updateBoundingBox(x1, y1);
        this._commands.add(new LineCommand(new Point2D.Double(x0, y0), new Point2D.Double(x1, y1), thickness));
    }

    public void drawArc(Point2D.Double origine, double width, double height, double startAngle, double endAngle) {
        this.updateBoundingBox(origine.x + width, origine.y + height / 2.0);
        this._commands.add(new ArcCommand(origine, width, height, startAngle, endAngle));
    }

    public void drawText(double x, double y, String txt) {
        this.updateBoundingBox(x, y);
        this._commands.add(new TextCommand(new Point2D.Double(x, y), new String(txt)));
    }

    public void drawRectangle(double x, double y, double w, double h, double thickness) {
        this.updateBoundingBox(x, y);
        this.updateBoundingBox(x + w, y + h);
        this._commands.add(new RectangleCommand(new Point2D.Double(x, y), new Point2D.Double(w, h), thickness));
    }

    public void fillRectangle(double x, double y, double w, double h, Color color) {
        double[] xtab = new double[4];
        double[] ytab = new double[4];
        xtab[0] = x;
        xtab[1] = x + w;
        xtab[2] = x + w;
        xtab[3] = x;
        ytab[0] = y;
        ytab[1] = y;
        ytab[2] = y + h;
        ytab[3] = y + h;
        this.fillPolygon(xtab, ytab, color);
    }

    public void drawCircle(double x, double y, double radius, double thickness) {
        this.updateBoundingBox(x - radius, y - radius);
        this.updateBoundingBox(x + radius, y + radius);
        this._commands.add(new CircleCommand(new Point2D.Double(x, y), radius, thickness));
    }

    public void setColor(Color col) {
        this._curColor = col;
        this._commands.add(new ColorCommand(col));
    }

    public void setBackgroundColor(Color col) {
        this._backgroundColor = col;
    }

    public void removeBackgroundColor() {
        this._backgroundColor = null;
    }

    public void fillCircle(double x, double y, double radius, double thickness, Color color) {
        this.updateBoundingBox(x - radius, y - radius);
        this.updateBoundingBox(x + radius, y + radius);
        this._commands.add(new FillCircleCommand(new Point2D.Double(x, y), radius, thickness, color));
    }

    public void drawPolygon(double[] xtab, double[] ytab, double thickness) {
        if (xtab.length == ytab.length) {
            Point2D.Double[] points = new Point2D.Double[xtab.length];
            int i = 0;
            while (i < xtab.length) {
                points[i] = new Point2D.Double(xtab[i], ytab[i]);
                this.updateBoundingBox(xtab[i], ytab[i]);
                ++i;
            }
            this._commands.add(new PolygonCommand(points, thickness));
        }
    }

    public void drawPolygon(GeneralPath p, double thickness) {
        PathIterator pi = p.getPathIterator(null);
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int code = pi.currentSegment(coords);
            if (code == 0) {
                v.add(new Point2D.Double(coords[0], coords[1]));
            }
            if (code == 1) {
                v.add(new Point2D.Double(coords[0], coords[1]));
            }
            pi.next();
        }
        double[] xtab = new double[v.size()];
        double[] ytab = new double[v.size()];
        int i = 0;
        while (i < v.size()) {
            xtab[i] = ((Point2D.Double)v.get((int)i)).x;
            ytab[i] = ((Point2D.Double)v.get((int)i)).y;
            ++i;
        }
        this.drawPolygon(xtab, ytab, thickness);
    }

    public void fillPolygon(GeneralPath p, Color color) {
        PathIterator pi = p.getPathIterator(null);
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int code = pi.currentSegment(coords);
            if (code == 0) {
                v.add(new Point2D.Double(coords[0], coords[1]));
            }
            if (code == 1) {
                v.add(new Point2D.Double(coords[0], coords[1]));
            }
            pi.next();
        }
        double[] xtab = new double[v.size()];
        double[] ytab = new double[v.size()];
        int i = 0;
        while (i < v.size()) {
            xtab[i] = ((Point2D.Double)v.get((int)i)).x;
            ytab[i] = ((Point2D.Double)v.get((int)i)).y;
            ++i;
        }
        this.fillPolygon(xtab, ytab, color);
    }

    public void fillPolygon(double[] xtab, double[] ytab, Color color) {
        if (xtab.length == ytab.length) {
            Point2D.Double[] points = new Point2D.Double[xtab.length];
            int i = 0;
            while (i < xtab.length) {
                points[i] = new Point2D.Double(xtab[i], ytab[i]);
                this.updateBoundingBox(xtab[i], ytab[i]);
                ++i;
            }
            this._commands.add(new FillPolygonCommand(points, color));
        }
    }

    public void setFont(int font, double size) {
        this._fontsize = size;
        this._font = font;
        this._commands.add(new FontCommand(font, size));
    }

    public void setScale(double sc) {
        this._scale = sc;
    }

    public Rectangle2D.Double getBoundingBox() {
        return new Rectangle2D.Double(this._xmin, this._ymin, this._xmax - this._xmin, this._ymax - this._ymin);
    }

    private Point2D.Double transform(Point2D.Double p, double factor, double dx, double dy) {
        return this.transform(p.x, p.y, factor, dx, dy);
    }

    private Point2D.Double transform(double x, double y, double factor, double dx, double dy) {
        return new Point2D.Double((x + dx) * factor, (y + dy) * factor);
    }

    public String export() {
        Rectangle2D.Double oldbb = this.getBoundingBox();
        double dx = -oldbb.x;
        double dy = -oldbb.y;
        Rectangle2D.Double nbb = new Rectangle2D.Double(0.0, 0.0, oldbb.width * this._scale, oldbb.height * this._scale);
        StringBuffer buf = new StringBuffer();
        buf.append(this.headerS(nbb));
        if (this._backgroundColor != null) {
            double w = oldbb.width * this._scale;
            double h = oldbb.height * this._scale;
            Point2D.Double[] tab = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(w, 0.0), new Point2D.Double(w, h), new Point2D.Double(0.0, h)};
            buf.append(this.fillPolygonS(tab, this._backgroundColor));
        }
        int i = 0;
        while (i < this._commands.size()) {
            String tmp;
            Point2D.Double[] points;
            String tmp2;
            GraphicElement ge = this._commands.elementAt(i);
            if (ge instanceof LineCommand) {
                LineCommand c = (LineCommand)ge;
                tmp2 = this.drawLineS(this.transform(c.get_orig(), this._scale, dx, dy), this.transform(c.get_dest(), this._scale, dx, dy), c.get_thickness());
                buf.append(tmp2);
            } else if (ge instanceof TextCommand) {
                TextCommand c = (TextCommand)ge;
                tmp2 = this.drawTextS(this.transform(c.get_base(), this._scale, dx, dy), c.get_txt());
                buf.append(tmp2);
            } else if (ge instanceof RectangleCommand) {
                RectangleCommand c = (RectangleCommand)ge;
                tmp2 = this.drawRectangleS(this.transform(c.get_orig(), this._scale, dx, dy), this.transform(c.get_dims(), this._scale, 0.0, 0.0), c.get_thickness());
                buf.append(tmp2);
            } else if (ge instanceof CircleCommand) {
                CircleCommand c = (CircleCommand)ge;
                tmp2 = this.drawCircleS(this.transform(c.get_base(), this._scale, dx, dy), c.get_radius() * this._scale, c.get_thickness());
                buf.append(tmp2);
            } else if (ge instanceof FillCircleCommand) {
                FillCircleCommand c = (FillCircleCommand)ge;
                tmp2 = this.fillCircleS(this.transform(c.get_base(), this._scale, dx, dy), c.get_radius() * this._scale, c.get_thickness(), c.get_color());
                buf.append(tmp2);
            } else if (ge instanceof FontCommand) {
                FontCommand c = (FontCommand)ge;
                tmp2 = this.setFontS(c.get_font(), c.get_size());
                buf.append(tmp2);
            } else if (ge instanceof ColorCommand) {
                ColorCommand c = (ColorCommand)ge;
                tmp2 = this.setColorS(c.getColor());
                buf.append(tmp2);
            } else if (ge instanceof ArcCommand) {
                ArcCommand c = (ArcCommand)ge;
                tmp2 = this.drawArcS(this.transform(c.getOrigine(), this._scale, dx, dy), c.getWidth() * this._scale, c.getHeight() * this._scale, c.getStartAngle(), c.getEndAngle());
                buf.append(tmp2);
            } else if (ge instanceof PolygonCommand) {
                PolygonCommand c = (PolygonCommand)ge;
                points = c.get_points();
                int j = 0;
                while (j < points.length) {
                    points[j] = this.transform(points[j], this._scale, dx, dy);
                    ++j;
                }
                tmp = this.drawPolygonS(points, c.get_thickness());
                buf.append(tmp);
            } else if (ge instanceof FillPolygonCommand) {
                FillPolygonCommand c = (FillPolygonCommand)ge;
                points = c.get_points();
                int j = 0;
                while (j < points.length) {
                    points[j] = this.transform(points[j], this._scale, dx, dy);
                    ++j;
                }
                tmp = this.fillPolygonS(points, c.get_color());
                buf.append(tmp);
            }
            ++i;
        }
        buf.append(this.footerS());
        return buf.toString();
    }

    public void reset() {
    }
}

