/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SVGExport
extends SecStrDrawingProducer {
    private double _fontsize = 10.0;
    private Rectangle2D.Double _bb = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    double _thickness = 2.0;

    public SVGExport() {
        super.setScale(0.5);
    }

    private String getRGBString(Color col) {
        int rpc = (int)((double)col.getRed() / 255.0 * 100.0);
        int gpc = (int)((double)col.getGreen() / 255.0 * 100.0);
        int bpc = (int)((double)col.getBlue() / 255.0 * 100.0);
        return "rgb(" + rpc + "%, " + gpc + "%, " + bpc + "%)";
    }

    public String drawCircleS(Point2D.Double base, double radius, double thickness) {
        this._thickness = thickness;
        return "<circle cx=\"" + base.x + "\" cy=\"" + (this._bb.height - base.y) + "\" r=\"" + radius + "\" stroke=\"" + this.getRGBString(this._curColor) + "\" stroke-width=\"" + thickness + "\" fill=\"none\"/>\n";
    }

    public String drawLineS(Point2D.Double orig, Point2D.Double dest, double thickness) {
        this._thickness = thickness;
        return "<line x1=\"" + orig.x + "\" y1=\"" + (this._bb.height - orig.y) + "\" x2=\"" + dest.x + "\" y2=\"" + (this._bb.height - dest.y) + "\" stroke=\"" + this.getRGBString(this._curColor) + "\" stroke-width=\"" + thickness + "\" />\n";
    }

    public String drawRectangleS(Point2D.Double orig, Point2D.Double dims, double thickness) {
        this._thickness = thickness;
        return "";
    }

    public String drawTextS(Point2D.Double base, String txt) {
        return "<text x=\"" + base.x + "\" y=\"" + (this._bb.height - base.y + 0.4 * this._fontsize) + "\" text-anchor=\"middle\" font-family=\"Verdana\" font-size=\"" + this._fontsize + "\" fill=\"" + this.getRGBString(this._curColor) + "\" >" + txt + "</text>\n";
    }

    public String fillCircleS(Point2D.Double base, double radius, double thickness, Color col) {
        this._thickness = thickness;
        return "<circle cx=\"" + base.x + "\" cy=\"" + (this._bb.height - base.y) + "\" r=\"" + radius + "\" stroke=\"none\" stroke-width=\"" + thickness + "\" fill=\"" + this.getRGBString(col) + "\"/>\n";
    }

    public String footerS() {
        return "</svg>\n";
    }

    public String headerS(Rectangle2D.Double bb) {
        this._bb = bb;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n\n<svg width=\"100%\" height=\"100%\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">\n";
    }

    public String setFontS(int font, double size) {
        this._fontsize = 0.5 * size;
        return "";
    }

    public String drawArcS(Point2D.Double o, double width, double height, double startAngle, double endAngle) {
        double rx = width / 2.0;
        double ry = height / 2.0;
        double xs = o.x;
        double ys = this._bb.height - o.y;
        double xe = o.x + width;
        double ye = this._bb.height - o.y;
        String d = "<path d=\"M " + xs + "," + ys + " A " + rx + "," + ry + " 0 0,1 " + xe + "," + ye + "\" style=\"fill:none; stroke:" + this.getRGBString(this._curColor) + "; stroke-width:" + this._thickness + "\"/>\n";
        return d;
    }

    public String drawPolygonS(Point2D.Double[] points, double thickness) {
        String result = "<path d=\"";
        int i = 0;
        while (i < points.length) {
            result = i == 0 ? String.valueOf(result) + "M " + points[i].x + " " + (this._bb.height - points[i].y) + " " : String.valueOf(result) + "L " + points[i].x + " " + (this._bb.height - points[i].y) + " ";
            ++i;
        }
        result = String.valueOf(result) + "z\" style=\"fill:none; stroke:" + this.getRGBString(this._curColor) + "; stroke-width:" + thickness + ";\"/>\n";
        return result;
    }

    public String fillPolygonS(Point2D.Double[] points, Color col) {
        String result = "<path d=\"";
        int i = 0;
        while (i < points.length) {
            result = i == 0 ? String.valueOf(result) + "M " + points[i].x + " " + (this._bb.height - points[i].y) + " " : String.valueOf(result) + "L " + points[i].x + " " + (this._bb.height - points[i].y) + " ";
            ++i;
        }
        result = String.valueOf(result) + "z\" style=\"fill:" + this.getRGBString(this._curColor) + "; stroke:none;\"/>\n";
        return result;
    }
}

