/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PSExport
extends SecStrDrawingProducer {
    public PSExport() {
        super.setScale(0.4);
    }

    private String PSMacros() {
        String setFontSize = "/setbasefont \n{ /Helvetica-Bold findfont\n  exch scalefont\n  setfont \n  } def\n\n";
        String writeTextCentered = "/txtcenter \n{ dup \n  stringwidth pop\n  2 div neg \n  3 -1 roll \n  2 div neg\n  rmoveto\n  show\n  } def\n\n";
        String drawEllipse = "/ellipse {\n  /endangle exch def\n  /startangle exch def\n  /yrad exch def\n  /xrad exch def\n  /y exch def\n  /x exch def\n  /savematrix matrix currentmatrix def\n  x y translate\n  xrad yrad scale\n  0 0 1 startangle endangle arc\n  savematrix setmatrix\n  } def\n\n";
        return String.valueOf(setFontSize) + writeTextCentered + drawEllipse;
    }

    private String EPSHeader(double minX, double maxX, double minY, double maxY) {
        String bbox = this.PSBBox(minX, minY, maxX, maxY);
        String init = "%!PS-Adobe-3.0\n%%Pages: 1\n" + bbox + "%%EndComments\n" + "%%Page: 1 1\n";
        String macros = this.PSMacros();
        return String.valueOf(init) + macros;
    }

    private String EPSFooter() {
        return "showpage\n%%EndPage: 1\n%%EOF";
    }

    private String PSNewPath() {
        return "newpath\n";
    }

    private String PSMoveTo(double x, double y) {
        return x + " " + y + " moveto\n";
    }

    private String PSLineTo(double dx, double dy) {
        return dx + " " + dy + " lineto\n";
    }

    private String PSRLineTo(double dx, double dy) {
        return dx + " " + dy + " rlineto\n";
    }

    private String PSSetLineWidth(double thickness) {
        return (thickness /= 2.0) + " setlinewidth\n";
    }

    private String PSStroke() {
        return "stroke\n";
    }

    private String PSArc(double x, double y, double radiusX, double radiusY, double angleFrom, double angleTo) {
        double centerX = x + radiusX / 2.0;
        double centerY = y;
        return String.valueOf(centerX) + " " + centerY + " " + radiusX / 2.0 + " " + radiusY / 2.0 + " " + angleFrom + " " + angleTo + " ellipse\n";
    }

    private String PSArc(double x, double y, double radius, double angleFrom, double angleTo) {
        return x + " " + y + " " + radius + " " + angleFrom + " " + angleTo + "  arc\n";
    }

    private String PSBBox(double minX, double maxX, double minY, double maxY) {
        String norm = "%%BoundingBox: " + (long)Math.floor(minX) + " " + (long)Math.floor(minY) + " " + (long)Math.ceil(maxX) + " " + (long)Math.ceil(maxY) + "\n";
        String high = "%%HighResBoundingBox: " + (long)Math.floor(minX) + " " + (long)Math.floor(minY) + " " + (long)Math.ceil(maxX) + " " + (long)Math.ceil(maxY) + "\n";
        return String.valueOf(norm) + high;
    }

    private String PSText(String txt) {
        return "(" + txt + ") ";
    }

    private String PSShow() {
        return "show\n";
    }

    private String PSClosePath() {
        return "closepath\n";
    }

    private String PSFill() {
        return "fill\n";
    }

    private String PSSetColor(Color col) {
        return (double)col.getRed() / 255.0 + " " + (double)col.getGreen() / 255.0 + " " + (double)col.getBlue() / 255.0 + " setrgbcolor\n";
    }

    private String fontName(int font) {
        switch (font) {
            case 0: {
                return "/Times-Roman";
            }
            case 1: {
                return "/Times-Bold";
            }
            case 2: {
                return "/Times-Italic";
            }
            case 3: {
                return "/Times-BoldItalic";
            }
            case 16: {
                return "/Helvetica";
            }
            case 18: {
                return "/Helvetica-Bold";
            }
            case 17: {
                return "/Helvetica-Oblique";
            }
            case 19: {
                return "/Helvetica-BoldOblique";
            }
            case 12: {
                return "/Courier";
            }
            case 13: {
                return "/Courier-Bold";
            }
            case 14: {
                return "/Courier-Oblique";
            }
            case 15: {
                return "/Courier-BoldOblique";
            }
        }
        return "/Helvetica";
    }

    private String PSSetFont(int font, double size) {
        return String.valueOf(this.fontName(font)) + " findfont " + size + " scalefont setfont\n";
    }

    public String setFontS(int font, double size) {
        this._fontsize = (long)(0.4 * size);
        return this.PSSetFont(font, this._fontsize);
    }

    public String setColorS(Color col) {
        super.setColorS(col);
        String result = this.PSSetColor(col);
        return result;
    }

    public String drawLineS(Point2D.Double p0, Point2D.Double p1, double thickness) {
        String tmp = "";
        tmp = String.valueOf(tmp) + this.PSMoveTo(p0.x, p0.y);
        tmp = String.valueOf(tmp) + this.PSLineTo(p1.x, p1.y);
        tmp = String.valueOf(tmp) + this.PSSetLineWidth(thickness);
        tmp = String.valueOf(tmp) + this.PSStroke();
        return tmp;
    }

    public String drawTextS(Point2D.Double p, String txt) {
        String tmp = "";
        tmp = String.valueOf(tmp) + this.PSMoveTo(p.x, p.y);
        tmp = String.valueOf(tmp) + (this._fontsize / 2.0 + 1.0) + " \n";
        tmp = String.valueOf(tmp) + this.PSText(txt);
        tmp = String.valueOf(tmp) + " txtcenter\n";
        return tmp;
    }

    public String drawRectangleS(Point2D.Double orig, Point2D.Double dims, double thickness) {
        String tmp = this.PSNewPath();
        tmp = String.valueOf(tmp) + this.PSMoveTo(orig.x, orig.y);
        tmp = String.valueOf(tmp) + this.PSRLineTo(0.0, dims.y);
        tmp = String.valueOf(tmp) + this.PSRLineTo(dims.x, 0.0);
        tmp = String.valueOf(tmp) + this.PSRLineTo(0.0, -dims.y);
        tmp = String.valueOf(tmp) + this.PSClosePath();
        tmp = String.valueOf(tmp) + this.PSSetLineWidth(thickness);
        tmp = String.valueOf(tmp) + this.PSStroke();
        return tmp;
    }

    public String drawCircleS(Point2D.Double p, double radius, double thickness) {
        String tmp = this.PSNewPath();
        tmp = String.valueOf(tmp) + this.PSArc(p.x, p.y, radius, 0.0, 360.0);
        tmp = String.valueOf(tmp) + this.PSSetLineWidth(thickness);
        tmp = String.valueOf(tmp) + this.PSStroke();
        return tmp;
    }

    public String fillCircleS(Point2D.Double p, double radius, double thickness, Color color) {
        String tmp = this.PSNewPath();
        tmp = String.valueOf(tmp) + this.PSArc(p.x, p.y, radius, 0.0, 360.0);
        tmp = String.valueOf(tmp) + this.PSSetLineWidth(thickness);
        tmp = String.valueOf(tmp) + this.PSSetColor(color);
        tmp = String.valueOf(tmp) + this.PSFill();
        return tmp;
    }

    public String footerS() {
        return this.EPSFooter();
    }

    public String headerS(Rectangle2D.Double bb) {
        return this.EPSHeader(bb.x, bb.y, bb.x + bb.width, bb.y + bb.height);
    }

    public String drawArcS(Point2D.Double origine, double width, double height, double startAngle, double endAngle) {
        return String.valueOf(this.PSArc(origine.x, origine.y, width, height, startAngle, endAngle)) + this.PSStroke();
    }

    public String drawPolygonS(Point2D.Double[] points, double thickness) {
        String tmp = this.PSNewPath();
        tmp = String.valueOf(tmp) + this.PSSetLineWidth(thickness);
        int i = 0;
        while (i < points.length) {
            tmp = i == 0 ? String.valueOf(tmp) + this.PSMoveTo(points[i].x, points[i].y) : String.valueOf(tmp) + this.PSLineTo(points[i].x, points[i].y);
            ++i;
        }
        tmp = String.valueOf(tmp) + this.PSClosePath();
        tmp = String.valueOf(tmp) + this.PSStroke();
        return tmp;
    }

    public String fillPolygonS(Point2D.Double[] points, Color color) {
        Color bck = this._curColor;
        String tmp = this.PSNewPath();
        int i = 0;
        while (i < points.length) {
            tmp = i == 0 ? String.valueOf(tmp) + this.PSMoveTo(points[i].x, points[i].y) : String.valueOf(tmp) + this.PSLineTo(points[i].x, points[i].y);
            ++i;
        }
        tmp = String.valueOf(tmp) + this.PSClosePath();
        tmp = String.valueOf(tmp) + this.PSSetColor(color);
        tmp = String.valueOf(tmp) + this.PSFill();
        tmp = String.valueOf(tmp) + this.PSSetColor(bck);
        return tmp;
    }
}

