/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAnnotation
implements Serializable {
    private static final long serialVersionUID = 465236085501860747L;
    public static final Color DEFAULTCOLOR = Color.black;
    public static final Font DEFAULTFONT = new Font("Arial", 0, 12);
    private String _text;
    private AnchorType _typeAnchor;
    private Color _color;
    private double _angle;
    private Object _anchor;
    private Font _font;
    public static String XML_ELEMENT_NAME = "textAnnotation";
    public static String XML_VAR_TYPE_NAME = "type";
    public static String XML_VAR_COLOR_NAME = "color";
    public static String XML_VAR_ANGLE_NAME = "angle";
    public static String XML_VAR_TEXT_NAME = "text";

    public void toXML(TransformerHandler hd) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", XML_VAR_TYPE_NAME, "CDATA", "" + (Object)((Object)this._typeAnchor));
        atts.addAttribute("", "", XML_VAR_COLOR_NAME, "CDATA", XMLUtils.toHTMLNotation(this._color));
        atts.addAttribute("", "", XML_VAR_ANGLE_NAME, "CDATA", "" + this._angle);
        hd.startElement("", "", XML_ELEMENT_NAME, atts);
        atts.clear();
        hd.startElement("", "", XML_VAR_TEXT_NAME, atts);
        XMLUtils.exportCDATAString(hd, this._text);
        hd.endElement("", "", XML_VAR_TEXT_NAME);
        switch (this._typeAnchor) {
            case POSITION: {
                ((VARNAPoint)this._anchor).toXML(hd, "pos");
                break;
            }
            case BASE: {
                XMLUtils.toXML(hd, (ModeleBase)this._anchor);
                break;
            }
            case HELIX: {
                XMLUtils.toXML(hd, (ArrayList)this._anchor);
                break;
            }
            case LOOP: {
                XMLUtils.toXML(hd, (ArrayList)this._anchor);
            }
        }
        XMLUtils.toXML(hd, this._font);
        hd.endElement("", "", XML_ELEMENT_NAME);
    }

    public TextAnnotation(String texte) {
        this._text = texte;
        this._color = DEFAULTCOLOR;
        this._font = DEFAULTFONT;
        this._angle = 0.0;
    }

    public TextAnnotation(String texte, double x, double y) {
        this(texte);
        this._anchor = new VARNAPoint(x, y);
        this._typeAnchor = AnchorType.POSITION;
    }

    public TextAnnotation(String texte, ModeleBase mb) {
        this(texte);
        this._anchor = mb;
        this._typeAnchor = AnchorType.BASE;
    }

    public TextAnnotation(String texte, ArrayList<ModeleBase> listeBase, AnchorType type) throws Exception {
        this(texte);
        this._anchor = listeBase;
        if (type == AnchorType.HELIX) {
            this._typeAnchor = AnchorType.HELIX;
        } else if (type == AnchorType.LOOP) {
            this._typeAnchor = AnchorType.LOOP;
        } else {
            throw new Exception("Bad argument");
        }
    }

    public TextAnnotation(TextAnnotation textAnnotation) {
        this._anchor = textAnnotation.getAncrage();
        this._font = textAnnotation.getFont();
        this._text = textAnnotation.getTexte();
        this._typeAnchor = textAnnotation.getType();
    }

    public String getTexte() {
        return this._text;
    }

    public void setText(String _texte) {
        this._text = _texte;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font _font) {
        this._font = _font;
    }

    public Object getAncrage() {
        return this._anchor;
    }

    public void setAncrage(ModeleBase mb) {
        this._anchor = mb;
        this._typeAnchor = AnchorType.BASE;
    }

    public void setAncrage(double x, double y) {
        this._anchor = new VARNAPoint(x, y);
        this._typeAnchor = AnchorType.POSITION;
    }

    public void setAncrage(ArrayList<ModeleBase> list, AnchorType type) throws Exception {
        this._anchor = list;
        if (type == AnchorType.HELIX) {
            this._typeAnchor = AnchorType.HELIX;
        } else if (type == AnchorType.LOOP) {
            this._typeAnchor = AnchorType.LOOP;
        } else {
            throw new Exception("Bad argument");
        }
    }

    public AnchorType getType() {
        return this._typeAnchor;
    }

    public void setType(AnchorType t) {
        this._typeAnchor = t;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public String getHelixDescription() {
        ArrayList listeBase = (ArrayList)this._anchor;
        int minA = Integer.MAX_VALUE;
        int maxA = Integer.MIN_VALUE;
        int minB = Integer.MAX_VALUE;
        int maxB = Integer.MIN_VALUE;
        for (ModeleBase mb : listeBase) {
            int i = mb.getBaseNumber();
            if (mb.getElementStructure() > i) {
                minA = Math.min(minA, i);
                maxA = Math.max(maxA, i);
                continue;
            }
            minB = Math.min(minB, i);
            maxB = Math.max(maxB, i);
        }
        return "[" + minA + "," + maxA + "] [" + minB + "," + maxB + "]";
    }

    public String getLoopDescription() {
        ArrayList listeBase = (ArrayList)this._anchor;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (ModeleBase mb : listeBase) {
            int i = mb.getBaseNumber();
            min = Math.min(min, i);
            max = Math.max(max, i);
        }
        return "[" + min + "," + max + "]";
    }

    public String toString() {
        String tmp = "[" + this._text + "] ";
        switch (this._typeAnchor) {
            case POSITION: {
                DecimalFormat formatter = new DecimalFormat(".00");
                return String.valueOf(tmp) + " at (" + formatter.format(this.getCenterPosition().x) + "," + formatter.format(this.getCenterPosition().y) + ")";
            }
            case BASE: {
                return String.valueOf(tmp) + " on base " + ((ModeleBase)this._anchor).getBaseNumber();
            }
            case HELIX: {
                return String.valueOf(tmp) + " on helix " + this.getHelixDescription();
            }
            case LOOP: {
                return String.valueOf(tmp) + " on loop " + this.getLoopDescription();
            }
        }
        return tmp;
    }

    public Point2D.Double getCenterPosition() {
        switch (this._typeAnchor) {
            case POSITION: {
                return ((VARNAPoint)this._anchor).toPoint2D();
            }
            case BASE: {
                return ((ModeleBase)this._anchor).getCoords();
            }
            case HELIX: {
                return this.calculLoopHelix();
            }
            case LOOP: {
                return this.calculLoop();
            }
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private Point2D.Double calculLoop() {
        ArrayList<ModeleBase> liste = this.extractedArrayListModeleBaseFromAncrage();
        double totalX = 0.0;
        double totalY = 0.0;
        for (ModeleBase base : liste) {
            totalX += base.getCoords().x;
            totalY += base.getCoords().y;
        }
        return new Point2D.Double(totalX / (double)liste.size(), totalY / (double)liste.size());
    }

    private Point2D.Double calculLoopHelix() {
        ArrayList<ModeleBase> liste = this.extractedArrayListModeleBaseFromAncrage();
        Collections.sort(liste);
        double totalX = 0.0;
        double totalY = 0.0;
        double num = 0.0;
        int i = 0;
        while (i < liste.size()) {
            ModeleBase base = liste.get(i);
            if (i > 0 && i < liste.size() - 1 || liste.size() <= 2) {
                totalX += base.getCoords().x;
                totalY += base.getCoords().y;
                num += 1.0;
            }
            ++i;
        }
        return new Point2D.Double(totalX / num, totalY / num);
    }

    private ArrayList<ModeleBase> extractedArrayListModeleBaseFromAncrage() {
        return (ArrayList)this._anchor;
    }

    public TextAnnotation clone() {
        TextAnnotation textAnnot = null;
        try {
            switch (this._typeAnchor) {
                case BASE: {
                    textAnnot = new TextAnnotation(this._text, (ModeleBase)this._anchor);
                    break;
                }
                case POSITION: {
                    textAnnot = new TextAnnotation(this._text, ((VARNAPoint)this._anchor).x, ((VARNAPoint)this._anchor).y);
                    break;
                }
                case LOOP: {
                    textAnnot = new TextAnnotation(this._text, this.extractedArrayListModeleBaseFromAncrage(), AnchorType.LOOP);
                    break;
                }
                case HELIX: {
                    textAnnot = new TextAnnotation(this._text, this.extractedArrayListModeleBaseFromAncrage(), AnchorType.HELIX);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        textAnnot.setFont(this._font);
        textAnnot.setColor(this._color);
        return textAnnot;
    }

    public void copy(TextAnnotation textAnnotation) {
        this._anchor = textAnnotation.getAncrage();
        this._font = textAnnotation.getFont();
        this._text = textAnnotation.getTexte();
        this._typeAnchor = textAnnotation.getType();
        this._color = textAnnotation.getColor();
        this._angle = textAnnotation.getAngleInDegres();
    }

    public double getAngleInDegres() {
        return this._angle;
    }

    public double getAngleInRadians() {
        return this.getAngleInDegres() * Math.PI / 180.0;
    }

    public void setAngleInDegres(double _angle) {
        this._angle = _angle;
    }

    public void setAngleInRadians(double _angle) {
        this._angle = _angle * 180.0 / Math.PI;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnchorType {
        POSITION,
        BASE,
        HELIX,
        LOOP;

    }
}

