/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ChemProbAnnotation
implements Serializable {
    private static final long serialVersionUID = 5833315460145031242L;
    public static double DEFAULT_INTENSITY = 1.0;
    public static ChemProbAnnotationType DEFAULT_TYPE = ChemProbAnnotationType.ARROW;
    public static Color DEFAULT_COLOR = Color.blue.darker();
    private ModeleBase _mbfst;
    private ModeleBase _mbsnd;
    private Color _color;
    private double _intensity;
    private ChemProbAnnotationType _type;
    private boolean _outward;
    public static String XML_ELEMENT_NAME = "ChemProbAnnotation";
    public static String XML_VAR_INDEX5_NAME = "Index5";
    public static String XML_VAR_INDEX3_NAME = "Index3";
    public static String XML_VAR_COLOR_NAME = "Color";
    public static String XML_VAR_INTENSITY_NAME = "Intensity";
    public static String XML_VAR_TYPE_NAME = "Type";
    public static String XML_VAR_OUTWARD_NAME = "Outward";

    public void toXML(TransformerHandler hd) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", XML_VAR_INDEX5_NAME, "CDATA", "" + this._mbfst.getIndex());
        atts.addAttribute("", "", XML_VAR_INDEX3_NAME, "CDATA", "" + this._mbsnd.getIndex());
        atts.addAttribute("", "", XML_VAR_COLOR_NAME, "CDATA", XMLUtils.toHTMLNotation(this._color));
        atts.addAttribute("", "", XML_VAR_INTENSITY_NAME, "CDATA", "" + this._intensity);
        atts.addAttribute("", "", XML_VAR_TYPE_NAME, "CDATA", "" + (Object)((Object)this._type));
        atts.addAttribute("", "", XML_VAR_OUTWARD_NAME, "CDATA", "" + this._outward);
        hd.startElement("", "", XML_ELEMENT_NAME, atts);
        hd.endElement("", "", XML_ELEMENT_NAME);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, String styleDesc) {
        this(mbfst, mbsnd);
        this.applyStyle(styleDesc);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd) {
        this(mbfst, mbsnd, DEFAULT_TYPE, DEFAULT_INTENSITY);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, double intensity) {
        this(mbfst, mbsnd, DEFAULT_TYPE, intensity);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, ChemProbAnnotationType type) {
        this(mbfst, mbsnd, type, DEFAULT_INTENSITY);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, ChemProbAnnotationType type, double intensity) {
        this(mbfst, mbsnd, type, intensity, DEFAULT_COLOR, true);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, ChemProbAnnotationType type, double intensity, Color color, boolean out) {
        if (mbfst.getIndex() > mbsnd.getIndex()) {
            ModeleBase tmp = mbsnd;
            mbsnd = mbfst;
            mbfst = tmp;
        }
        this._mbfst = mbfst;
        this._mbsnd = mbsnd;
        this._type = type;
        this._intensity = intensity;
        this._color = color;
        this._outward = out;
    }

    public boolean isOut() {
        return this._outward;
    }

    public void setOut(boolean b) {
        this._outward = b;
    }

    public Color getColor() {
        return this._color;
    }

    public double getIntensity() {
        return this._intensity;
    }

    public ChemProbAnnotationType getType() {
        return this._type;
    }

    public void setColor(Color c) {
        this._color = c;
    }

    public void setIntensity(double d) {
        this._intensity = d;
    }

    public Point2D.Double getAnchorPosition() {
        Point2D.Double result = new Point2D.Double((this._mbfst.getCoords().x + this._mbsnd.getCoords().x) / 2.0, (this._mbfst.getCoords().y + this._mbsnd.getCoords().y) / 2.0);
        return result;
    }

    public Point2D.Double getDirVector() {
        Point2D.Double norm = this.getNormalVector();
        Point2D.Double result = new Point2D.Double(-norm.y, norm.x);
        Point2D.Double anchor = this.getAnchorPosition();
        Point2D.Double center = new Point2D.Double((this._mbfst.getCenter().x + this._mbsnd.getCenter().x) / 2.0, (this._mbfst.getCenter().y + this._mbsnd.getCenter().y) / 2.0);
        Point2D.Double vradius = new Point2D.Double((center.x - anchor.x) / 2.0, (center.y - anchor.y) / 2.0);
        if (this._outward ? result.x * vradius.x + result.y * vradius.y > 0.0 : result.x * vradius.x + result.y * vradius.y < 0.0) {
            return new Point2D.Double(-result.x, -result.y);
        }
        return result;
    }

    public Point2D.Double getNormalVector() {
        Point2D.Double tmp = this._mbfst == this._mbsnd ? new Point2D.Double(-(this._mbsnd.getCenter().y - this._mbsnd.getCoords().y), this._mbsnd.getCenter().x - this._mbsnd.getCoords().x) : new Point2D.Double((this._mbsnd.getCoords().x - this._mbfst.getCoords().x) / 2.0, (this._mbsnd.getCoords().y - this._mbfst.getCoords().y) / 2.0);
        double norm = tmp.distance(0.0, 0.0);
        Point2D.Double result = new Point2D.Double(tmp.x / norm, tmp.y / norm);
        return result;
    }

    public void applyStyle(String styleDesc) {
        String[] chemProbs = styleDesc.split(",");
        int i = 0;
        while (i < chemProbs.length) {
            String thisStyle = chemProbs[i];
            String[] data = thisStyle.split("=");
            if (data.length == 2) {
                String name = data[0];
                String value = data[1];
                if (name.toLowerCase().equals("color")) {
                    Color c = Color.decode(value);
                    if (c == null) {
                        c = this._color;
                    }
                    this.setColor(c);
                } else if (name.toLowerCase().equals("intensity")) {
                    this._intensity = Double.parseDouble(value);
                } else if (name.toLowerCase().equals("dir")) {
                    this._outward = value.toLowerCase().equals("out");
                } else if (name.toLowerCase().equals("glyph")) {
                    if (value.toLowerCase().equals("arrow")) {
                        this._type = ChemProbAnnotationType.ARROW;
                    } else if (value.toLowerCase().equals("triangle")) {
                        this._type = ChemProbAnnotationType.TRIANGLE;
                    } else if (value.toLowerCase().equals("pin")) {
                        this._type = ChemProbAnnotationType.PIN;
                    } else if (value.toLowerCase().equals("dot")) {
                        this._type = ChemProbAnnotationType.DOT;
                    }
                }
            }
            ++i;
        }
    }

    public void setType(ChemProbAnnotationType s) {
        this._type = s;
    }

    public ChemProbAnnotation clone() {
        ChemProbAnnotation result = new ChemProbAnnotation(this._mbfst, this._mbsnd);
        result._intensity = this._intensity;
        result._type = this._type;
        result._color = this._color;
        result._outward = this._outward;
        return result;
    }

    public String toString() {
        return "Chem. prob. " + (Object)((Object)this._type) + " Base#" + this._mbfst.getBaseNumber() + "-" + this._mbsnd.getBaseNumber();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChemProbAnnotationType {
        TRIANGLE,
        ARROW,
        PIN,
        DOT;

    }
}

