/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class VARNAEdits {
    public static final double MAX_DISTANCE = 55.0;

    public static class AddBPEdit
    extends AbstractUndoableEdit {
        private ModeleBP _msbp;
        private int _i;
        private int _j;
        private VARNAPanel _vp;

        public AddBPEdit(int i, int j, ModeleBP msbp, VARNAPanel vp) {
            this._msbp = msbp;
            this._i = i;
            this._j = j;
            this._vp = vp;
        }

        public void undo() throws CannotUndoException {
            this._vp.getRNA().removeBP(this._msbp);
            this._vp.repaint();
        }

        public void redo() throws CannotRedoException {
            this._vp.getRNA().addBPToStructure(this._i, this._j, this._msbp);
            this._vp.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Add BP (" + this._i + "," + this._j + ")";
        }

        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasesShiftEdit
    extends AbstractUndoableEdit {
        private ArrayList<Integer> _indices;
        private double _dx;
        private double _dy;
        private VARNAPanel _vp;

        public BasesShiftEdit(ArrayList<Integer> indices, double dx, double dy, VARNAPanel p) {
            this._indices = indices;
            this._dx = dx;
            this._dy = dy;
            this._vp = p;
        }

        @Override
        public void undo() throws CannotUndoException {
            for (int index : this._indices) {
                ModeleBase mb = this._vp.getRNA().getBaseAt(index);
                this._vp.getRNA().setCoord(index, new Point2D.Double(mb.getCoords().x - this._dx, mb.getCoords().y - this._dy));
                this._vp.getRNA().setCenter(index, new Point2D.Double(mb.getCenter().x - this._dx, mb.getCenter().y - this._dy));
            }
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            for (int index : this._indices) {
                ModeleBase mb = this._vp.getRNA().getBaseAt(index);
                this._vp.getRNA().setCoord(index, new Point2D.Double(mb.getCoords().x + this._dx, mb.getCoords().y + this._dy));
                this._vp.getRNA().setCenter(index, new Point2D.Double(mb.getCenter().x - this._dx, mb.getCenter().y - this._dy));
            }
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Base #" + this._indices + " shifted";
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof BasesShiftEdit) {
                Point2D.Double tot;
                BasesShiftEdit e = (BasesShiftEdit)anEdit;
                if (e._indices.equals(this._indices) && (tot = new Point2D.Double(this._dx + e._dx, this._dy + e._dy)).distance(0.0, 0.0) < 55.0) {
                    this._dx += e._dx;
                    this._dy += e._dy;
                    return true;
                }
            }
            return false;
        }
    }

    public static class HelixFlipEdit
    extends AbstractUndoableEdit {
        private Point _h;
        private VARNAPanel _vp;

        public HelixFlipEdit(Point h, VARNAPanel vp) {
            this._h = h;
            this._vp = vp;
        }

        public void undo() throws CannotUndoException {
            this._vp.getVARNAUI().UIFlipHelix(this._h);
            this._vp.repaint();
        }

        public void redo() throws CannotRedoException {
            this._vp.getVARNAUI().UIFlipHelix(this._h);
            this._vp.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Helix #" + this._h + " flipped";
        }

        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }
    }

    public static class HelixRotateEdit
    extends AbstractUndoableEdit {
        private double _delta;
        private double _base;
        private double _pLimL;
        private double _pLimR;
        private Point _h;
        private Point _ml;
        private VARNAPanel _vp;

        public HelixRotateEdit(double delta, double base, double pLimL, double pLimR, Point h, Point ml, VARNAPanel vp) {
            this._delta = delta;
            this._base = base;
            this._pLimL = pLimL;
            this._pLimR = pLimR;
            this._h = h;
            this._ml = ml;
            this._vp = vp;
        }

        public void undo() throws CannotUndoException {
            this._vp.getVARNAUI().UIRotateEverything(-this._delta, this._base, this._pLimL, this._pLimR, this._h, this._ml);
            this._vp.repaint();
        }

        public void redo() throws CannotRedoException {
            this._vp.getVARNAUI().UIRotateEverything(this._delta, this._base, this._pLimL, this._pLimR, this._h, this._ml);
            this._vp.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Helix #" + this._h + " rotated angle:" + this._delta;
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof HelixRotateEdit) {
                HelixRotateEdit e = (HelixRotateEdit)anEdit;
                if (e._h.equals(this._h)) {
                    double totAngle = e._delta + this._delta;
                    while (totAngle > Math.PI) {
                        totAngle -= Math.PI * 2;
                    }
                    if (Math.abs(totAngle) < 0.39269908169872414) {
                        this._delta = totAngle;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class RedrawEdit
    extends AbstractUndoableEdit {
        private int _prevMode;
        private int _newMode;
        private boolean _prevFlat;
        private boolean _newFlat;
        private ArrayList<Point2D.Double> _backupCoords = new ArrayList();
        private ArrayList<Point2D.Double> _backupCenters = new ArrayList();
        private VARNAPanel _vp;

        public RedrawEdit(VARNAPanel vp, boolean newFlat) {
            this(vp.getRNA().getDrawMode(), vp, newFlat);
        }

        public RedrawEdit(int newMode, VARNAPanel vp) {
            this(newMode, vp, vp.getFlatExteriorLoop());
        }

        public RedrawEdit(int newMode, VARNAPanel vp, boolean newFlat) {
            this._vp = vp;
            this._newMode = newMode;
            this._newFlat = newFlat;
            this._prevFlat = this._vp.getFlatExteriorLoop();
            for (ModeleBase mb : this._vp.getRNA().get_listeBases()) {
                this._backupCoords.add(new Point2D.Double(mb.getCoords().x, mb.getCoords().y));
                this._backupCenters.add(new Point2D.Double(mb.getCenter().x, mb.getCenter().y));
            }
            this._prevMode = this._vp.getDrawMode();
        }

        public void undo() throws CannotUndoException {
            RNA r = this._vp.getRNA();
            this._vp.setFlatExteriorLoop(this._prevFlat);
            r.setDrawMode(this._prevMode);
            int index = 0;
            while (index < this._vp.getRNA().get_listeBases().size()) {
                Point2D.Double oldCoord = this._backupCoords.get(index);
                Point2D.Double oldCenter = this._backupCenters.get(index);
                r.setCoord(index, oldCoord);
                r.setCenter(index, oldCenter);
                ++index;
            }
            this._vp.repaint();
        }

        public void redo() throws CannotRedoException {
            try {
                this._vp.setFlatExteriorLoop(this._newFlat);
                this._vp.getRNA().drawRNA(this._newMode, this._vp.getConfig());
            }
            catch (ExceptionNAViewAlgorithm e) {
                e.printStackTrace();
            }
            this._vp.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Redraw whole RNA";
        }

        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }
    }

    public static class RemoveBPEdit
    extends AbstractUndoableEdit {
        private ModeleBP _msbp;
        private int _i;
        private int _j;
        private VARNAPanel _vp;

        public RemoveBPEdit(int i, int j, ModeleBP msbp, VARNAPanel vp) {
            this._msbp = msbp;
            this._i = i;
            this._j = j;
            this._vp = vp;
        }

        public void undo() throws CannotUndoException {
            this._vp.getRNA().addBPToStructure(this._i, this._j, this._msbp);
            this._vp.repaint();
        }

        public void redo() throws CannotRedoException {
            this._vp.getRNA().removeBP(this._msbp);
            this._vp.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Remove BP (" + this._i + "," + this._j + ")";
        }

        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }
    }

    public static class RotateRNAEdit
    extends AbstractUndoableEdit {
        private double _angle;
        private VARNAPanel _vp;

        public RotateRNAEdit(double angle, VARNAPanel vp) {
            this._angle = angle;
            this._vp = vp;
        }

        public void undo() throws CannotUndoException {
            this._vp.getRNA().globalRotation(-this._angle);
            this._vp.repaint();
        }

        public void redo() throws CannotRedoException {
            this._vp.getRNA().globalRotation(this._angle);
            this._vp.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Rotate RNA angle:" + this._angle;
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof RotateRNAEdit) {
                RotateRNAEdit e = (RotateRNAEdit)anEdit;
                if (Math.abs(this._angle + e._angle) < 30.0) {
                    this._angle += e._angle;
                    return true;
                }
            }
            return false;
        }
    }

    public static class SingleBaseMoveEdit
    extends AbstractUndoableEdit {
        private int _index;
        private double _ox;
        private double _oy;
        private double _nx;
        private double _ny;
        private VARNAPanel _vp;

        public SingleBaseMoveEdit(int index, double nx, double ny, VARNAPanel p) {
            this._index = index;
            ModeleBase mb = p.getRNA().getBaseAt(index);
            this._ox = mb.getCoords().x;
            this._oy = mb.getCoords().y;
            this._nx = nx;
            this._ny = ny;
            this._vp = p;
        }

        public void undo() throws CannotUndoException {
            this._vp.getRNA().setCoord(this._index, new Point2D.Double(this._ox, this._oy));
            this._vp.repaint();
        }

        public void redo() throws CannotRedoException {
            this._vp.getRNA().setCoord(this._index, new Point2D.Double(this._nx, this._ny));
            this._vp.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Base #" + this._index + " moved";
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof SingleBaseMoveEdit) {
                SingleBaseMoveEdit e = (SingleBaseMoveEdit)anEdit;
                if (e._index == this._index) {
                    Point2D.Double po1 = new Point2D.Double(this._ox, this._oy);
                    Point2D.Double pn1 = new Point2D.Double(this._nx, this._ny);
                    Point2D.Double po2 = new Point2D.Double(e._ox, e._oy);
                    Point2D.Double pn2 = new Point2D.Double(e._nx, e._ny);
                    if (pn1.equals(po2) && po1.distance(pn2) < 55.0) {
                        this._nx = e._nx;
                        this._ny = e._ny;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

