/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionDrawingAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceParameterLoader;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VARNAConfigLoader {
    private static final int MAXSTYLE = 50;
    public static String algoOpt = "algorithm";
    public static String annotationsOpt = "annotations";
    public static String applyBasesStyleOpt = "applyBasesStyle";
    public static String auxBPsOpt = "auxBPs";
    public static String autoHelicesOpt = "autoHelices";
    public static String autoInteriorLoopsOpt = "autoInteriorLoops";
    public static String autoTerminalLoopsOpt = "autoTerminalLoops";
    public static String backboneColorOpt = "backbone";
    public static String backgroundColorOpt = "background";
    public static String baseInnerColorOpt = "baseInner";
    public static String baseNameColorOpt = "baseName";
    public static String baseNumbersColorOpt = "baseNum";
    public static String baseOutlineColorOpt = "baseOutline";
    public static String basesStyleOpt = "basesStyle";
    public static String borderOpt = "border";
    public static String bondColorOpt = "bp";
    public static String bpIncrementOpt = "bpIncrement";
    public static String bpStyleOpt = "bpStyle";
    public static String colorMapOpt = "colorMap";
    public static String colorMapCaptionOpt = "colorMapCaption";
    public static String colorMapDefOpt = "colorMapStyle";
    public static String colorMapMinOpt = "colorMapMin";
    public static String colorMapMaxOpt = "colorMapMax";
    public static String comparisonModeOpt = "comparisonMode";
    public static String chemProbOpt = "chemProb";
    public static String customBasesOpt = "customBases";
    public static String customBPsOpt = "customBPs";
    public static String drawNCOpt = "drawNC";
    public static String drawTertiaryOpt = "drawTertiary";
    public static String drawColorMapOpt = "drawColorMap";
    public static String drawBackboneOpt = "drawBackbone";
    public static String errorOpt = "error";
    public static String firstSequenceForComparisonOpt = "firstSequence";
    public static String firstStructureForComparisonOpt = "firstStructure";
    public static String flatExteriorLoopOpt = "flat";
    public static String gapsBaseColorOpt = "gapsColor";
    public static String highlightRegionOpt = "highlightRegion";
    public static String nonStandardColorOpt = "nsBasesColor";
    public static String numColumnsOpt = "rows";
    public static String numRowsOpt = "columns";
    public static String orientationOpt = "orientation";
    public static String modifiableOpt = "modifiable";
    public static String periodNumOpt = "periodNum";
    public static String rotationOpt = "rotation";
    public static String secondSequenceForComparisonOpt = "secondSequence";
    public static String secondStructureForComparisonOpt = "secondStructure";
    public static String sequenceOpt = "sequenceDBN";
    public static String structureOpt = "structureDBN";
    public static String titleOpt = "title";
    public static String titleColorOpt = "titleColor";
    public static String titleSizeOpt = "titleSize";
    public static String URLOpt = "url";
    public static String warningOpt = "warning";
    public static String zoomOpt = "zoom";
    public static String zoomAmountOpt = "zoomAmount";
    private String _algo;
    public String _annotations;
    public String _chemProbs;
    private double _rotation;
    private String _sseq;
    private String _sstruct;
    private int _numRows;
    private int _numColumns;
    private String _title;
    private int _titleSize;
    private Color _titleColor;
    private String _auxBPs;
    private String _highlightRegion;
    private boolean _autoHelices;
    private boolean _autoInteriorLoops;
    private boolean _autoTerminalLoops;
    private boolean _drawBackbone;
    private Color _backboneColor;
    private Color _bondColor;
    private VARNAConfig.BP_STYLE _bpStyle;
    private Color _baseOutlineColor;
    private Color _baseInnerColor;
    private Color _baseNumColor;
    private Color _baseNameColor;
    private Color _gapsColor;
    private Color _nonStandardColor;
    private boolean _flatExteriorLoop;
    private String _customBases;
    private String _customBPs;
    private String _colorMapStyle;
    private String _colorMapCaption;
    private String _colorMapValues;
    private double _colorMapMin = Double.MIN_VALUE;
    private double _colorMapMax = Double.MAX_VALUE;
    private boolean _drawNC;
    private boolean _drawTertiary;
    private boolean _drawColorMap;
    private int _periodResNum;
    private Dimension _border;
    private Color _backgroundColor;
    private String _orientation;
    private boolean _warning;
    private boolean _error;
    private boolean _modifiable;
    private double _zoom;
    private double _zoomAmount;
    private ArrayList<ModelBaseStyle> _basesStyleList;
    private boolean _comparisonMode;
    private String _firstSequence;
    private String _secondSequence;
    private String _firstStructure;
    private String _secondStructure;
    private VARNAPanel _mainSurface;
    private boolean _useNonStandardColor;
    private boolean _useGapsColor;
    private double _bpIncrement;
    private boolean _useInnerBaseColor;
    private boolean _useBaseNameColor;
    private boolean _useBaseNumbersColor;
    private boolean _useBaseOutlineColor;
    private String _URL;
    protected ArrayList<VARNAPanel> _VARNAPanelList = new ArrayList();
    InterfaceParameterLoader _optionProducer;
    public static final String LEONTIS_WESTHOF_BP_STYLE = "lw";
    public static final String SIMPLE_BP_STYLE = "simple";
    public static final String RNAVIZ_BP_STYLE = "rnaviz";
    public static final String NONE_BP_STYLE = "none";
    private RNA _defaultRNA = new RNA();
    public static final String ALGORITHM_CIRCULAR = "circular";
    public static final String ALGORITHM_NAVIEW = "naview";
    public static final String ALGORITHM_LINE = "line";
    public static final String ALGORITHM_RADIATE = "radiate";
    public static final String ALGORITHM_VARNA_VIEW = "varnaview";
    public static final String ALGORITHM_MOTIF_VIEW = "motifview";

    public VARNAConfigLoader(InterfaceParameterLoader il) {
        this._optionProducer = il;
    }

    public ArrayList<VARNAPanel> createVARNAPanels() throws ExceptionParameterError, ExceptionModeleStyleBaseSyntaxError, ExceptionNonEqualLength, IOException, ExceptionFileFormatOrSyntax, ExceptionLoadingFailed {
        this.retrieveParametersValues();
        return this._VARNAPanelList;
    }

    public int getNbRows() {
        return this._numRows;
    }

    public int getNbColumns() {
        return this._numColumns;
    }

    private void initValues() {
        this._algo = ALGORITHM_RADIATE;
        this._auxBPs = "";
        this._autoHelices = false;
        this._autoInteriorLoops = false;
        this._autoTerminalLoops = false;
        this._annotations = "";
        this._backgroundColor = VARNAConfig.DEFAULT_BACKGROUND_COLOR;
        this._customBases = "";
        this._customBPs = "";
        this._chemProbs = "";
        this._colorMapStyle = "";
        this._colorMapValues = "";
        this._colorMapCaption = "";
        this._drawColorMap = false;
        this._drawNC = true;
        this._drawTertiary = true;
        this._border = new Dimension(0, 0);
        this._sseq = "";
        this._sstruct = "";
        this._periodResNum = 10;
        this._rotation = 0.0;
        this._title = "";
        this._titleSize = VARNAConfig.DEFAULT_TITLE_FONT.getSize();
        this._backboneColor = VARNAConfig.DEFAULT_BACKBONE_COLOR;
        this._drawBackbone = true;
        this._bondColor = VARNAConfig.DEFAULT_BOND_COLOR;
        this._bpStyle = VARNAConfig.DEFAULT_BP_STYLE;
        this._highlightRegion = "";
        this._baseOutlineColor = VARNAConfig.BASE_OUTLINE_COLOR_DEFAULT;
        this._baseInnerColor = VARNAConfig.BASE_INNER_COLOR_DEFAULT;
        this._baseNumColor = VARNAConfig.BASE_NUMBER_COLOR_DEFAULT;
        this._baseNameColor = VARNAConfig.BASE_NAME_COLOR_DEFAULT;
        this._titleColor = VARNAConfig.DEFAULT_TITLE_COLOR;
        this._warning = false;
        this._error = true;
        this._modifiable = true;
        this._zoom = 1.0;
        this._zoomAmount = 1.2;
        this._comparisonMode = false;
        this._firstSequence = "";
        this._firstStructure = "";
        this._secondSequence = "";
        this._secondStructure = "";
        this._gapsColor = VARNAConfig.DEFAULT_DASH_BASE_COLOR;
        this._useGapsColor = false;
        this._nonStandardColor = VARNAConfig.DEFAULT_SPECIAL_BASE_COLOR;
        this._useNonStandardColor = false;
        this._useInnerBaseColor = false;
        this._useBaseNameColor = false;
        this._useBaseNumbersColor = false;
        this._useBaseOutlineColor = false;
        this._bpIncrement = 0.65;
        this._URL = "";
        this._flatExteriorLoop = false;
        this._orientation = "";
    }

    public static Color getSafeColor(String col, Color def) {
        Color result;
        try {
            result = Color.decode(col);
        }
        catch (NumberFormatException e) {
            try {
                result = Color.getColor(col, def);
            }
            catch (Exception e2) {
                return def;
            }
        }
        return result;
    }

    private VARNAConfig.BP_STYLE getSafeBPStyle(String opt, VARNAConfig.BP_STYLE def) {
        if (opt.toLowerCase().equals(LEONTIS_WESTHOF_BP_STYLE)) {
            return VARNAConfig.BP_STYLE.LW;
        }
        if (opt.toLowerCase().equals(SIMPLE_BP_STYLE)) {
            return VARNAConfig.BP_STYLE.SIMPLE;
        }
        if (opt.toLowerCase().equals(RNAVIZ_BP_STYLE)) {
            return VARNAConfig.BP_STYLE.RNAVIZ;
        }
        if (opt.toLowerCase().equals(NONE_BP_STYLE)) {
            return VARNAConfig.BP_STYLE.NONE;
        }
        return def;
    }

    public static String[][] getParameterInfo() {
        String[][] info = new String[][]{{algoOpt, "String", "Drawing algorithm, choosen from [naview,line,radiate,circular]"}, {annotationsOpt, "string", "A set of textual annotations"}, {applyBasesStyleOpt, "String", "Base style application"}, {auxBPsOpt, "String", "Adds a list of (possibly non-canonical) base-pairs to those already defined by the main secondary structure (Ex: \"(1,10);(2,11);(3,12)\"). Custom BP styles can be specified (Ex: \"(2,11):thickness=4;(3,12):color=#FF0000\")."}, {autoHelicesOpt, "", ""}, {autoInteriorLoopsOpt, "", ""}, {autoTerminalLoopsOpt, "", ""}, {backboneColorOpt, "Color", "Backbone color (Ex: #334455)"}, {backgroundColorOpt, "Color", "Background color (Ex: #334455)"}, {baseInnerColorOpt, "Color", "Default value for inner base color (Ex: #334455)"}, {baseNameColorOpt, "Color", "Residues font color (Ex: #334455)"}, {baseNumbersColorOpt, "Color", "Base numbers font color (Ex: #334455)"}, {baseOutlineColorOpt, "Color", "Base outline color (Ex: #334455)"}, {basesStyleOpt, "String", "Base style declaration"}, {borderOpt, "String", "Border width and height in pixels (Ex: \"20x40\")"}, {bondColorOpt, "Color", "Base pair color (Ex: #334455)"}, {bpIncrementOpt, "float", "Distance between nested base-pairs (i.e. arcs) in linear representation"}, {bpStyleOpt, "String", "Look and feel for base pairs drawings, choosen from [lw,none,simple,rnaviz]"}, {chemProbOpt, "", ""}, {colorMapOpt, "String", "Associates a list of numerical values (eg '0.2,0.4,0.6,0.8') with the RNA bases with respect to their natural order, and modifies the color used to fill these bases according to current color map style."}, {colorMapCaptionOpt, "String", "Sets current color map caption."}, {colorMapDefOpt, "String", "Selects a specific color map style. It can be either one of the predefined styles (eg 'red', 'green', 'blue', 'bw', 'heat', 'energy') or a new one (eg '0:#FFFF00;1:#ffFFFF;6:#FF0000')."}, {colorMapMinOpt, "", ""}, {colorMapMaxOpt, "", ""}, {comparisonModeOpt, "boolean", "Activates comparison mode"}, {customBasesOpt, "", ""}, {customBPsOpt, "", ""}, {drawBackboneOpt, "boolean", "True if the backbone must be drawn, false otherwise"}, {drawColorMapOpt, "", ""}, {drawNCOpt, "boolean", "Toggles on/off display of non-canonical base-pairs"}, {drawTertiaryOpt, "boolean", "Toggles on/off display of tertiary interaction, ie pseudoknots"}, {errorOpt, "boolean", "Show errors"}, {firstSequenceForComparisonOpt, "String", "In comparison mode, sequence of first RNA"}, {firstStructureForComparisonOpt, "String", "In comparison mode, structure of first RNA"}, {flatExteriorLoopOpt, "boolean", "Toggles on/off (true/false) drawing exterior bases on a straight line"}, {gapsBaseColorOpt, "Color", "Define and use custom color for gaps bases in comparison mode"}, {highlightRegionOpt, "", ""}, {modifiableOpt, "boolean", "Allows/prohibits modifications"}, {nonStandardColorOpt, "Color", "Define and use custom color for non-standard bases in comparison mode"}, {numColumnsOpt, "", ""}, {numRowsOpt, "", ""}, {orientationOpt, "float", "Sets the general orientation of an RNA, i.e. the deviation of the longest axis (defined by the most distant couple of bases) from the horizontal axis."}, {periodNumOpt, "int", "Periodicity of base-numbering"}, {secondSequenceForComparisonOpt, "String", "In comparison mode, sequence of second RNA"}, {secondStructureForComparisonOpt, "String", "In comparison mode, structure of second RNA"}, {sequenceOpt, "String", "Raw RNA sequence"}, {structureOpt, "String", "RNA structure given in dot bracket notation (DBN)"}, {rotationOpt, "float", "Rotates RNA after initial drawing (Ex: '20' for a 20 degree counter-clockwise rotation)"}, {titleOpt, "String", "RNA drawing title"}, {titleColorOpt, "Color", "Title color (Ex: #334455)"}, {titleSizeOpt, "int", "Title font size"}, {warningOpt, "boolean", "Show warnings"}, {zoomOpt, "int", "Zoom coefficient"}, {zoomAmountOpt, "int", "Zoom increment on user interaction"}};
        return info;
    }

    private void retrieveParametersValues() throws ExceptionParameterError, ExceptionModeleStyleBaseSyntaxError, ExceptionNonEqualLength, IOException, ExceptionFileFormatOrSyntax, ExceptionLoadingFailed {
        this._numRows = 1;
        this._numColumns = 1;
        this._basesStyleList = new ArrayList();
        try {
            this._numRows = Integer.parseInt(this._optionProducer.getParameterValue(numRowsOpt, "" + this._numRows));
        }
        catch (NumberFormatException e) {
            throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(numRowsOpt, "" + this._numRows) + "' is not a integer value for the number of rows !");
        }
        try {
            this._numColumns = Integer.parseInt(this._optionProducer.getParameterValue(numColumnsOpt, "" + this._numColumns));
        }
        catch (NumberFormatException e) {
            throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(numColumnsOpt, "" + this._numColumns) + "' is not a integer value for the number of columns !");
        }
        String tmp = null;
        int i = 0;
        while (i < 50) {
            String opt = String.valueOf(basesStyleOpt) + i;
            tmp = this._optionProducer.getParameterValue(opt, null);
            System.out.println(String.valueOf(opt) + "->" + tmp);
            if (tmp != null) {
                ModelBaseStyle msb = new ModelBaseStyle();
                msb.assignParameters(tmp);
                this._basesStyleList.add(msb);
            } else {
                this._basesStyleList.add(null);
            }
            ++i;
        }
        this.initValues();
        int i2 = 0;
        while (i2 < this._numColumns) {
            int j = 0;
            while (j < this._numRows) {
                int x = 1 + j + i2 * this._numRows;
                String n = "" + x;
                if (this._numColumns == 1 && this._numRows == 1) {
                    n = "";
                }
                this._useGapsColor = false;
                this._useNonStandardColor = false;
                tmp = this._optionProducer.getParameterValue(String.valueOf(baseNameColorOpt) + n, "");
                if (!tmp.equals("")) {
                    this._useBaseNameColor = true;
                    this._baseNameColor = VARNAConfigLoader.getSafeColor(tmp, this._baseNameColor);
                }
                if (!(tmp = this._optionProducer.getParameterValue(String.valueOf(baseNumbersColorOpt) + n, "")).equals("")) {
                    this._useBaseNumbersColor = true;
                    this._baseNumColor = VARNAConfigLoader.getSafeColor(tmp, this._baseNumColor);
                }
                if (!(tmp = this._optionProducer.getParameterValue(String.valueOf(baseOutlineColorOpt) + n, "")).equals("")) {
                    this._useBaseOutlineColor = true;
                    this._baseOutlineColor = VARNAConfigLoader.getSafeColor(tmp, this._baseOutlineColor);
                }
                if (!(tmp = this._optionProducer.getParameterValue(String.valueOf(baseInnerColorOpt) + n, "")).equals("")) {
                    this._useInnerBaseColor = true;
                    this._baseInnerColor = VARNAConfigLoader.getSafeColor(tmp, this._baseInnerColor);
                }
                if (!(tmp = this._optionProducer.getParameterValue(String.valueOf(nonStandardColorOpt) + n, "")).equals("")) {
                    this._nonStandardColor = VARNAConfigLoader.getSafeColor(tmp, this._nonStandardColor);
                    this._useNonStandardColor = true;
                }
                if (!(tmp = this._optionProducer.getParameterValue(String.valueOf(gapsBaseColorOpt) + n, this._gapsColor.toString())).equals("")) {
                    this._gapsColor = VARNAConfigLoader.getSafeColor(tmp, this._gapsColor);
                    this._useGapsColor = true;
                }
                try {
                    this._rotation = Double.parseDouble(this._optionProducer.getParameterValue(String.valueOf(rotationOpt) + n, Double.toString(this._rotation)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(String.valueOf(rotationOpt) + n, "" + this._rotation) + "' is not a valid float value for rotation!");
                }
                try {
                    this._colorMapMin = Double.parseDouble(this._optionProducer.getParameterValue(String.valueOf(colorMapMinOpt) + n, Double.toString(this._colorMapMin)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(String.valueOf(colorMapMinOpt) + n, "" + this._colorMapMin) + "' is not a valid double value for min color map values range!");
                }
                try {
                    this._colorMapMax = Double.parseDouble(this._optionProducer.getParameterValue(String.valueOf(colorMapMaxOpt) + n, Double.toString(this._colorMapMax)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(String.valueOf(colorMapMaxOpt) + n, "" + this._colorMapMax) + "' is not a valid double value for max color map values range!");
                }
                try {
                    this._bpIncrement = Double.parseDouble(this._optionProducer.getParameterValue(String.valueOf(bpIncrementOpt) + n, Double.toString(this._bpIncrement)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                try {
                    this._periodResNum = Integer.parseInt(this._optionProducer.getParameterValue(String.valueOf(periodNumOpt) + n, "" + this._periodResNum));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(String.valueOf(periodNumOpt) + n, "" + this._periodResNum) + "' is not a valid integer value for the period of residue numbers!");
                }
                try {
                    this._titleSize = Integer.parseInt(this._optionProducer.getParameterValue(String.valueOf(titleSizeOpt) + n, "" + this._titleSize));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(String.valueOf(titleSizeOpt) + n, "" + this._titleSize) + "' is not a valid integer value for the number of rows !");
                }
                try {
                    this._zoom = Double.parseDouble(this._optionProducer.getParameterValue(String.valueOf(zoomOpt) + n, "" + this._zoom));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(String.valueOf(zoomOpt) + n, "" + this._zoom) + "' is not a valid integer value for the zoom !");
                }
                try {
                    this._zoomAmount = Double.parseDouble(this._optionProducer.getParameterValue(String.valueOf(zoomAmountOpt) + n, "" + this._zoomAmount));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "'" + this._optionProducer.getParameterValue(String.valueOf(zoomAmountOpt) + n, "" + this._zoomAmount) + "' is not a valid integer value for the zoom amount !");
                }
                this._autoHelices = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(autoHelicesOpt) + n, "" + this._autoHelices));
                this._drawColorMap = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(drawColorMapOpt) + n, "" + this._drawColorMap));
                this._drawBackbone = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(drawBackboneOpt) + n, "" + this._drawBackbone));
                this._colorMapValues = this._optionProducer.getParameterValue(String.valueOf(colorMapOpt) + n, this._colorMapValues);
                this._autoTerminalLoops = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(autoTerminalLoopsOpt) + n, "" + this._autoTerminalLoops));
                this._autoInteriorLoops = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(autoInteriorLoopsOpt) + n, "" + this._autoInteriorLoops));
                this._drawNC = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(drawNCOpt) + n, "" + this._drawNC));
                this._flatExteriorLoop = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(flatExteriorLoopOpt) + n, "" + this._flatExteriorLoop));
                this._drawTertiary = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(drawTertiaryOpt) + n, "" + this._drawTertiary));
                this._warning = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(warningOpt) + n, "false"));
                this._error = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(errorOpt) + n, "true"));
                this._border = this.parseDimension(this._optionProducer.getParameterValue(String.valueOf(borderOpt) + n, "0X0"));
                this._comparisonMode = Boolean.parseBoolean(this._optionProducer.getParameterValue(String.valueOf(comparisonModeOpt) + n, "false"));
                this._firstSequence = this._optionProducer.getParameterValue(String.valueOf(firstSequenceForComparisonOpt) + n, this._firstSequence);
                this._firstStructure = this._optionProducer.getParameterValue(String.valueOf(firstStructureForComparisonOpt) + n, this._firstStructure);
                this._secondSequence = this._optionProducer.getParameterValue(String.valueOf(secondSequenceForComparisonOpt) + n, this._secondSequence);
                this._secondStructure = this._optionProducer.getParameterValue(String.valueOf(secondStructureForComparisonOpt) + n, this._secondStructure);
                this._annotations = this._optionProducer.getParameterValue(String.valueOf(annotationsOpt) + n, this._annotations);
                this._URL = this._optionProducer.getParameterValue(String.valueOf(URLOpt) + n, this._URL);
                this._algo = this._optionProducer.getParameterValue(String.valueOf(algoOpt) + n, this._algo);
                this._customBases = this._optionProducer.getParameterValue(String.valueOf(customBasesOpt) + n, this._customBases);
                this._auxBPs = this._optionProducer.getParameterValue(String.valueOf(auxBPsOpt) + n, this._auxBPs);
                this._highlightRegion = this._optionProducer.getParameterValue(String.valueOf(highlightRegionOpt) + n, this._highlightRegion);
                this._chemProbs = this._optionProducer.getParameterValue(String.valueOf(chemProbOpt) + n, this._chemProbs);
                this._customBPs = this._optionProducer.getParameterValue(String.valueOf(customBPsOpt) + n, this._customBPs);
                this._colorMapStyle = this._optionProducer.getParameterValue(String.valueOf(colorMapDefOpt) + n, this._colorMapStyle);
                this._colorMapCaption = this._optionProducer.getParameterValue(String.valueOf(colorMapCaptionOpt) + n, this._colorMapCaption);
                this._backboneColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(String.valueOf(backboneColorOpt) + n, this._backboneColor.toString()), this._backboneColor);
                this._backgroundColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(String.valueOf(backgroundColorOpt) + n, this._backgroundColor.toString()), this._backgroundColor);
                this._bondColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(String.valueOf(bondColorOpt) + n, this._bondColor.toString()), this._bondColor);
                this._bpStyle = this.getSafeBPStyle(this._optionProducer.getParameterValue(String.valueOf(bpStyleOpt) + n, ""), this._bpStyle);
                this._title = this._optionProducer.getParameterValue(String.valueOf(titleOpt) + n, this._title);
                this._orientation = this._optionProducer.getParameterValue(String.valueOf(orientationOpt) + n, this._orientation);
                this._titleColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(String.valueOf(titleColorOpt) + n, this._titleColor.toString()), this._titleColor);
                if (!this._URL.equals("")) {
                    this._sstruct = "";
                    this._sseq = "";
                }
                if (!this._comparisonMode || this._firstSequence == null || this._firstStructure == null || this._secondSequence == null || this._secondStructure == null) {
                    this._sseq = this._optionProducer.getParameterValue(String.valueOf(sequenceOpt) + n, this._sseq);
                    this._sstruct = this._optionProducer.getParameterValue(String.valueOf(structureOpt) + n, this._sstruct);
                    if (!this._sseq.equals("") && !this._sstruct.equals("")) {
                        this._URL = "";
                    }
                    this._comparisonMode = false;
                }
                this.applyValues(n);
                ++j;
            }
            ++i2;
        }
    }

    public void setRNA(RNA r) {
        this._defaultRNA = r;
    }

    private void applyValues(String n) throws ExceptionParameterError, ExceptionNonEqualLength, IOException, ExceptionFileFormatOrSyntax, ExceptionLoadingFailed {
        int algoCode = this._algo.equals(ALGORITHM_CIRCULAR) ? 1 : (this._algo.equals(ALGORITHM_NAVIEW) ? 3 : (this._algo.equals(ALGORITHM_LINE) ? 4 : (this._algo.equals(ALGORITHM_RADIATE) ? 2 : (this._algo.equals(ALGORITHM_VARNA_VIEW) ? 5 : (this._algo.equals(ALGORITHM_MOTIF_VIEW) ? 6 : 2)))));
        if (this._comparisonMode) {
            this._mainSurface = new VARNAPanel(this._firstSequence, this._firstStructure, this._secondSequence, this._secondStructure, algoCode, "");
        } else if (this._URL.equals("")) {
            if (!this._sstruct.equals("")) {
                this._mainSurface = new VARNAPanel(this._sseq, this._sstruct, algoCode);
            } else {
                this._mainSurface = new VARNAPanel();
                try {
                    this._defaultRNA.drawRNA(algoCode, this._mainSurface.getConfig());
                }
                catch (ExceptionDrawingAlgorithm e) {
                    e.printStackTrace();
                }
                this._mainSurface.drawRNA(this._defaultRNA);
            }
        } else {
            URL url = null;
            try {
                url = new URL(this._URL);
                URLConnection connexion = url.openConnection();
                connexion.setUseCaches(false);
                InputStream r = connexion.getInputStream();
                InputStreamReader inr = new InputStreamReader(r);
                this._mainSurface = new VARNAPanel();
                if (this._URL.toLowerCase().endsWith(VARNAPanel.VARNA_SESSION_EXTENSION)) {
                    FullBackup f = VARNAPanel.importSession(r, this._URL);
                    this._mainSurface.setConfig(f.config);
                    this._mainSurface.showRNA(f.rna);
                } else {
                    ArrayList<RNA> rnas = RNAFactory.loadSecStr(new BufferedReader(inr), RNAFactory.guessFileTypeFromExtension(this._URL));
                    if (rnas.isEmpty()) {
                        throw new ExceptionFileFormatOrSyntax("No RNA in file '" + this._URL + "'.");
                    }
                    RNA rna = (RNA)rnas.iterator().next();
                    rna.drawRNA(algoCode, this._mainSurface.getConfig());
                    this._mainSurface.drawRNA(rna, algoCode);
                }
            }
            catch (ExceptionFileFormatOrSyntax e) {
                e.setPath(url.getPath());
            }
            catch (ExceptionDrawingAlgorithm e) {
                e.printStackTrace();
            }
            if (this._mainSurface == null) {
                this._mainSurface = new VARNAPanel("X", ".", algoCode);
            }
        }
        if (this._useInnerBaseColor) {
            this._mainSurface.setBaseInnerColor(this._baseInnerColor);
        }
        if (this._useBaseOutlineColor) {
            this._mainSurface.setBaseOutlineColor(this._baseOutlineColor);
        }
        if (this._useBaseNameColor) {
            this._mainSurface.setBaseNameColor(this._baseNameColor);
        }
        if (this._useBaseNumbersColor) {
            this._mainSurface.setBaseNumbersColor(this._baseNumColor);
        }
        this._mainSurface.setBackground(this._backgroundColor);
        this._mainSurface.setNumPeriod(this._periodResNum);
        this._mainSurface.setBackboneColor(this._backboneColor);
        this._mainSurface.setDefaultBPColor(this._bondColor);
        this._mainSurface.setBPHeightIncrement(this._bpIncrement);
        this._mainSurface.setBPStyle(this._bpStyle);
        this._mainSurface.setDrawBackbone(this._drawBackbone);
        this._mainSurface.setTitleFontColor(this._titleColor);
        this._mainSurface.setTitle(this._title);
        this._mainSurface.setTitleFontSize(this._titleSize);
        this._mainSurface.getPopupMenu().get_itemShowWarnings().setState(this._warning);
        this._mainSurface.setErrorsOn(this._error);
        this._mainSurface.setFlatExteriorLoop(this._flatExteriorLoop);
        this._mainSurface.setZoom(this._zoom);
        this._mainSurface.setZoomIncrement(this._zoomAmount);
        this._mainSurface.setBorderSize(this._border);
        if (this._useGapsColor) {
            this._mainSurface.setGapsBasesColor(this._gapsColor);
            this._mainSurface.setColorGapsBases(true);
        }
        if (this._useNonStandardColor) {
            this._mainSurface.setNonStandardBasesColor(this._nonStandardColor);
            this._mainSurface.setColorNonStandardBases(true);
        }
        this._mainSurface.setShowNonPlanarBP(this._drawTertiary);
        this._mainSurface.setShowNonCanonicalBP(this._drawNC);
        this.applyBasesStyle(n);
        if (!this._customBases.equals("")) {
            this.applyBasesCustomStyles(this._mainSurface);
        }
        if (!this._highlightRegion.equals("")) {
            this.applyHighlightRegion(this._mainSurface);
        }
        if (!this._auxBPs.equals("")) {
            this.applyAuxBPs(this._mainSurface);
        }
        if (!this._chemProbs.equals("")) {
            this.applyChemProbs(this._mainSurface);
        }
        if (!this._customBPs.equals("")) {
            this.applyBPsCustomStyles(this._mainSurface);
        }
        this._mainSurface.drawRNA();
        if (!this._annotations.equals("")) {
            this.applyAnnotations(this._mainSurface);
        }
        if (this._autoHelices) {
            this._mainSurface.getVARNAUI().UIAutoAnnotateHelices();
        }
        if (this._autoTerminalLoops) {
            this._mainSurface.getVARNAUI().UIAutoAnnotateTerminalLoops();
        }
        if (this._autoInteriorLoops) {
            this._mainSurface.getVARNAUI().UIAutoAnnotateInteriorLoops();
        }
        if (!this._orientation.equals("")) {
            try {
                double d = 360.0 * this._mainSurface.getOrientation() / (Math.PI * 2);
                this._rotation = Double.parseDouble(this._orientation) - d;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this._mainSurface.globalRotation(this._rotation);
        this._mainSurface.setModifiable(this._modifiable);
        this._mainSurface.setColorMapCaption(this._colorMapCaption);
        this.applyColorMapStyle(this._mainSurface);
        this.applyColorMapValues(this._mainSurface);
        this._VARNAPanelList.add(this._mainSurface);
    }

    private void applyBasesStyle(String n) throws ExceptionParameterError {
        String tmp = null;
        int numStyle = 0;
        while (numStyle < this._basesStyleList.size()) {
            System.out.println(this._basesStyleList.get(numStyle));
            if (this._basesStyleList.get(numStyle) != null) {
                tmp = this._optionProducer.getParameterValue(String.valueOf(applyBasesStyleOpt) + numStyle + "on" + n, null);
                ArrayList<Integer> indicesList = new ArrayList<Integer>();
                if (tmp != null) {
                    String[] basesList = tmp.split(",");
                    int k = 0;
                    while (k < basesList.length) {
                        String cand = basesList[k].trim();
                        try {
                            String[] args = cand.split("-");
                            if (args.length == 1) {
                                int baseNum = Integer.parseInt(cand);
                                int index = this._mainSurface.getRNA().getIndexFromBaseNumber(baseNum);
                                if (index != -1) {
                                    indicesList.add(index);
                                }
                            } else if (args.length == 2) {
                                int baseNumFrom = Integer.parseInt(args[0].trim());
                                int indexFrom = this._mainSurface.getRNA().getIndexFromBaseNumber(baseNumFrom);
                                int baseNumTo = Integer.parseInt(args[1].trim());
                                int indexTo = this._mainSurface.getRNA().getIndexFromBaseNumber(baseNumTo);
                                if (indexFrom != -1 && indexTo != -1) {
                                    int l = indexFrom;
                                    while (l <= indexTo) {
                                        indicesList.add(l);
                                        ++l;
                                    }
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new ExceptionParameterError(e.getMessage(), "Bad Base Index: " + basesList[k]);
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < indicesList.size()) {
                        int index = (Integer)indicesList.get(k);
                        System.out.print(String.valueOf(index) + ", ");
                        if (index >= 0 && index < this._mainSurface.getRNA().get_listeBases().size()) {
                            this._mainSurface.getRNA().get_listeBases().get(index).setStyleBase(this._basesStyleList.get(numStyle));
                        }
                        ++k;
                    }
                    System.out.println();
                }
            }
            ++numStyle;
        }
    }

    private void applyColorMapStyle(VARNAPanel vp) {
        if (this._colorMapStyle.length() == 0) {
            vp.setColorMap(ModeleColorMap.parseColorMap(this._colorMapStyle));
        }
    }

    private void applyColorMapValues(VARNAPanel vp) {
        if (!this._colorMapValues.equals("")) {
            String[] values = this._colorMapValues.split("[;,]");
            ArrayList<Double> vals = new ArrayList<Double>();
            int i = 0;
            while (i < values.length) {
                try {
                    vals.add(Double.parseDouble(values[i]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            Double[] result = new Double[vals.size()];
            vals.toArray(result);
            vp.setColorMapValues(result);
            ModeleColorMap cm = vp.getColorMap();
            if (this._colorMapMin != Double.MIN_VALUE) {
                cm.setMinValue(this._colorMapMin);
            }
            if (this._colorMapMax != Double.MAX_VALUE) {
                cm.setMaxValue(this._colorMapMax);
            }
            this._drawColorMap = true;
        }
    }

    private void applyBasesCustomStyles(VARNAPanel vp) {
        String[] baseStyles = this._customBases.split(";");
        int i = 0;
        while (i < baseStyles.length) {
            String thisStyle = baseStyles[i];
            String[] data = thisStyle.split(":");
            try {
                if (data.length == 2) {
                    int baseNum = Integer.parseInt(data[0]);
                    int index = this._mainSurface.getRNA().getIndexFromBaseNumber(baseNum);
                    if (index != -1) {
                        String style = data[1];
                        ModelBaseStyle msb = vp.getRNA().get_listeBases().get(index).getStyleBase().clone();
                        msb.assignParameters(style);
                        vp.getRNA().get_listeBases().get(index).setStyleBase(msb);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("ApplyBasesCustomStyle: " + e.toString());
            }
            ++i;
        }
    }

    private void applyHighlightRegion(VARNAPanel vp) {
        String[] regions = this._highlightRegion.split(";");
        int i = 0;
        while (i < regions.length) {
            String region = regions[i];
            try {
                HighlightRegionAnnotation nt = HighlightRegionAnnotation.parseHighlightRegionAnnotation(region, vp);
                if (nt != null) {
                    vp.addHighlightRegion(nt);
                }
            }
            catch (Exception e) {
                System.err.println("applyHighlightRegion: " + e.toString());
            }
            ++i;
        }
    }

    private Dimension parseDimension(String s) {
        Dimension d = new Dimension(0, 0);
        try {
            s = s.toLowerCase();
            int i = s.indexOf(120);
            String w = s.substring(0, i);
            String h = s.substring(i + 1);
            d.width = Integer.parseInt(w);
            d.height = Integer.parseInt(h);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    private void applyBPsCustomStyles(VARNAPanel vp) {
        String[] baseStyles = this._customBPs.split(";");
        int i = 0;
        while (i < baseStyles.length) {
            String thisStyle = baseStyles[i];
            String[] data = thisStyle.split(":");
            try {
                if (data.length == 2) {
                    String indices = data[0];
                    String style = data[1];
                    String[] data2 = indices.split(",");
                    if (data2.length == 2) {
                        String s1 = data2[0];
                        String s2 = data2[1];
                        if (s1.startsWith("(") && s2.endsWith(")")) {
                            int a = Integer.parseInt(s1.substring(1));
                            int b = Integer.parseInt(s2.substring(0, s2.length() - 1));
                            ModeleBP msbp = vp.getRNA().getBPStyle(a, b);
                            if (msbp != null) {
                                msbp.assignParameters(style);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("ApplyBPsCustomStyle: " + e.toString());
            }
            ++i;
        }
    }

    private void applyChemProbs(VARNAPanel vp) {
        String[] chemProbs = this._chemProbs.split(";");
        int i = 0;
        while (i < chemProbs.length) {
            String thisAnn = chemProbs[i];
            String[] data = thisAnn.split(":");
            try {
                if (data.length == 2) {
                    String indices = data[0];
                    String style = data[1];
                    String[] data2 = indices.split("-");
                    if (data2.length == 2) {
                        int a = Integer.parseInt(data2[0]);
                        int b = Integer.parseInt(data2[1]);
                        int c = vp.getRNA().getIndexFromBaseNumber(a);
                        int d = vp.getRNA().getIndexFromBaseNumber(b);
                        ArrayList<ModeleBase> mbl = vp.getRNA().get_listeBases();
                        ChemProbAnnotation cpa = new ChemProbAnnotation(mbl.get(c), mbl.get(d), style);
                        vp.getRNA().addChemProbAnnotation(cpa);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("ChempProbs: " + e.toString());
            }
            ++i;
        }
    }

    private void applyAuxBPs(VARNAPanel vp) {
        String[] baseStyles = this._auxBPs.split(";");
        int i = 0;
        while (i < baseStyles.length) {
            String thisStyle = baseStyles[i];
            String[] data = thisStyle.split(":");
            try {
                String indices;
                String[] data2;
                if (data.length >= 1 && (data2 = (indices = data[0]).split(",")).length == 2) {
                    String s1 = data2[0];
                    String s2 = data2[1];
                    if (s1.startsWith("(") && s2.endsWith(")")) {
                        int a = Integer.parseInt(s1.substring(1));
                        int b = Integer.parseInt(s2.substring(0, s2.length() - 1));
                        int c = vp.getRNA().getIndexFromBaseNumber(a);
                        int d = vp.getRNA().getIndexFromBaseNumber(b);
                        ModeleBP msbp = new ModeleBP(vp.getRNA().get_listeBases().get(c), vp.getRNA().get_listeBases().get(d));
                        if (data.length >= 2) {
                            String style = data[1];
                            msbp.assignParameters(style);
                        }
                        vp.getRNA().addBPToStructureUsingNumbers(a, b, msbp);
                    }
                }
            }
            catch (ExceptionModeleStyleBaseSyntaxError e1) {
                System.err.println("AuxApplyBPs: " + e1.toString());
            }
            catch (ExceptionParameterError e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void applyAnnotations(VARNAPanel vp) {
        String[] annotations = this._annotations.split(";");
        int i = 0;
        while (i < annotations.length) {
            String thisAnn = annotations[i];
            String[] data = thisAnn.split(":");
            String text = "";
            int anchor = -1;
            int x = -1;
            int y = -1;
            TextAnnotation.AnchorType type = TextAnnotation.AnchorType.LOOP;
            Font font = TextAnnotation.DEFAULTFONT;
            Color color = TextAnnotation.DEFAULTCOLOR;
            TextAnnotation ann = null;
            try {
                if (data.length == 2) {
                    text = data[0];
                    String[] data2 = data[1].split(",");
                    int j = 0;
                    while (j < data2.length) {
                        String opt = data2[j];
                        String[] data3 = opt.split("=");
                        if (data3.length == 2) {
                            String name = data3[0].toLowerCase();
                            String value = data3[1];
                            if (name.equals("type")) {
                                if (value.toUpperCase().equals("H")) {
                                    type = TextAnnotation.AnchorType.HELIX;
                                } else if (value.toUpperCase().equals("L")) {
                                    type = TextAnnotation.AnchorType.LOOP;
                                } else if (value.toUpperCase().equals("P")) {
                                    type = TextAnnotation.AnchorType.POSITION;
                                } else if (value.toUpperCase().equals("B")) {
                                    type = TextAnnotation.AnchorType.BASE;
                                }
                            } else if (name.equals("x")) {
                                x = Integer.parseInt(value);
                            } else if (name.equals("y")) {
                                y = Integer.parseInt(value);
                            } else if (name.equals("anchor")) {
                                anchor = Integer.parseInt(value);
                            } else if (name.equals("size")) {
                                font = font.deriveFont((float)Integer.parseInt(value));
                            } else if (name.equals("color")) {
                                color = VARNAConfigLoader.getSafeColor(value, color);
                            }
                        }
                        ++j;
                    }
                    switch (type) {
                        case POSITION: {
                            if (x == -1 || y == -1) break;
                            Point2D.Double p = vp.panelToLogicPoint(new Point2D.Double(x, y));
                            ann = new TextAnnotation(text, p.x, p.y);
                            break;
                        }
                        case BASE: {
                            if (anchor == -1) break;
                            int index = vp.getRNA().getIndexFromBaseNumber(anchor);
                            ModeleBase mb = vp.getRNA().get_listeBases().get(index);
                            ann = new TextAnnotation(text, mb);
                            break;
                        }
                        case HELIX: {
                            if (anchor == -1) break;
                            ArrayList<ModeleBase> mbl = new ArrayList<ModeleBase>();
                            int index = vp.getRNA().getIndexFromBaseNumber(anchor);
                            ArrayList<Integer> il = vp.getRNA().findHelix(index);
                            for (int k : il) {
                                mbl.add(vp.getRNA().get_listeBases().get(k));
                            }
                            ann = new TextAnnotation(text, mbl, type);
                            break;
                        }
                        case LOOP: {
                            if (anchor == -1) break;
                            ArrayList<ModeleBase> mbl = new ArrayList<ModeleBase>();
                            int index = vp.getRNA().getIndexFromBaseNumber(anchor);
                            ArrayList<Integer> il = vp.getRNA().findLoop(index);
                            for (int k : il) {
                                mbl.add(vp.getRNA().get_listeBases().get(k));
                            }
                            ann = new TextAnnotation(text, mbl, type);
                        }
                    }
                    if (ann != null) {
                        ann.setColor(color);
                        ann.setFont(font);
                        vp.addAnnotation(ann);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Apply Annotations: " + e.toString());
            }
            ++i;
        }
    }
}

