/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models;

import java.awt.geom.Point2D;

public class CubicBezierCurve {
    private Point2D.Double P0;
    private Point2D.Double P1;
    private Point2D.Double P2;
    private Point2D.Double P3;
    private int n;
    private Point2D.Double[] points;
    private double[] lengths;
    private Point2D.Double[] unitVectors;

    public int getN() {
        return this.n;
    }

    public double getApproxCurveLength() {
        return this.lengths[this.n - 1];
    }

    public Point2D.Double standardParam(double t) {
        double x = Math.pow(1.0 - t, 3.0) * this.P0.x + 3.0 * Math.pow(1.0 - t, 2.0) * t * this.P1.x + 3.0 * (1.0 - t) * t * t * this.P2.x + t * t * t * this.P3.x;
        double y = Math.pow(1.0 - t, 3.0) * this.P0.y + 3.0 * Math.pow(1.0 - t, 2.0) * t * this.P1.y + 3.0 * (1.0 - t) * t * t * this.P2.y + t * t * t * this.P3.y;
        return new Point2D.Double(x, y);
    }

    /*
     * Unable to fully structure code
     */
    public Point2D.Double[] uniformParam(double[] t) {
        m = t.length;
        result = new Point2D.Double[m];
        line = 0;
        i = 0;
        ** GOTO lbl16
        {
            ++line;
            do {
                if (line < this.n && this.lengths[line] < t[i]) continue block0;
                if (line >= this.n || t[i] < 0.0) {
                    throw new IllegalArgumentException("element t[" + i + "] is not in [0, getApproxCurveLength()]");
                }
                lengthOnLine = t[i] - (line != 0 ? this.lengths[line - 1] : 0.0);
                x = this.points[line].x + this.unitVectors[line].x * lengthOnLine;
                y = this.points[line].y + this.unitVectors[line].y * lengthOnLine;
                result[i] = new Point2D.Double(x, y);
                ++i;
lbl16:
                // 2 sources

            } while (i < m);
        }
        return result;
    }

    public CubicBezierCurve(Point2D.Double P0, Point2D.Double P1, Point2D.Double P2, Point2D.Double P3, int n) {
        this.P0 = P0;
        this.P1 = P1;
        this.P2 = P2;
        this.P3 = P3;
        this.n = n;
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1");
        }
        this.computeData();
    }

    private void computeData() {
        this.points = new Point2D.Double[this.n + 1];
        int k = 0;
        while (k <= this.n) {
            this.points[k] = this.standardParam((double)k / (double)this.n);
            ++k;
        }
        this.lengths = new double[this.n];
        this.unitVectors = new Point2D.Double[this.n];
        double sum = 0.0;
        int i = 0;
        while (i < this.n) {
            double l = this.lineLength(this.points[i], this.points[i + 1]);
            double dx = (this.points[i + 1].x - this.points[i].x) / l;
            double dy = (this.points[i + 1].y - this.points[i].y) / l;
            this.unitVectors[i] = new Point2D.Double(dx, dy);
            this.lengths[i] = sum += l;
            ++i;
        }
    }

    private double lineLength(Point2D.Double P1, Point2D.Double P2) {
        return P2.distance(P1);
    }

    public Point2D.Double getP0() {
        return this.P0;
    }

    public Point2D.Double getP1() {
        return this.P1;
    }

    public Point2D.Double getP2() {
        return this.P2;
    }

    public Point2D.Double getP3() {
        return this.P3;
    }
}

