/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseList {
    private HashSet<ModeleBase> _bases = new HashSet();
    private String _caption;

    public BaseList(BaseList b) {
        this._caption = b._caption;
        this._bases = new HashSet<ModeleBase>(b._bases);
    }

    public BaseList(String caption) {
        this._caption = caption;
    }

    public BaseList(String caption, ModeleBase mb) {
        this(caption);
        this.addBase(mb);
    }

    public boolean contains(ModeleBase mb) {
        return this._bases.contains(mb);
    }

    public String getCaption() {
        return this._caption;
    }

    public void addBase(ModeleBase b) {
        this._bases.add(b);
    }

    public void removeBase(ModeleBase b) {
        this._bases.remove(b);
    }

    public void addBases(Collection<? extends ModeleBase> mbs) {
        this._bases.addAll(mbs);
    }

    public ArrayList<ModeleBase> getBases() {
        return new ArrayList<ModeleBase>(this._bases);
    }

    public void clear() {
        this._bases.clear();
    }

    public static Color getAverageColor(ArrayList<Color> cols) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (Color c : cols) {
            r += c.getRed();
            g += c.getGreen();
            b += c.getBlue();
        }
        if (cols.size() > 0) {
            r /= cols.size();
            g /= cols.size();
            b /= cols.size();
        }
        return new Color(r, g, b);
    }

    public Color getAverageOutlineColor() {
        ArrayList<Color> cols = new ArrayList<Color>();
        for (ModeleBase mb : this._bases) {
            cols.add(mb.getStyleBase().get_base_outline_color());
        }
        return BaseList.getAverageColor(cols);
    }

    public Color getAverageNameColor() {
        ArrayList<Color> cols = new ArrayList<Color>();
        for (ModeleBase mb : this._bases) {
            cols.add(mb.getStyleBase().get_base_name_color());
        }
        return BaseList.getAverageColor(cols);
    }

    public Color getAverageNumberColor() {
        ArrayList<Color> cols = new ArrayList<Color>();
        for (ModeleBase mb : this._bases) {
            cols.add(mb.getStyleBase().get_base_number_color());
        }
        return BaseList.getAverageColor(cols);
    }

    public Color getAverageInnerColor() {
        ArrayList<Color> cols = new ArrayList<Color>();
        for (ModeleBase mb : this._bases) {
            cols.add(mb.getStyleBase().get_base_inner_color());
        }
        return BaseList.getAverageColor(cols);
    }

    public String getNumbers() {
        String result = "";
        boolean first = true;
        for (ModeleBase mb : this._bases) {
            if (!first) {
                result = String.valueOf(result) + ",";
            } else {
                first = false;
            }
            result = String.valueOf(result) + mb.getBaseNumber();
        }
        result = String.valueOf(result);
        return result;
    }

    public String getContents() {
        String result = "";
        boolean first = true;
        for (ModeleBase mb : this._bases) {
            if (!first) {
                result = String.valueOf(result) + ",";
            } else {
                first = false;
            }
            result = String.valueOf(result) + mb.getContent();
        }
        result = String.valueOf(result);
        return result;
    }

    public ArrayList<Integer> getIndices() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (ModeleBase mb : this._bases) {
            indices.add(mb.getIndex());
        }
        return indices;
    }

    public BaseList retainAll(BaseList mb) {
        HashSet<ModeleBase> cp = new HashSet<ModeleBase>();
        cp.addAll(this._bases);
        cp.retainAll(mb._bases);
        BaseList result = new BaseList("TmpIntersection");
        result.addBases(cp);
        return result;
    }

    public BaseList removeAll(BaseList mb) {
        HashSet<ModeleBase> cp = new HashSet<ModeleBase>();
        cp.addAll(this._bases);
        cp.removeAll(mb._bases);
        BaseList result = new BaseList("TmpMinus");
        result.addBases(cp);
        return result;
    }

    public int size() {
        return this._bases.size();
    }
}

