/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.factories;

import fr.orsay.lri.varna.factories.RNAAlignment;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;

public class StockholmIO {
    public static RNAAlignment readAlignementFromFile(String path) throws IOException {
        return StockholmIO.readAlignement(new BufferedReader(new FileReader(path)));
    }

    public static RNAAlignment readAlignementFromURL(String url) throws UnsupportedEncodingException, IOException {
        URL urlAb = new URL(url);
        URLConnection urlConn = urlAb.openConnection();
        urlConn.setUseCaches(false);
        InputStreamReader r = new InputStreamReader(urlConn.getInputStream(), "UTF-8");
        return StockholmIO.readAlignement(new BufferedReader(r));
    }

    public static RNAAlignment readAlignement(BufferedReader r) throws IOException {
        LinkedHashMap<String, StringBuffer> rawSeqs = new LinkedHashMap<String, StringBuffer>();
        RNAAlignment result = new RNAAlignment();
        String line = r.readLine();
        String str = "";
        while (line != null) {
            String[] data;
            if (!line.startsWith("#")) {
                data = line.split("\\s+");
                if (data.length > 1) {
                    String seqName = data[0].trim();
                    String seq = data[1].trim();
                    if (!rawSeqs.containsKey(seqName)) {
                        rawSeqs.put(seqName, new StringBuffer());
                    }
                    StringBuffer val = (StringBuffer)rawSeqs.get(seqName);
                    val.append(seq);
                }
            } else if (line.startsWith("#")) {
                data = line.split("\\s+");
                if (line.startsWith("#=GC SS_cons")) {
                    str = String.valueOf(str) + data[2].trim();
                } else if (line.startsWith("#=GS") && data[2].trim().equals("AC")) {
                    result.setAccession(data[1].trim(), data[3].trim());
                }
            }
            line = r.readLine();
        }
        result.setSecStr(str);
        for (Map.Entry entry : rawSeqs.entrySet()) {
            String s = ((StringBuffer)entry.getValue()).toString();
            result.addSequence((String)entry.getKey(), s);
        }
        return result;
    }
}

