/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.factories;

import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAAlignment;
import fr.orsay.lri.varna.factories.StockholmIO;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.utils.RNAMLParser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAFactory {
    public static ArrayList<RNA> loadSecStrRNAML(Reader r) throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        ArrayList<RNA> result = new ArrayList<RNA>();
        try {
            SAXParserFactory saxFact = SAXParserFactory.newInstance();
            saxFact.setValidating(false);
            saxFact.setXIncludeAware(false);
            saxFact.setNamespaceAware(false);
            SAXParser sp = saxFact.newSAXParser();
            RNAMLParser RNAMLData = new RNAMLParser();
            sp.parse(new InputSource(r), (DefaultHandler)RNAMLData);
            for (RNAMLParser.RNATmp rnaTmp : RNAMLData.getMolecules()) {
                RNA current = new RNA();
                ArrayList<String> seq = rnaTmp.getSequence();
                int[] str = new int[seq.size()];
                int i = 0;
                while (i < str.length) {
                    str[i] = -1;
                    ++i;
                }
                current.setRNA(seq, str);
                Vector<RNAMLParser.BPTemp> allbpsTmp = rnaTmp.getStructure();
                ArrayList<ModeleBP> allbps = new ArrayList<ModeleBP>();
                int i2 = 0;
                while (i2 < allbpsTmp.size()) {
                    RNAMLParser.BPTemp bp = allbpsTmp.get(i2);
                    int bp5 = bp.pos5;
                    int bp3 = bp.pos3;
                    ModeleBase mb = current.getBaseAt(bp5);
                    ModeleBase part = current.getBaseAt(bp3);
                    ModeleBP newStyle = bp.createBPStyle(mb, part);
                    allbps.add(newStyle);
                    ++i2;
                }
                current.applyBPs(allbps);
                result.add(current);
            }
        }
        catch (IOException ioe) {
            throw new ExceptionLoadingFailed("Couldn't load file due to I/O or security policy issues.", "");
        }
        catch (Exception ge) {
            ge.printStackTrace();
        }
        return result;
    }

    public static int[] parseSecStr(String _secStr) throws ExceptionUnmatchedClosingParentheses {
        Hashtable stacks = new Hashtable();
        int[] result = new int[_secStr.length()];
        int i = 0;
        try {
            i = 0;
            while (i < _secStr.length()) {
                result[i] = -1;
                char c = _secStr.charAt(i);
                char c2 = Character.toUpperCase(c);
                if (!stacks.containsKey(Character.valueOf(c2))) {
                    stacks.put(Character.valueOf(c2), new Stack());
                }
                switch (c) {
                    case '(': 
                    case '<': 
                    case '[': 
                    case '{': {
                        ((Stack)stacks.get(Character.valueOf(c))).push(i);
                        break;
                    }
                    case '>': {
                        int j;
                        result[i] = j = ((Integer)((Stack)stacks.get(Character.valueOf('<'))).pop()).intValue();
                        result[j] = i;
                        break;
                    }
                    case '}': {
                        int j;
                        result[i] = j = ((Integer)((Stack)stacks.get(Character.valueOf('{'))).pop()).intValue();
                        result[j] = i;
                        break;
                    }
                    case ')': {
                        int j;
                        result[i] = j = ((Integer)((Stack)stacks.get(Character.valueOf('('))).pop()).intValue();
                        result[j] = i;
                        break;
                    }
                    case ']': {
                        int j;
                        result[i] = j = ((Integer)((Stack)stacks.get(Character.valueOf('['))).pop()).intValue();
                        result[j] = i;
                        break;
                    }
                    case '.': {
                        break;
                    }
                    default: {
                        int j;
                        if (Character.isLetter(c) && Character.isUpperCase(c)) {
                            ((Stack)stacks.get(Character.valueOf(c))).push(i);
                            break;
                        }
                        if (!Character.isLetter(c) || !Character.isLowerCase(c)) break;
                        result[i] = j = ((Integer)((Stack)stacks.get(Character.valueOf(Character.toUpperCase(c)))).pop()).intValue();
                        result[j] = i;
                    }
                }
                ++i;
            }
        }
        catch (EmptyStackException e) {
            throw new ExceptionUnmatchedClosingParentheses(i);
        }
        return result;
    }

    public static ArrayList<RNA> loadSecStrDBN(Reader r) throws ExceptionLoadingFailed, ExceptionPermissionDenied, ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        boolean loadOk = false;
        ArrayList<RNA> result = new ArrayList<RNA>();
        RNA current = new RNA();
        try {
            BufferedReader fr = new BufferedReader(r);
            String line = fr.readLine();
            String title = "";
            String seqTmp = "";
            String strTmp = "";
            while (line != null && strTmp.equals("")) {
                if (!(line = line.trim()).startsWith(">")) {
                    if (seqTmp.equals("")) {
                        seqTmp = line;
                    } else {
                        strTmp = line;
                    }
                } else {
                    title = line.substring(1).trim();
                }
                line = fr.readLine();
            }
            if (strTmp.length() != 0) {
                current.setRNA(seqTmp, strTmp);
                current.setName(title);
                loadOk = true;
            }
        }
        catch (IOException e) {
            throw new ExceptionLoadingFailed(e.getMessage(), "");
        }
        if (loadOk) {
            result.add(current);
        }
        return result;
    }

    public static ArrayList<RNA> loadSecStr(Reader r) throws ExceptionFileFormatOrSyntax {
        return RNAFactory.loadSecStr(new BufferedReader(r), RNAFileType.FILE_TYPE_UNKNOWN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<RNA> loadSecStr(BufferedReader r, RNAFileType fileType) throws ExceptionFileFormatOrSyntax {
        switch (fileType) {
            case FILE_TYPE_DBN: {
                try {
                    ArrayList<RNA> result = RNAFactory.loadSecStrDBN(r);
                    if (result.size() == 0) throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
                    return result;
                }
                catch (Exception result) {}
                throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
            }
            case FILE_TYPE_CT: {
                try {
                    ArrayList<RNA> result = RNAFactory.loadSecStrCT(r);
                    if (result.size() == 0) throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
                    return result;
                }
                catch (Exception result) {}
                throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
            }
            case FILE_TYPE_BPSEQ: {
                try {
                    ArrayList<RNA> result = RNAFactory.loadSecStrBPSEQ(r);
                    if (result.size() == 0) throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
                    return result;
                }
                catch (Exception result) {}
                throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
            }
            case FILE_TYPE_STOCKHOLM: {
                try {
                    ArrayList<RNA> result = RNAFactory.loadSecStrStockholm(r);
                    if (result.size() == 0) throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
                    return result;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
            }
            case FILE_TYPE_RNAML: {
                try {
                    ArrayList<RNA> result = RNAFactory.loadSecStrRNAML(r);
                    if (result.size() == 0) throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
                    return result;
                }
                catch (Exception result) {}
                throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
            }
            case FILE_TYPE_UNKNOWN: {
                try {
                    r.mark(1000000);
                    RNAFileType[] types = RNAFileType.values();
                    int i = 0;
                    while (i < types.length) {
                        r.reset();
                        RNAFileType t = types[i];
                        if (t != RNAFileType.FILE_TYPE_UNKNOWN) {
                            try {
                                ArrayList<RNA> result = RNAFactory.loadSecStr(r, t);
                                if (result.size() != 0) {
                                    return result;
                                }
                            }
                            catch (Exception e) {
                                System.err.println(e.toString());
                            }
                        }
                        ++i;
                    }
                    throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)fileType) + ".");
    }

    public static RNAFileType guessFileTypeFromExtension(String path) {
        if (path.toLowerCase().endsWith("ml")) {
            return RNAFileType.FILE_TYPE_RNAML;
        }
        if (path.toLowerCase().endsWith("dbn") || path.toLowerCase().endsWith("faa")) {
            return RNAFileType.FILE_TYPE_DBN;
        }
        if (path.toLowerCase().endsWith("ct")) {
            return RNAFileType.FILE_TYPE_CT;
        }
        if (path.toLowerCase().endsWith("bpseq")) {
            return RNAFileType.FILE_TYPE_BPSEQ;
        }
        if (path.toLowerCase().endsWith("stockholm") || path.toLowerCase().endsWith("stk")) {
            return RNAFileType.FILE_TYPE_STOCKHOLM;
        }
        return RNAFileType.FILE_TYPE_UNKNOWN;
    }

    public static ArrayList<RNA> loadSecStr(String path) throws ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax, ExceptionUnmatchedClosingParentheses, FileNotFoundException {
        FileReader fr = null;
        try {
            fr = new FileReader(path);
            RNAFileType type = RNAFactory.guessFileTypeFromExtension(path);
            return RNAFactory.loadSecStr(new BufferedReader(fr), type);
        }
        catch (ExceptionFileFormatOrSyntax e) {
            try {
                fr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            e.setPath(path);
            throw e;
        }
    }

    public static ArrayList<RNA> loadSecStrStockholm(BufferedReader r) throws IOException, ExceptionUnmatchedClosingParentheses {
        RNAAlignment a = StockholmIO.readAlignement(r);
        return a.getRNAs();
    }

    public static ArrayList<RNA> loadSecStrBPSEQ(Reader r) throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        boolean loadOk = false;
        ArrayList<RNA> result = new ArrayList<RNA>();
        RNA current = new RNA();
        try {
            BufferedReader fr = new BufferedReader(r);
            String line = fr.readLine();
            ArrayList<String> seqTmp = new ArrayList<String>();
            Hashtable strTmp = new Hashtable();
            int minIndex = -1;
            boolean noWarningYet = true;
            String title = "";
            String id = "";
            String filenameStr = "Filename:";
            String organismStr = "Organism:";
            String ANStr = "Accession Number:";
            while (line != null) {
                String tmp;
                int occur;
                String[] tokens = (line = line.trim()).split("\\s+");
                if (!(tokens.length < 3 || tokens[0].contains("#") || line.startsWith("Organism:") || line.startsWith("Citation") || line.startsWith("Filename:") || line.startsWith("Accession Number:"))) {
                    String base = tokens[1];
                    seqTmp.add(base);
                    int bpFrom = Integer.parseInt(tokens[0]);
                    if (minIndex < 0) {
                        minIndex = bpFrom;
                    }
                    if (seqTmp.size() < bpFrom - minIndex + 1) {
                        if (noWarningYet) {
                            noWarningYet = false;
                        }
                        while (seqTmp.size() < bpFrom - minIndex + 1) {
                            seqTmp.add("X");
                        }
                    }
                    int i = 2;
                    while (i < tokens.length) {
                        int bpTo = Integer.parseInt(tokens[i]);
                        if (bpTo != 0 || i != tokens.length - 1) {
                            if (!strTmp.containsKey(bpFrom)) {
                                strTmp.put(bpFrom, new Vector());
                            }
                            ((Vector)strTmp.get(bpFrom)).add(bpTo);
                        }
                        ++i;
                    }
                } else if (tokens[0].startsWith("#")) {
                    occur = line.indexOf("#");
                    tmp = line.substring(occur + 1);
                    title = String.valueOf(title) + tmp.trim() + " ";
                } else if (tokens[0].startsWith(filenameStr)) {
                    occur = line.indexOf(filenameStr);
                    tmp = line.substring(occur + filenameStr.length());
                    title = String.valueOf(title) + tmp.trim();
                } else if (tokens[0].startsWith(organismStr)) {
                    occur = line.indexOf(organismStr);
                    tmp = line.substring(occur + organismStr.length());
                    if (title.length() != 0) {
                        title = "/" + title;
                    }
                    title = String.valueOf(tmp.trim()) + title;
                } else if (line.contains(ANStr)) {
                    occur = line.indexOf(ANStr);
                    tmp = line.substring(occur + ANStr.length());
                    id = tmp.trim();
                }
                line = fr.readLine();
            }
            if (strTmp.size() != 0) {
                ArrayList<String> seq = seqTmp;
                int[] str = new int[seq.size()];
                int i = 0;
                while (i < seq.size()) {
                    str[i] = -1;
                    ++i;
                }
                current.setRNA(seq, str, minIndex);
                ArrayList<ModeleBP> allbps = new ArrayList<ModeleBP>();
                Iterator iterator = strTmp.keySet().iterator();
                while (iterator.hasNext()) {
                    int i2 = (Integer)iterator.next();
                    Iterator iterator2 = ((Vector)strTmp.get(i2)).iterator();
                    while (iterator2.hasNext()) {
                        int j = (Integer)iterator2.next();
                        ModeleBase mb = current.getBaseAt(i2 - minIndex);
                        ModeleBase part = current.getBaseAt(j - minIndex);
                        ModeleBP newStyle = new ModeleBP(mb, part);
                        allbps.add(newStyle);
                    }
                }
                current.applyBPs(allbps);
                current.setName(title);
                current.setID(id);
                loadOk = true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new ExceptionLoadingFailed(e.getMessage(), "");
        }
        if (loadOk) {
            result.add(current);
        }
        return result;
    }

    public static ArrayList<RNA> loadSecStrCT(Reader r) throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        boolean loadOk = false;
        ArrayList<RNA> result = new ArrayList<RNA>();
        RNA current = new RNA();
        try {
            BufferedReader fr = new BufferedReader(r);
            String line = fr.readLine();
            ArrayList<String> seq = new ArrayList<String>();
            Vector<Integer> strTmp = new Vector<Integer>();
            boolean noWarningYet = true;
            int minIndex = -1;
            String title = "";
            while (line != null) {
                String[] ntokens;
                String[] tokens = (line = line.trim()).split("\\s+");
                if (tokens.length >= 6) {
                    try {
                        int bpFrom = Integer.parseInt(tokens[0]);
                        int bpTo = Integer.parseInt(tokens[4]);
                        if (minIndex == -1) {
                            minIndex = bpFrom;
                        }
                        bpFrom -= minIndex;
                        bpTo = bpTo != 0 ? (bpTo -= minIndex) : -1;
                        String base = tokens[1];
                        Integer.parseInt(tokens[2]);
                        Integer.parseInt(tokens[3]);
                        Integer.parseInt(tokens[5]);
                        if (bpFrom != seq.size()) {
                            if (noWarningYet) {
                                noWarningYet = false;
                            }
                            while (bpFrom > seq.size()) {
                                seq.add("X");
                                strTmp.add(-1);
                            }
                        }
                        seq.add(base);
                        strTmp.add(bpTo);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((line.contains("ENERGY = ") || line.contains("dG = ")) && (ntokens = line.split("\\s+")).length >= 4) {
                    String energy = ntokens[3];
                    int i = 4;
                    while (i < ntokens.length) {
                        title = String.valueOf(title) + ntokens[i] + " ";
                        ++i;
                    }
                    title = String.valueOf(title) + "(E=" + energy + " kcal/mol)";
                }
                line = fr.readLine();
            }
            if (strTmp.size() != 0) {
                int[] str = new int[strTmp.size()];
                int i = 0;
                while (i < strTmp.size()) {
                    str[i] = (Integer)strTmp.elementAt(i);
                    ++i;
                }
                current.setRNA(seq, str, minIndex);
                current.setName(title);
                loadOk = true;
            }
        }
        catch (IOException e) {
            throw new ExceptionLoadingFailed(e.getMessage(), "");
        }
        catch (NumberFormatException e) {
            throw new ExceptionFileFormatOrSyntax(e.getMessage(), "");
        }
        if (loadOk) {
            result.add(current);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RNAFileType {
        FILE_TYPE_STOCKHOLM,
        FILE_TYPE_BPSEQ,
        FILE_TYPE_CT,
        FILE_TYPE_DBN,
        FILE_TYPE_RNAML,
        FILE_TYPE_UNKNOWN;

    }
}

