/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.factories;

import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAAlignment {
    private ArrayList<String> _lst = new ArrayList();
    private Hashtable<String, Integer> _index = new Hashtable();
    private Hashtable<String, String> _accession = new Hashtable();
    private String _secStr = "";

    public void addSequence(String id, String s) {
        if (!this._index.containsKey(id)) {
            this._index.put(id, this._lst.size());
            this._lst.add(s);
        }
        this._lst.set(this._index.get(id), s);
    }

    public void setSecStr(String s) {
        this._secStr = s;
    }

    public void setAccession(String id, String AC) {
        this._accession.put(id, AC);
    }

    public ArrayList<RNA> getRNAs() throws ExceptionUnmatchedClosingParentheses {
        ArrayList<RNA> result = new ArrayList<RNA>();
        int[] str = RNAFactory.parseSecStr(this._secStr);
        ArrayList<String> ids = new ArrayList<String>(this._index.keySet());
        Collections.sort(ids, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (String id : ids) {
            int n = this._index.get(id);
            String seq = this._lst.get(n);
            String nseq = "";
            String nstr = "";
            int i = 0;
            while (i < seq.length()) {
                char c = seq.charAt(i);
                int j = str[i];
                if (c != '.' && c != ':' && c != '-') {
                    char cp;
                    nseq = String.valueOf(nseq) + c;
                    nstr = j == -1 ? String.valueOf(nstr) + '.' : ((cp = seq.charAt(j)) == '.' || cp == ':' || cp == '-' ? String.valueOf(nstr) + '.' : String.valueOf(nstr) + this._secStr.charAt(i));
                }
                ++i;
            }
            RNA r = new RNA();
            try {
                r.setRNA(nseq, nstr);
                r.setName(id);
                if (this._accession.containsKey(id)) {
                    r.setID(this._accession.get(id));
                } else {
                    r.setID(id);
                }
                result.add(r);
            }
            catch (ExceptionFileFormatOrSyntax e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

