/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import java.awt.Color;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControleurScriptParser {
    private static String SCRIPT_ERROR_PREFIX = "Error";
    private static Hashtable<String, Function> _name2Fun = new Hashtable();
    private static Hashtable<Function, ArgumentType[]> _fun2Prot = new Hashtable();

    private static void initFunctions() {
        if (_name2Fun.size() > 0) {
            return;
        }
        String funtxt = "eraseseq";
        Function fun = Function.ERASE_SEQ;
        ArgumentType[] proto = new ArgumentType[]{};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "settitle";
        fun = Function.SET_TITLE;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "redraw";
        fun = Function.REDRAW;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setstruct";
        fun = Function.SET_STRUCT;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setseq";
        fun = Function.SET_SEQ;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setrna";
        fun = Function.SET_RNA;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE, ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setstructsmooth";
        fun = Function.SET_STRUCT_SMOOTH;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setrnasmooth";
        fun = Function.SET_RNA_SMOOTH;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE, ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setvalues";
        fun = Function.SET_VALUES;
        proto = new ArgumentType[]{ArgumentType.ARRAY_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setcolormap";
        fun = Function.SET_COLOR_MAP;
        proto = new ArgumentType[]{ArgumentType.STRING_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setcolormapminvalue";
        fun = Function.SET_COLOR_MAP_MIN;
        proto = new ArgumentType[]{ArgumentType.NUMBER_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setcolormapmaxvalue";
        fun = Function.SET_COLOR_MAP_MAX;
        proto = new ArgumentType[]{ArgumentType.NUMBER_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "setcustomcolormap";
        fun = Function.SET_CUSTOM_COLOR_MAP;
        proto = new ArgumentType[]{ArgumentType.ARRAY_TYPE};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
        funtxt = "toggleshowcolormap";
        fun = Function.TOGGLE_SHOW_COLOR_MAP;
        proto = new ArgumentType[]{};
        _name2Fun.put(funtxt, fun);
        _fun2Prot.put(fun, proto);
    }

    private static Function getFunction(String f) {
        String s = f.trim().toLowerCase();
        if (_name2Fun.containsKey(s)) {
            return _name2Fun.get(s);
        }
        return Function.UNKNOWN;
    }

    private static ArgumentType[] getPrototype(Function f) {
        if (_fun2Prot.containsKey((Object)f)) {
            return _fun2Prot.get((Object)f);
        }
        return new ArgumentType[0];
    }

    public static void executeScript(VARNAPanel vp, String cmdtxt) throws Exception {
        Vector<Command> cmds = ControleurScriptParser.parseScript(cmdtxt);
        int i = 0;
        while (i < cmds.size()) {
            Command cmd = cmds.get(i);
            switch (cmd._f) {
                case ERASE_SEQ: {
                    vp.eraseSequence();
                    break;
                }
                case SET_COLOR_MAP_MIN: {
                    vp.setColorMapMinValue(((NumberArgument)cmd._argv.get(0)).getNumber().doubleValue());
                    break;
                }
                case SET_COLOR_MAP_MAX: {
                    vp.setColorMapMaxValue(((NumberArgument)cmd._argv.get(0)).getNumber().doubleValue());
                    break;
                }
                case SET_COLOR_MAP: {
                    vp.setColorMap(ModeleColorMap.parseColorMap(cmd._argv.get(0).toString()));
                    break;
                }
                case SET_CUSTOM_COLOR_MAP: {
                    Argument a;
                    ModeleColorMap cm = new ModeleColorMap();
                    ArrayArgument arg = (ArrayArgument)cmd._argv.get(0);
                    int j = 0;
                    while (j < arg.getSize()) {
                        ArrayArgument aarg;
                        a = arg.getArgument(j);
                        if (a._t == ArgumentType.ARRAY_TYPE && (aarg = (ArrayArgument)a).getSize() == 2) {
                            Argument a1 = aarg.getArgument(0);
                            Argument a2 = aarg.getArgument(1);
                            if (a1.getType() == ArgumentType.NUMBER_TYPE && a2.getType() == ArgumentType.COLOR_TYPE) {
                                cm.addColor(((NumberArgument)a1).getNumber().doubleValue(), ((ColorArgument)a2).getColor());
                            }
                        }
                        ++j;
                    }
                    vp.setColorMap(cm);
                    break;
                }
                case SET_TITLE: {
                    vp.setTitle(cmd._argv.get(0).toString());
                    break;
                }
                case SET_STRUCT: {
                    String seq = vp.getRNA().getSeq();
                    String str = cmd._argv.get(0).toString();
                    vp.drawRNA(seq, str);
                    break;
                }
                case SET_SEQ: {
                    String seq = cmd._argv.get(0).toString();
                    vp.setSequence(seq);
                    break;
                }
                case SET_RNA: {
                    String seq = cmd._argv.get(0).toString();
                    String str = cmd._argv.get(1).toString();
                    vp.drawRNA(seq, str);
                    break;
                }
                case SET_STRUCT_SMOOTH: {
                    String seq = vp.getRNA().getSeq();
                    String str = cmd._argv.get(0).toString();
                    vp.drawRNAInterpolated(seq, str);
                    vp.repaint();
                    break;
                }
                case SET_RNA_SMOOTH: {
                    String seq = cmd._argv.get(0).toString();
                    String str = cmd._argv.get(1).toString();
                    vp.drawRNAInterpolated(seq, str);
                    vp.repaint();
                    break;
                }
                case SET_VALUES: {
                    Argument a;
                    ArrayArgument arg = (ArrayArgument)cmd._argv.get(0);
                    Double[] vals = new Double[arg.getSize()];
                    int j = 0;
                    while (j < vals.length) {
                        a = arg.getArgument(j);
                        if (a._t == ArgumentType.NUMBER_TYPE) {
                            NumberArgument narg = (NumberArgument)a;
                            vals[j] = narg.getNumber().doubleValue();
                        }
                        ++j;
                    }
                    vp.setColorMapValues(vals);
                    vp.repaint();
                    break;
                }
                case REDRAW: {
                    int mode = -1;
                    String modeStr = cmd._argv.get(0).toString().toLowerCase();
                    if (modeStr.equals("radiate")) {
                        mode = 2;
                    } else if (modeStr.equals("circular")) {
                        mode = 1;
                    } else if (modeStr.equals("naview")) {
                        mode = 3;
                    } else if (modeStr.equals("linear")) {
                        mode = 4;
                    }
                    if (mode == -1) break;
                    vp.drawRNA(vp.getRNA(), mode);
                    break;
                }
                case TOGGLE_SHOW_COLOR_MAP: {
                    vp.setColorMapVisible(!vp.getColorMapVisible());
                    break;
                }
                default: {
                    throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Method '" + (Object)((Object)cmd._f) + "' unimplemented.");
                }
            }
            vp.repaint();
            ++i;
        }
    }

    private static Color parseColor(String s) {
        Color result = null;
        try {
            result = Color.decode(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static Vector<Argument> parseArguments(StreamTokenizer st, boolean parType) throws Exception {
        Vector<Argument> result = new Vector<Argument>();
        while (st.ttype != 41 && parType || st.ttype != 93 && !parType) {
            st.nextToken();
            switch (st.ttype) {
                case -2: {
                    result.add(new NumberArgument(st.nval));
                    break;
                }
                case -3: {
                    Color c = ControleurScriptParser.parseColor(st.sval);
                    if (c == null) {
                        result.add(new StringArgument(st.sval));
                        break;
                    }
                    result.add(new ColorArgument(c));
                    break;
                }
                case 34: {
                    result.add(new StringArgument(st.sval));
                    break;
                }
                case 91: {
                    result.add(new ArrayArgument(ControleurScriptParser.parseArguments(st, false)));
                    break;
                }
                case 40: {
                    result.add(new ArrayArgument(ControleurScriptParser.parseArguments(st, true)));
                    break;
                }
                case 41: {
                    if (parType) {
                        return result;
                    }
                    throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Opening " + (parType ? "parenthesis" : "bracket") + " matched with a closing " + (!parType ? "parenthesis" : "bracket"));
                }
                case 93: {
                    if (!parType) {
                        return result;
                    }
                    throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Opening " + (parType ? "parenthesis" : "bracket") + " matched with a closing " + (!parType ? "parenthesis" : "bracket"));
                }
                case 44: {
                    break;
                }
                case -1: {
                    throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Unmatched opening " + (parType ? "parenthesis" : "bracket"));
                }
            }
        }
        return result;
    }

    private static Command parseCommand(String cmd) throws Exception {
        int cut = cmd.indexOf("(");
        if (cut == -1) {
            throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Syntax error");
        }
        String fun = cmd.substring(0, cut);
        Function f = ControleurScriptParser.getFunction(fun);
        if (f == Function.UNKNOWN) {
            throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Unknown function \"" + fun + "\"");
        }
        StreamTokenizer st = new StreamTokenizer(new StringReader(cmd.substring(cut + 1)));
        st.eolIsSignificant(false);
        st.parseNumbers();
        st.quoteChar(34);
        st.ordinaryChar(61);
        st.ordinaryChar(44);
        st.ordinaryChar(91);
        st.ordinaryChar(93);
        st.ordinaryChar(40);
        st.ordinaryChar(41);
        st.wordChars(35, 35);
        Vector<Argument> argv = ControleurScriptParser.parseArguments(st, true);
        ControleurScriptParser.checkArgs(f, argv);
        Command result = new Command(f, argv);
        return result;
    }

    private static boolean checkArgs(Function f, Vector<Argument> argv) throws Exception {
        ArgumentType[] argtypes = ControleurScriptParser.getPrototype(f);
        if (argtypes.length != argv.size()) {
            throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Wrong number of argument for function \"" + (Object)((Object)f) + "\".");
        }
        int i = 0;
        while (i < argtypes.length) {
            if (argtypes[i] != argv.get((int)i)._t) {
                throw new Exception(String.valueOf(SCRIPT_ERROR_PREFIX) + ": Bad type (" + (Object)((Object)argtypes[i]) + "!=" + (Object)((Object)argv.get((int)i)._t) + ") for argument #" + (i + 1) + " in function \"" + (Object)((Object)f) + "\".");
            }
            ++i;
        }
        return true;
    }

    private static Vector<Command> parseScript(String cmd) throws Exception {
        ControleurScriptParser.initFunctions();
        Vector<Command> cmds = new Vector<Command>();
        String[] data = cmd.split(";");
        int i = 0;
        while (i < data.length) {
            cmds.add(ControleurScriptParser.parseCommand(data[i].trim()));
            ++i;
        }
        return cmds;
    }

    private static abstract class Argument {
        ArgumentType _t;

        public Argument(ArgumentType t) {
            this._t = t;
        }

        public ArgumentType getType() {
            return this._t;
        }

        public abstract String toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ArgumentType {
        STRING_TYPE,
        NUMBER_TYPE,
        ARRAY_TYPE,
        COLOR_TYPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayArgument
    extends Argument {
        Vector<Argument> _val;

        public ArrayArgument(Vector<Argument> val) {
            super(ArgumentType.ARRAY_TYPE);
            this._val = val;
        }

        public int getSize() {
            return this._val.size();
        }

        public Argument getArgument(int i) {
            return this._val.get(i);
        }

        @Override
        public String toString() {
            return this._val.toString();
        }
    }

    private static class ColorArgument
    extends Argument {
        Color _val;

        public ColorArgument(Color val) {
            super(ArgumentType.COLOR_TYPE);
            this._val = val;
        }

        public Color getColor() {
            return this._val;
        }

        public String toString() {
            return this._val.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Command {
        Function _f;
        Vector<Argument> _argv;

        public Command(Function f, Vector<Argument> argv) {
            this._f = f;
            this._argv = argv;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Function {
        ERASE_SEQ,
        SET_COLOR_MAP_MIN,
        SET_COLOR_MAP_MAX,
        SET_COLOR_MAP,
        SET_CUSTOM_COLOR_MAP,
        SET_SEQ,
        SET_STRUCT,
        SET_STRUCT_SMOOTH,
        SET_TITLE,
        SET_RNA,
        SET_RNA_SMOOTH,
        SET_VALUES,
        TOGGLE_SHOW_COLOR_MAP,
        REDRAW,
        UNKNOWN;

    }

    private static class NumberArgument
    extends Argument {
        Number _val;

        public NumberArgument(Number val) {
            super(ArgumentType.NUMBER_TYPE);
            this._val = val;
        }

        public Number getNumber() {
            return this._val;
        }

        public String toString() {
            return this._val.toString();
        }
    }

    private static class StringArgument
    extends Argument {
        String _val;

        public StringArgument(String val) {
            super(ArgumentType.STRING_TYPE);
            this._val = val;
        }

        public String toString() {
            return this._val.toString();
        }
    }
}

