/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.MappingException;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControleurInterpolator
extends Thread {
    VARNAPanel _vpn;
    private int _numSteps = 25;
    private long _timeDelay = 15L;
    private boolean _running = false;
    Targets _d = new Targets();

    public ControleurInterpolator(VARNAPanel vpn) {
        this._vpn = vpn;
    }

    public synchronized void addTarget(RNA target, Mapping mapping) {
        this.addTarget(target, null, mapping);
    }

    public synchronized void addTarget(RNA target, VARNAConfig conf, Mapping mapping) {
        this._d.add(new TargetsHolder(target, conf, mapping));
    }

    public synchronized void addTarget(RNA target) {
        this.addTarget(target, null, Mapping.DefaultOutermostMapping(this._vpn.getRNA().get_listeBases().size(), target.get_listeBases().size()));
    }

    public boolean isInterpolationInProgress() {
        return this._running;
    }

    private Point2D.Double computeDestination(Point2D pli, Point2D pri, Point2D pi, int i, int n, Point2D plf, Point2D prf) {
        Point2D.Double plm = new Point2D.Double((pli.getX() + plf.getX()) / 2.0, (pli.getY() + plf.getY()) / 2.0);
        Point2D.Double prm = new Point2D.Double((pri.getX() + prf.getX()) / 2.0, (pri.getY() + prf.getY()) / 2.0);
        Point2D.Double pm = new Point2D.Double(((double)(n - i) * plm.getX() + (double)i * prm.getX()) / (double)n, ((double)(n - i) * plm.getY() + (double)i * prm.getY()) / (double)n);
        Point2D.Double v = new Point2D.Double(pm.getX() - pi.getX(), pm.getY() - pi.getY());
        Point2D.Double pf = new Point2D.Double(pi.getX() + 2.0 * v.getX(), pi.getY() + 2.0 * v.getY());
        return pf;
    }

    private Vector<Vector<Integer>> clusterIndices(int numIndices, int[] mappedIndices) throws MappingException {
        int[] indices = new int[numIndices];
        int i = 0;
        while (i < numIndices) {
            indices[i] = i;
            ++i;
        }
        return this.clusterIndices(indices, mappedIndices);
    }

    private Vector<Vector<Integer>> clusterIndices(int[] indices, int[] mappedIndices) throws MappingException {
        int k;
        if (mappedIndices.length == 0 || indices.length == 0) {
            throw new MappingException("Mapping Error: Cannot cluster indices in an empty mapping");
        }
        Vector<Vector<Integer>> res = new Vector<Vector<Integer>>();
        Arrays.sort(indices);
        Arrays.sort(mappedIndices);
        int j = 0;
        Vector<Integer> tmp = new Vector<Integer>();
        int i = 0;
        while (i < indices.length && j < mappedIndices.length) {
            if (indices[i] == mappedIndices[j]) {
                res.add(tmp);
                tmp = new Vector();
                tmp.add(indices[i]);
                res.add(tmp);
                tmp = new Vector();
                ++j;
            } else {
                tmp.add(indices[i]);
            }
            ++i;
        }
        i = k = i;
        while (i < indices.length) {
            tmp.add(indices[i]);
            ++i;
        }
        res.add(tmp);
        return res;
    }

    @Override
    public void run() {
        while (true) {
            TargetsHolder d = this._d.get();
            this._running = true;
            try {
                this.nextTarget(d.target, d.conf, d.mapping);
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
            this._running = false;
        }
    }

    private static Point2D.Double computeCentroid(ArrayList<ModeleBase> rnaBases, int[] indexes) {
        double centroidX = 0.0;
        double centroidY = 0.0;
        int i = 0;
        while (i < indexes.length) {
            int index = indexes[i];
            Point2D.Double coords = rnaBases.get(index).getCoords();
            centroidX += ((Point2D)coords).getX();
            centroidY += ((Point2D)coords).getY();
            ++i;
        }
        return new Point2D.Double(centroidX /= (double)indexes.length, centroidY /= (double)indexes.length);
    }

    private static double minimizeRotateRMSD(double[] X1, double[] Y1, double[] X2, double[] Y2) {
        MinimizeRMSD minimizer = new MinimizeRMSD(X1, Y1, X2, Y2);
        return minimizer.computeOptimalTheta();
    }

    public static void moveNearOtherRNA(RNA rna1, RNA rna2, Mapping mapping) {
        int[] rna1MappedElems = mapping.getSourceElems();
        int[] rna2MappedElems = mapping.getTargetElems();
        ArrayList<ModeleBase> rna1Bases = rna1.get_listeBases();
        ArrayList<ModeleBase> rna2Bases = rna2.get_listeBases();
        int n = rna1MappedElems.length;
        if (n < 2) {
            return;
        }
        Point2D.Double rna1MappedElemsCentroid = ControleurInterpolator.computeCentroid(rna1Bases, rna1MappedElems);
        Point2D.Double rna2MappedElemsCentroid = ControleurInterpolator.computeCentroid(rna2Bases, rna2MappedElems);
        double[] X1 = new double[rna1MappedElems.length];
        double[] Y1 = new double[rna1MappedElems.length];
        double[] X2 = new double[rna2MappedElems.length];
        double[] Y2 = new double[rna2MappedElems.length];
        int i = 0;
        while (i < rna1MappedElems.length) {
            int base1Index = rna1MappedElems[i];
            Point2D.Double coords1 = rna1Bases.get(base1Index).getCoords();
            X1[i] = coords1.x - rna1MappedElemsCentroid.x;
            Y1[i] = coords1.y - rna1MappedElemsCentroid.y;
            Point2D.Double coords2 = rna2Bases.get(mapping.getPartner(base1Index)).getCoords();
            X2[i] = coords2.x - rna2MappedElemsCentroid.x;
            Y2[i] = coords2.y - rna2MappedElemsCentroid.y;
            ++i;
        }
        double theta = ControleurInterpolator.minimizeRotateRMSD(X1, Y1, X2, Y2);
        rna2.globalRotation(theta * 180.0 / Math.PI);
    }

    public void nextTarget(RNA _target, VARNAConfig _conf, Mapping _mapping) {
        this.nextTarget(_target, _conf, _mapping, false);
    }

    public void nextTarget(RNA _target, VARNAConfig _conf, Mapping _mapping, boolean moveTarget) {
        try {
            RNA source;
            RNA current = source = this._vpn.getRNA();
            if (moveTarget) {
                ControleurInterpolator.moveNearOtherRNA(source, _target, _mapping);
            }
            if (source.getSize() != 0 && _target.getSize() != 0) {
                int index;
                int j;
                Vector v;
                int matchedNeighborRight;
                Point2D.Double dest;
                Point2D.Double tmp;
                ArrayList<ModeleBase> currBases = current.get_listeBases();
                ArrayList<ModeleBase> destBases = _target.get_listeBases();
                Vector<Object> intArrSource = new Vector();
                Vector<Object> intArrTarget = new Vector();
                intArrSource = this.clusterIndices(currBases.size(), _mapping.getSourceElems());
                intArrTarget = this.clusterIndices(destBases.size(), _mapping.getTargetElems());
                Point2D.Double[] initPosSource = new Point2D.Double[currBases.size()];
                Point2D.Double[] finalPosTarget = new Point2D.Double[destBases.size()];
                int i = 0;
                while (i < currBases.size()) {
                    tmp = currBases.get(i).getCoords();
                    initPosSource[i] = new Point2D.Double(((Point2D)tmp).getX(), ((Point2D)tmp).getY());
                    ++i;
                }
                i = 0;
                while (i < destBases.size()) {
                    tmp = destBases.get(i).getCoords();
                    finalPosTarget[i] = new Point2D.Double(((Point2D)tmp).getX(), ((Point2D)tmp).getY());
                    ++i;
                }
                Point2D.Double[] finalPosSource = new Point2D.Double[initPosSource.length];
                Point2D.Double[] initPosTarget = new Point2D.Double[finalPosTarget.length];
                int i2 = 0;
                while (i2 < finalPosSource.length) {
                    if (_mapping.getPartner(i2) != -1) {
                        dest = finalPosTarget[_mapping.getPartner(i2)];
                        finalPosSource[i2] = new Point2D.Double(((Point2D)dest).getX(), ((Point2D)dest).getY());
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < intArrSource.size()) {
                    int matchedNeighborLeft;
                    if (i2 == 0) {
                        matchedNeighborLeft = (Integer)((Vector)intArrSource.get(1)).get(0);
                        matchedNeighborRight = (Integer)((Vector)intArrSource.get(1)).get(0);
                    } else if (i2 == intArrSource.size() - 1) {
                        matchedNeighborLeft = (Integer)((Vector)intArrSource.get(intArrSource.size() - 2)).get(0);
                        matchedNeighborRight = (Integer)((Vector)intArrSource.get(intArrSource.size() - 2)).get(0);
                    } else {
                        matchedNeighborLeft = (Integer)((Vector)intArrSource.get(i2 - 1)).get(0);
                        matchedNeighborRight = (Integer)((Vector)intArrSource.get(i2 + 1)).get(0);
                    }
                    v = (Vector)intArrSource.get(i2);
                    j = 0;
                    while (j < v.size()) {
                        index = (Integer)v.get(j);
                        finalPosSource[index] = this.computeDestination(initPosSource[matchedNeighborLeft], initPosSource[matchedNeighborRight], initPosSource[index], j + 1, v.size() + 1, finalPosSource[matchedNeighborLeft], finalPosSource[matchedNeighborRight]);
                        ++j;
                    }
                    i2 += 2;
                }
                i2 = 0;
                while (i2 < initPosTarget.length) {
                    if (_mapping.getAncestor(i2) != -1) {
                        dest = initPosSource[_mapping.getAncestor(i2)];
                        initPosTarget[i2] = new Point2D.Double(((Point2D)dest).getX(), ((Point2D)dest).getY());
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < intArrTarget.size()) {
                    int matchedNeighborLeft;
                    if (i2 == 0) {
                        matchedNeighborLeft = (Integer)((Vector)intArrTarget.get(1)).get(0);
                        matchedNeighborRight = (Integer)((Vector)intArrTarget.get(1)).get(0);
                    } else if (i2 == intArrTarget.size() - 1) {
                        matchedNeighborLeft = (Integer)((Vector)intArrTarget.get(intArrTarget.size() - 2)).get(0);
                        matchedNeighborRight = (Integer)((Vector)intArrTarget.get(intArrTarget.size() - 2)).get(0);
                    } else {
                        matchedNeighborLeft = (Integer)((Vector)intArrTarget.get(i2 - 1)).get(0);
                        matchedNeighborRight = (Integer)((Vector)intArrTarget.get(i2 + 1)).get(0);
                    }
                    v = (Vector)intArrTarget.get(i2);
                    j = 0;
                    while (j < v.size()) {
                        index = (Integer)v.get(j);
                        initPosTarget[index] = this.computeDestination(finalPosTarget[matchedNeighborLeft], finalPosTarget[matchedNeighborRight], finalPosTarget[index], j + 1, v.size() + 1, initPosTarget[matchedNeighborLeft], initPosTarget[matchedNeighborRight]);
                        ++j;
                    }
                    i2 += 2;
                }
                boolean firstHalf = true;
                int i3 = 0;
                while (i3 < this._numSteps) {
                    int j2;
                    if (i3 == this._numSteps / 2) {
                        this._vpn.showRNA(_target);
                        current = _target;
                        currBases = current.get_listeBases();
                        firstHalf = false;
                        if (_conf != null) {
                            this._vpn.setConfig(_conf);
                        }
                        j2 = 0;
                        while (j2 < initPosSource.length) {
                            source.setCoord(j2, initPosSource[j2]);
                            ++j2;
                        }
                    }
                    j2 = 0;
                    while (j2 < currBases.size()) {
                        Point2D.Double mnc;
                        Point2D.Double mpc;
                        ModeleBase m = currBases.get(j2);
                        if (firstHalf) {
                            mpc = initPosSource[j2];
                            mnc = finalPosSource[j2];
                        } else {
                            mpc = initPosTarget[j2];
                            mnc = finalPosTarget[j2];
                        }
                        m.setCoords(new Point2D.Double(((double)(this._numSteps - 1 - i3) * ((Point2D)mpc).getX() + (double)i3 * ((Point2D)mnc).getX()) / (double)(this._numSteps - 1), ((double)(this._numSteps - 1 - i3) * ((Point2D)mpc).getY() + (double)i3 * ((Point2D)mnc).getY()) / (double)(this._numSteps - 1)));
                        ++j2;
                    }
                    this._vpn.repaint();
                    ControleurInterpolator.sleep(this._timeDelay);
                    ++i3;
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (MappingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._vpn.showRNA(_target);
        this._vpn.repaint();
    }

    private static class MinimizeRMSD {
        private double[] X1;
        private double[] X2;
        private double[] Y1;
        private double[] Y2;

        public MinimizeRMSD(double[] X1, double[] Y1, double[] X2, double[] Y2) {
            this.X1 = X1;
            this.X2 = X2;
            this.Y1 = Y1;
            this.Y2 = Y2;
        }

        private double f(double theta) {
            double cos_theta = Math.cos(theta);
            double sin_theta = Math.sin(theta);
            int n = this.X1.length;
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                double dsx = this.X2[i] * cos_theta - this.Y2[i] * sin_theta - this.X1[i];
                double dsy = this.X2[i] * sin_theta + this.Y2[i] * cos_theta - this.Y1[i];
                sum = sum + dsx * dsx + dsy * dsy;
                ++i;
            }
            return sum;
        }

        private double fprime(double theta) {
            double cos_theta = Math.cos(theta);
            double sin_theta = Math.sin(theta);
            int n = this.X1.length;
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                sum = sum + (this.X1[i] * this.X2[i] + this.Y1[i] * this.Y2[i]) * sin_theta + (this.X1[i] * this.Y2[i] - this.X2[i] * this.Y1[i]) * cos_theta;
                ++i;
            }
            return sum;
        }

        private double fsecond(double theta) {
            double cos_theta = Math.cos(theta);
            double sin_theta = Math.sin(theta);
            int n = this.X1.length;
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                sum = sum + (this.X1[i] * this.X2[i] + this.Y1[i] * this.Y2[i]) * cos_theta + (this.X2[i] * this.Y1[i] - this.X1[i] * this.Y2[i]) * sin_theta;
                ++i;
            }
            return sum;
        }

        public double computeOptimalTheta() {
            double result;
            double epsilon = 1.0E-5;
            double x_n = 0.0;
            int numsteps = 0;
            int maxnumsteps = 100;
            while (true) {
                double x_n_plus_1;
                ++numsteps;
                double d = this.fsecond(x_n);
                if (d == 0.0) {
                    x_n_plus_1 = x_n + 1.0E-5 * (Math.random() - 0.5);
                } else {
                    x_n_plus_1 = x_n - this.fprime(x_n) / this.fsecond(x_n);
                    if (Math.abs(x_n_plus_1 - x_n) < 1.0E-5) {
                        result = x_n_plus_1;
                        break;
                    }
                }
                if (numsteps >= 100) {
                    result = x_n_plus_1;
                    break;
                }
                x_n = x_n_plus_1;
            }
            if (this.f(result + Math.PI) < this.f(result)) {
                result += Math.PI;
            }
            return result;
        }
    }

    private class Targets {
        LinkedList<TargetsHolder> _d = new LinkedList();

        private Targets() {
        }

        public synchronized void add(TargetsHolder d) {
            this._d.addLast(d);
            this.notify();
        }

        public synchronized TargetsHolder get() {
            while (this._d.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            TargetsHolder x = this._d.getFirst();
            this._d.removeFirst();
            return x;
        }
    }

    private class TargetsHolder {
        public RNA target;
        public VARNAConfig conf;
        public Mapping mapping;

        public TargetsHolder(RNA t, VARNAConfig c, Mapping m) {
            this.target = t;
            this.conf = c;
            this.mapping = m;
        }
    }
}

