/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.MouseControler;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEditorPanelUI;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.exceptions.ExceptionXmlLoading;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePanel
extends JPanel {
    private static final long serialVersionUID = 3162771335587335679L;
    private ArrayList<GraphicalTemplateElement> _RNAComponents;
    private ArrayList<Connection> _RNAConnections;
    private Hashtable<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Connection> _helixToConnection;
    private TemplateEditorPanelUI _ui;
    private RNATemplate _template;
    private static Color[] BackgroundColors = new Color[]{Color.blue, Color.red, Color.cyan, Color.green, Color.lightGray, Color.magenta, Color.PINK};
    private int _nextBackgroundColor = 0;
    private GraphicalTemplateElement _selected = null;
    GraphicalTemplateElement.RelativePosition _relpos = GraphicalTemplateElement.RelativePosition.RP_OUTER;
    Point2D.Double _mousePos = new Point2D.Double();
    private static Color[] _colors = new Color[]{Color.gray, Color.pink, Color.cyan, Color.RED, Color.green, Color.orange};
    private static final Color CYCLE_COLOR = Color.red;
    private static final Color NON_EXISTANT_COLOR = Color.gray.brighter();
    private static final Color CONTROL_COLOR = Color.gray.darker();
    private static final Color BACKGROUND_COLOR = Color.white;
    private Stroke _solidStroke;
    private Stroke _dashedStroke;

    public Color nextBackgroundColor() {
        Color c = BackgroundColors[this._nextBackgroundColor++];
        this._nextBackgroundColor %= BackgroundColors.length;
        return new Color(c.getRed(), c.getBlue(), c.getGreen(), 50);
    }

    public TemplatePanel() {
        this.init();
    }

    public RNATemplate getTemplate() {
        return this._template;
    }

    List<GraphicalTemplateElement> getRNAComponents() {
        return this._RNAComponents;
    }

    private void init() {
        this._ui = new TemplateEditorPanelUI(this);
        this._RNAComponents = new ArrayList();
        this._RNAConnections = new ArrayList();
        this._helixToConnection = new Hashtable();
        this._template = new RNATemplate();
        this.setBackground(Color.WHITE);
        MouseControler mc = new MouseControler(this, this._ui);
        this.addMouseListener(mc);
        this.addMouseMotionListener(mc);
        this._solidStroke = new BasicStroke(1.5f, 1, 1, 3.0f);
        float[] dash = new float[]{5.0f, 5.0f};
        this._dashedStroke = new BasicStroke(1.5f, 1, 1, 3.0f, dash, 0.0f);
    }

    public void addUndoableEditListener(UndoManager manager) {
        this._ui.addUndoableEditListener(manager);
    }

    public TemplateEditorPanelUI getTemplateUI() {
        return this._ui;
    }

    public void flip(Helix h) {
        h.toggleFlipped();
    }

    public void addElement(GraphicalTemplateElement h) {
        this._RNAComponents.add(h);
    }

    public void removeElement(GraphicalTemplateElement h) {
        this._RNAComponents.remove(h);
        try {
            this._template.removeElement(h.getTemplateElement());
        }
        catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
            // empty catch block
        }
    }

    public GraphicalTemplateElement getSelected() {
        return this._selected;
    }

    public void setSelected(GraphicalTemplateElement sel) {
        this._selected = sel;
    }

    public void setSelectedEdge(GraphicalTemplateElement.RelativePosition rel) {
        this._relpos = rel;
    }

    public void unselectEdge(GraphicalTemplateElement.RelativePosition rel) {
        this._relpos = rel;
    }

    public void setPointerPos(Point2D.Double p) {
        this._mousePos = p;
    }

    public void Unselect() {
        this._selected = null;
    }

    public GraphicalTemplateElement getElement(RNATemplate.RNATemplateElement t) {
        for (GraphicalTemplateElement t2 : this._RNAComponents) {
            if (t != t2.getTemplateElement()) continue;
            return t2;
        }
        return null;
    }

    public GraphicalTemplateElement getElementAt(int x, int y) {
        return this.getElementAt(x, y, null);
    }

    public GraphicalTemplateElement getElementAt(int x, int y, GraphicalTemplateElement excluded) {
        GraphicalTemplateElement h = null;
        int i = 0;
        while (i < this._RNAComponents.size()) {
            GraphicalTemplateElement h2 = this._RNAComponents.get(i);
            if ((h2.getRelativePosition(x, y) == GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3 || h2.getRelativePosition(x, y) == GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5 || h2.getRelativePosition(x, y) == GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3 || h2.getRelativePosition(x, y) == GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5) && excluded != h2) {
                h = h2;
            }
            ++i;
        }
        if (h == null) {
            h = this.getElementCloseTo(x, y, excluded);
        }
        return h;
    }

    public GraphicalTemplateElement getElementCloseTo(int x, int y) {
        return this.getElementCloseTo(x, y, null);
    }

    public GraphicalTemplateElement getElementCloseTo(int x, int y, GraphicalTemplateElement excluded) {
        GraphicalTemplateElement h = null;
        int i = 0;
        while (i < this._RNAComponents.size()) {
            GraphicalTemplateElement h2 = this._RNAComponents.get(i);
            if (h2.getRelativePosition(x, y) != GraphicalTemplateElement.RelativePosition.RP_OUTER && excluded != h2) {
                h = h2;
            }
            ++i;
        }
        return h;
    }

    public void addConnection(Connection c) {
        this._RNAConnections.add(c);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h1, c._edge1), c);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h2, c._edge2), c);
        try {
            c._h1.attach(c._h2, c._edge1, c._edge2);
            c._h2.attach(c._h1, c._edge2, c._edge1);
        }
        catch (ExceptionInvalidRNATemplate e) {
            System.out.println(e.toString());
        }
    }

    public Connection addConnection(GraphicalTemplateElement h1, GraphicalTemplateElement.RelativePosition edge1, GraphicalTemplateElement h2, GraphicalTemplateElement.RelativePosition edge2) {
        if (h1 != h2 && this.getPartner(h1, edge1) == null && this.getPartner(h2, edge2) == null) {
            Connection c = new Connection(h1, edge1, h2, edge2);
            this.addConnection(c);
            return c;
        }
        return null;
    }

    public void addGraphicalConnection(GraphicalTemplateElement h1, GraphicalTemplateElement.RelativePosition edge1, GraphicalTemplateElement h2, GraphicalTemplateElement.RelativePosition edge2) {
        Connection c = new Connection(h1, edge1, h2, edge2);
        this._RNAConnections.add(c);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h1, c._edge1), c);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h2, c._edge2), c);
        c._h1.graphicalAttach(c._h2, c._edge1, c._edge2);
        c._h2.graphicalAttach(c._h1, c._edge2, c._edge1);
    }

    public void removeConnection(Connection c) {
        this._RNAConnections.remove(c);
        this._helixToConnection.remove(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h1, c._edge1));
        this._helixToConnection.remove(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h2, c._edge2));
        System.out.println("[A]" + c);
        c._h1.detach(c._edge1);
    }

    public boolean isInCycle(GraphicalTemplateElement el, GraphicalTemplateElement.RelativePosition edge) {
        Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>> p = new Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>>();
        Hashtable<Couple, Integer> alreadySeen = new Hashtable<Couple, Integer>();
        p.add(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(el, edge));
        while (!p.empty()) {
            Couple c2 = (Couple)p.pop();
            if (alreadySeen.containsKey(c2)) {
                return true;
            }
            alreadySeen.put(c2, new Integer(1));
            GraphicalTemplateElement.RelativePosition next = ((GraphicalTemplateElement)c2.first).getConnectedEdge((GraphicalTemplateElement.RelativePosition)((Object)c2.second));
            Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> otherEnd = new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>((GraphicalTemplateElement)c2.first, next);
            if (!alreadySeen.containsKey(otherEnd)) {
                p.push(otherEnd);
                continue;
            }
            Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> child = this.getPartner((GraphicalTemplateElement)c2.first, (GraphicalTemplateElement.RelativePosition)((Object)c2.second));
            if (child == null) continue;
            p.push(child);
        }
        return false;
    }

    public static Color getIndexedColor(int n) {
        return _colors[n % _colors.length];
    }

    public HashMap<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Integer> buildConnectedComponents() {
        HashMap<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Integer> alreadySeen = new HashMap<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Integer>();
        int numConnectedComponents = 0;
        for (GraphicalTemplateElement el : this._RNAComponents) {
            for (GraphicalTemplateElement.RelativePosition edge : el.getConnectedEdges()) {
                Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> c = new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(el, edge);
                if (alreadySeen.containsKey(c)) continue;
                Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>> p = new Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>>();
                p.add(c);
                p.add(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(el, el.getConnectedEdge(edge)));
                while (!p.empty()) {
                    Couple c2 = (Couple)p.pop();
                    if (alreadySeen.containsKey(c2)) continue;
                    ((GraphicalTemplateElement)c2.first).setMainColor((GraphicalTemplateElement.RelativePosition)((Object)c2.second), TemplatePanel.getIndexedColor(numConnectedComponents));
                    alreadySeen.put(c2, new Integer(numConnectedComponents));
                    GraphicalTemplateElement.RelativePosition next = ((GraphicalTemplateElement)c2.first).getConnectedEdge((GraphicalTemplateElement.RelativePosition)((Object)c2.second));
                    Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> otherEnd = new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>((GraphicalTemplateElement)c2.first, next);
                    p.push(otherEnd);
                    Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> child = this.getPartner((GraphicalTemplateElement)c2.first, (GraphicalTemplateElement.RelativePosition)((Object)c2.second));
                    if (child == null) continue;
                    p.push(child);
                }
                ++numConnectedComponents;
            }
        }
        return alreadySeen;
    }

    public boolean isInCycle(Connection c) {
        return this.isInCycle(c._h1, c._edge1);
    }

    public Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> getPartner(GraphicalTemplateElement h, GraphicalTemplateElement.RelativePosition edge) {
        Connection c = this.getConnection(h, edge);
        if (c != null) {
            if (c._h1 == h && c._edge1 == edge) {
                return new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h2, c._edge2);
            }
            return new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(c._h1, c._edge1);
        }
        return null;
    }

    public Connection getConnection(GraphicalTemplateElement h, GraphicalTemplateElement.RelativePosition edge) {
        Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> target = new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(h, edge);
        if (this._helixToConnection.containsKey(target)) {
            return this._helixToConnection.get(target);
        }
        return null;
    }

    private boolean isConnected(Helix h, GraphicalTemplateElement.RelativePosition edge) {
        Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> partner = this.getPartner(h, edge);
        return partner != null;
    }

    private void drawConnections(Graphics2D g2d, Connection c) {
        GraphicalTemplateElement h1 = c._h1;
        GraphicalTemplateElement.RelativePosition edge1 = c._edge1;
        Point2D.Double p1 = h1.getEdgePosition(edge1);
        GraphicalTemplateElement h2 = c._h2;
        GraphicalTemplateElement.RelativePosition edge2 = c._edge2;
        Point2D.Double p2 = h2.getEdgePosition(edge2);
        if (this.isInCycle(c)) {
            g2d.setColor(CYCLE_COLOR);
        } else {
            g2d.setColor(GraphicalTemplateElement.BACKBONE_COLOR);
        }
        g2d.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.rescale();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.removeAll();
        super.paintComponent(g2d);
        this.buildConnectedComponents();
        if (this._selected != null && this._relpos != GraphicalTemplateElement.RelativePosition.RP_OUTER) {
            Point2D.Double p = this._selected.getEdgePosition(this._relpos);
            g2d.setStroke(this._solidStroke);
            g2d.drawLine((int)this._mousePos.x, (int)this._mousePos.y, (int)p.x, (int)p.y);
        }
        int i = 0;
        while (i < this._RNAConnections.size()) {
            Connection c = this._RNAConnections.get(i);
            this.drawConnections(g2d, c);
            ++i;
        }
        i = 0;
        while (i < this._RNAComponents.size()) {
            GraphicalTemplateElement elem = this._RNAComponents.get(i);
            g2d.setColor(elem.getDominantColor());
            g2d.fill(elem.getArea());
            if (this._selected == elem) {
                elem.draw(g2d, true);
            } else {
                elem.draw(g2d, false);
            }
            ++i;
        }
    }

    private void rescale() {
        GraphicalTemplateElement h;
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        int i = 0;
        while (i < this._RNAComponents.size()) {
            h = this._RNAComponents.get(i);
            Polygon p = h.getBoundingPolygon();
            Rectangle r = p.getBounds();
            minX = Math.min(minX, r.x);
            maxX = Math.max(maxX, r.x + r.width);
            minY = Math.min(minY, r.y);
            maxY = Math.max(maxY, r.y + r.height);
            ++i;
        }
        if (minX < 0 || minY < 0) {
            i = 0;
            while (i < this._RNAComponents.size()) {
                h = this._RNAComponents.get(i);
                h.translate(minX < 0 ? -minX : 0, minY < 0 ? -minY : 0);
                ++i;
            }
        }
        this.setPreferredSize(new Dimension(Math.max(maxX - minX, 10) + 100, Math.max(maxY - minY, 10) + 100));
        this.revalidate();
    }

    public void loadTemplate(RNATemplate template) {
        this._template = template;
        this._RNAComponents.clear();
        this._RNAConnections.clear();
        this._helixToConnection.clear();
        HashMap<RNATemplate.RNATemplateElement, GraphicalTemplateElement> map = new HashMap<RNATemplate.RNATemplateElement, GraphicalTemplateElement>();
        Iterator<Object> iter = template.classicIterator();
        while (iter.hasNext()) {
            RNATemplate.RNATemplateElement templateElement = iter.next();
            if (templateElement instanceof RNATemplate.RNATemplateHelix) {
                RNATemplate.RNATemplateHelix templateHelix = (RNATemplate.RNATemplateHelix)templateElement;
                Helix graphicalHelix = new Helix(templateHelix);
                graphicalHelix.setDominantColor(this.nextBackgroundColor());
                this._RNAComponents.add(graphicalHelix);
                map.put(templateHelix, graphicalHelix);
                continue;
            }
            if (!(templateElement instanceof RNATemplate.RNATemplateUnpairedSequence)) continue;
            RNATemplate.RNATemplateUnpairedSequence templateSequence = (RNATemplate.RNATemplateUnpairedSequence)templateElement;
            UnpairedRegion graphicalSequence = new UnpairedRegion(templateSequence);
            graphicalSequence.setDominantColor(this.nextBackgroundColor());
            this._RNAComponents.add(graphicalSequence);
            map.put(templateSequence, graphicalSequence);
        }
        for (RNATemplate.RNATemplateElement.EdgeEndPoint v1 : template.makeEdgeList()) {
            RNATemplate.RNATemplateElement.EdgeEndPoint v2 = v1.getOtherEndPoint();
            GraphicalTemplateElement gte1 = (GraphicalTemplateElement)map.get(v1.getElement());
            GraphicalTemplateElement gte2 = (GraphicalTemplateElement)map.get(v2.getElement());
            GraphicalTemplateElement.RelativePosition rp1 = gte1.relativePositionFromEdgeEndPointPosition(v1.getPosition());
            GraphicalTemplateElement.RelativePosition rp2 = gte2.relativePositionFromEdgeEndPointPosition(v2.getPosition());
            this.addGraphicalConnection(gte1, rp1, gte2, rp2);
        }
        this.repaint();
    }

    public void loadFromXmlFile(File filename) {
        try {
            RNATemplate newTemplate = RNATemplate.fromXMLFile(filename);
            this.loadTemplate(newTemplate);
        }
        catch (ExceptionXmlLoading e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Template loading error", 0);
        }
    }
}

