/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import java.awt.geom.Point2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class TemplateEdits {
    public static final double MAX_DISTANCE = 15.0;

    public static class ElementAddTemplateEdit
    extends AbstractUndoableEdit {
        private GraphicalTemplateElement _h;
        private TemplatePanel _p;

        public ElementAddTemplateEdit(GraphicalTemplateElement h, TemplatePanel p) {
            this._h = h;
            this._p = p;
        }

        public void undo() throws CannotUndoException {
            this._p.removeElement(this._h);
            this._p.repaint();
        }

        public void redo() throws CannotRedoException {
            this._p.addElement(this._h);
            this._p.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Graphical element added";
        }
    }

    public static class ElementAttachTemplateEdit
    extends AbstractUndoableEdit {
        Connection _c;
        private TemplatePanel _p;

        public ElementAttachTemplateEdit(Connection c, TemplatePanel p) {
            this._c = c;
            this._p = p;
        }

        public void undo() throws CannotUndoException {
            this._p.removeConnection(this._c);
            this._p.repaint();
        }

        public void redo() throws CannotRedoException {
            this._c = this._p.addConnection(this._c._h1, this._c._edge1, this._c._h2, this._c._edge2);
            this._p.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Graphical elements attached";
        }
    }

    public static class ElementDetachTemplateEdit
    extends AbstractUndoableEdit {
        Connection _c;
        private TemplatePanel _p;

        public ElementDetachTemplateEdit(Connection c, TemplatePanel p) {
            this._c = c;
            this._p = p;
        }

        public void undo() throws CannotUndoException {
            this._c = this._p.addConnection(this._c._h1, this._c._edge1, this._c._h2, this._c._edge2);
            this._p.repaint();
        }

        public void redo() throws CannotRedoException {
            this._p.removeConnection(this._c);
            this._p.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Graphical elements detached";
        }
    }

    public static class ElementEdgeMoveTemplateEdit
    extends AbstractUndoableEdit {
        private GraphicalTemplateElement _ur;
        GraphicalTemplateElement.RelativePosition _edge;
        private double _ox;
        private double _oy;
        private double _nx;
        private double _ny;
        private TemplatePanel _p;

        public ElementEdgeMoveTemplateEdit(GraphicalTemplateElement ur, GraphicalTemplateElement.RelativePosition edge, double nx, double ny, TemplatePanel p) {
            this._ur = ur;
            this._edge = edge;
            this._ox = ur.getEdgePosition((GraphicalTemplateElement.RelativePosition)edge).x;
            this._oy = ur.getEdgePosition((GraphicalTemplateElement.RelativePosition)edge).y;
            this._nx = nx;
            this._ny = ny;
            this._p = p;
        }

        public void undo() throws CannotUndoException {
            this._ur.setEdgePosition(this._edge, new Point2D.Double(this._ox, this._oy));
            this._p.repaint();
        }

        public void redo() throws CannotRedoException {
            this._ur.setEdgePosition(this._edge, new Point2D.Double(this._nx, this._ny));
            this._p.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Edge moved " + (Object)((Object)this._edge);
        }

        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof ElementEdgeMoveTemplateEdit) {
                ElementEdgeMoveTemplateEdit e = (ElementEdgeMoveTemplateEdit)anEdit;
                if (e._edge == this._edge) {
                    Point2D.Double po1 = new Point2D.Double(this._ox, this._oy);
                    Point2D.Double pn1 = new Point2D.Double(this._nx, this._ny);
                    Point2D.Double po2 = new Point2D.Double(e._ox, e._oy);
                    Point2D.Double pn2 = new Point2D.Double(e._nx, e._ny);
                    if (this._ur == e._ur && pn1.equals(po2) && po1.distance(pn2) < 15.0) {
                        this._nx = e._nx;
                        this._ny = e._ny;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class ElementRemoveTemplateEdit
    extends AbstractUndoableEdit {
        private GraphicalTemplateElement _h;
        private TemplatePanel _p;

        public ElementRemoveTemplateEdit(GraphicalTemplateElement h, TemplatePanel p) {
            this._h = h;
            this._p = p;
        }

        public void undo() throws CannotUndoException {
            this._p.addElement(this._h);
            this._p.repaint();
        }

        public void redo() throws CannotRedoException {
            this._p.removeElement(this._h);
            this._p.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Graphical element removed";
        }
    }

    public static class HelixFlipTemplateEdit
    extends AbstractUndoableEdit {
        private Helix _h;
        private TemplatePanel _p;

        public HelixFlipTemplateEdit(Helix h, TemplatePanel p) {
            this._h = h;
            this._p = p;
        }

        public void undo() throws CannotUndoException {
            this._h.toggleFlipped();
            this._p.repaint();
        }

        public void redo() throws CannotRedoException {
            this._h.toggleFlipped();
            this._p.repaint();
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }

        public String getPresentationName() {
            return "Helix flipped ";
        }
    }
}

