/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.exceptions.ExceptionEdgeEndpointAlreadyConnected;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicalTemplateElement {
    public boolean _debug = false;
    protected HashMap<RelativePosition, Color> _mainColors = new HashMap();
    public Color _dominantColor = new Color(0.5f, 0.5f, 0.5f, 0.9f);
    static final Color BACKBONE_COLOR = Color.gray;
    static final Color CONTROL_COLOR = Color.decode("#D0D0FF");
    static final Font NUMBER_FONT = new Font("Arial", 1, 18);
    static final Color NUMBER_COLOR = Color.gray;
    static final Color BASE_PAIR_COLOR = Color.blue;
    static final Color BASE_COLOR = Color.gray;
    static final Color BASE_FILL_COLOR = Color.white;
    static final Color BASE_FILL_3_COLOR = Color.red;
    static final Color BASE_FILL_5_COLOR = Color.green;
    static final Color MAGNET_COLOR = CONTROL_COLOR;
    private HashMap<RelativePosition, Couple<RelativePosition, GraphicalTemplateElement>> _attachedElements = new HashMap();
    protected Stroke _boldStroke = new BasicStroke(2.5f, 1, 1, 3.0f);
    protected Stroke _solidStroke = new BasicStroke(1.5f, 1, 1, 3.0f);
    private float[] dash = new float[]{5.0f, 5.0f};
    protected Stroke _dashedStroke = new BasicStroke(1.5f, 1, 1, 3.0f, this.dash, 0.0f);

    public void setDominantColor(Color c) {
        this._dominantColor = c;
    }

    public Color getDominantColor() {
        return this._dominantColor;
    }

    public abstract RelativePosition getRelativePosition(double var1, double var3);

    public abstract void draw(Graphics2D var1, boolean var2);

    public abstract Polygon getBoundingPolygon();

    public abstract void translate(double var1, double var3);

    public abstract RelativePosition getClosestEdge(double var1, double var3);

    public abstract ArrayList<RelativePosition> getConnectedEdges();

    public abstract RNATemplate.RNATemplateElement getTemplateElement();

    public void setMainColor(RelativePosition edge, Color c) {
        this._mainColors.put(edge, c);
    }

    public abstract Shape getArea();

    public void attach(GraphicalTemplateElement e, RelativePosition edgeOrig, RelativePosition edgeDest) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
        this._attachedElements.put(edgeOrig, new Couple<RelativePosition, GraphicalTemplateElement>(edgeDest, e));
    }

    public void graphicalAttach(GraphicalTemplateElement e, RelativePosition edgeOrig, RelativePosition edgeDest) {
        this._attachedElements.put(edgeOrig, new Couple<RelativePosition, GraphicalTemplateElement>(edgeDest, e));
    }

    public void detach(RelativePosition edge) {
        if (this._attachedElements.containsKey((Object)edge)) {
            Couple<RelativePosition, GraphicalTemplateElement> c = this._attachedElements.get((Object)edge);
            this._attachedElements.remove((Object)edge);
            ((GraphicalTemplateElement)c.second).detach((RelativePosition)((Object)c.first));
        }
    }

    public Couple<RelativePosition, GraphicalTemplateElement> getAttachedElement(RelativePosition localedge) {
        if (this._attachedElements.containsKey((Object)localedge)) {
            return this._attachedElements.get((Object)localedge);
        }
        return null;
    }

    public boolean hasAttachedElement(RelativePosition localedge) {
        return this._attachedElements.containsKey((Object)localedge);
    }

    public abstract RNATemplate.RNATemplateElement.EdgeEndPoint getEndPoint(RelativePosition var1);

    public abstract boolean isIn(RelativePosition var1);

    public void draw(Graphics2D g2d) {
        this.draw(g2d, false);
    }

    private Dimension getStringDimension(Graphics2D g, String s) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(s, g);
        return new Dimension((int)r.getWidth(), fm.getAscent() - fm.getDescent());
    }

    public void drawStringCentered(Graphics2D g2, String res, double x, double y) {
        Dimension d = this.getStringDimension(g2, res);
        x -= (double)d.width / 2.0;
        y += (double)d.height / 2.0;
        if (this._debug) {
            g2.drawRect((int)x, (int)y - d.height, d.width, d.height);
        }
        g2.drawString(res, (int)Math.round(x), (int)Math.round(y));
    }

    public abstract RelativePosition getConnectedEdge(RelativePosition var1);

    public abstract Point2D.Double getEdgePosition(RelativePosition var1);

    public abstract void setEdgePosition(RelativePosition var1, Point2D.Double var2);

    public abstract RelativePosition relativePositionFromEdgeEndPointPosition(RNATemplate.EdgeEndPointPosition var1);

    public static boolean canConnect(GraphicalTemplateElement el1, RelativePosition e1, GraphicalTemplateElement el2, RelativePosition e2) {
        return !el1.hasAttachedElement(e1) && !el2.hasAttachedElement(e2) && el1.isIn(e1) != el2.isIn(e2);
    }

    protected void drawMove(Graphics2D g2d, Point2D.Double center) {
        g2d.setStroke(this._solidStroke);
        g2d.setColor(CONTROL_COLOR);
        g2d.fillOval((int)(center.x - 13.0), (int)(center.y - 13.0), 26, 26);
        g2d.setColor(BACKBONE_COLOR);
        g2d.drawOval((int)(center.x - 13.0), (int)(center.y - 13.0), 26, 26);
        double arrowLength = 11.0;
        double width = 3.0;
        this.drawArrow(g2d, center, new Point2D.Double(center.x + arrowLength, center.y), width);
        this.drawArrow(g2d, center, new Point2D.Double(center.x - arrowLength, center.y), width);
        this.drawArrow(g2d, center, new Point2D.Double(center.x, center.y + arrowLength), width);
        this.drawArrow(g2d, center, new Point2D.Double(center.x, center.y - arrowLength), width);
    }

    protected void drawEditStart(Graphics2D g2d, Helix h, double dx, double dy, double nx, double ny) {
        Point2D.Double center = h.getCenterEditStart();
        this.drawEdit(g2d, center, dx, dy, nx, ny);
    }

    protected void drawEditEnd(Graphics2D g2d, Helix h, double dx, double dy, double nx, double ny) {
        Point2D.Double center = h.getCenterEditEnd();
        this.drawEdit(g2d, center, dx, dy, nx, ny);
    }

    protected void drawEdit(Graphics2D g2d, Point2D.Double center, double dx, double dy, double nx, double ny) {
        g2d.setColor(CONTROL_COLOR);
        g2d.fillOval((int)(center.x - 10.0), (int)(center.y - 10.0), 20, 20);
        g2d.setColor(BACKBONE_COLOR);
        g2d.drawOval((int)(center.x - 10.0), (int)(center.y - 10.0), 20, 20);
        double arrowLength = 8.0;
        double width = 3.0;
        this.drawArrow(g2d, center, new Point2D.Double(center.x + nx * arrowLength, center.y + ny * arrowLength), width);
        this.drawArrow(g2d, center, new Point2D.Double(center.x - nx * arrowLength, center.y - ny * arrowLength), width);
        this.drawArrow(g2d, center, new Point2D.Double(center.x + dx * arrowLength, center.y + dy * arrowLength), width);
        this.drawArrow(g2d, center, new Point2D.Double(center.x - dx * arrowLength, center.y - dy * arrowLength), width);
    }

    protected void drawArrow(Graphics2D g2d, Point2D.Double orig, Point2D.Double dest, double width) {
        double dy;
        g2d.setStroke(this._solidStroke);
        g2d.drawLine((int)orig.x, (int)orig.y, (int)dest.x, (int)dest.y);
        double dx = (orig.x - dest.x) / orig.distance(dest);
        double nx = dy = (orig.y - dest.y) / orig.distance(dest);
        double ny = -dx;
        g2d.drawLine((int)dest.x, (int)dest.y, (int)(dest.x - width * (-dx + nx)), (int)(dest.y - width * (-dy + ny)));
        g2d.drawLine((int)dest.x, (int)dest.y, (int)(dest.x - width * (-dx - nx)), (int)(dest.y - width * (-dy - ny)));
    }

    protected void drawAnchor(Graphics2D g2d, Point2D.Double p) {
        this.drawAnchor(g2d, p, CONTROL_COLOR);
    }

    protected void drawAnchor5(Graphics2D g2d, Point2D.Double p) {
        this.drawAnchor(g2d, p, BASE_FILL_5_COLOR);
    }

    protected void drawAnchor3(Graphics2D g2d, Point2D.Double p) {
        this.drawAnchor(g2d, p, BASE_FILL_3_COLOR);
    }

    protected void drawAnchor(Graphics2D g2d, Point2D.Double p, Color c) {
        g2d.setColor(c);
        g2d.fillOval((int)(p.x - 7.0), (int)(p.y - 7.0), 14, 14);
        g2d.setColor(BASE_COLOR);
        g2d.drawOval((int)(p.x - 7.0), (int)(p.y - 7.0), 14, 14);
    }

    protected void drawMagnet(Graphics2D g2d, Point2D.Double p) {
        this.drawAnchor(g2d, p, MAGNET_COLOR);
        g2d.setColor(BASE_COLOR);
        g2d.drawOval((int)(p.x - 7.0), (int)(p.y - 7.0), 14, 14);
        g2d.drawOval((int)(p.x - 2.0), (int)(p.y - 2.0), 4, 4);
    }

    protected void drawBase(Graphics2D g2d, Point2D.Double p) {
        g2d.setColor(BASE_FILL_COLOR);
        g2d.fillOval((int)(p.x - 3.0), (int)(p.y - 3.0), 6, 6);
        g2d.setColor(BASE_COLOR);
        g2d.drawOval((int)(p.x - 3.0), (int)(p.y - 3.0), 6, 6);
    }

    public boolean equals(Object b) {
        if (b instanceof GraphicalTemplateElement) {
            return b == this;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelativePosition {
        RP_OUTER,
        RP_INNER_GENERAL,
        RP_INNER_MOVE,
        RP_EDIT_START,
        RP_EDIT_END,
        RP_CONNECT_START5,
        RP_CONNECT_START3,
        RP_CONNECT_END5,
        RP_CONNECT_END3,
        RP_EDIT_TANGENT_3,
        RP_EDIT_TANGENT_5;

    }
}

