/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.newGUI;

import fr.orsay.lri.varna.applications.newGUI.VARNAGUIModel;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VARNAGUITreeModel
extends DefaultTreeModel {
    private TreeSet<String> _folders = new TreeSet();
    private TreeSet<String> _ids = new TreeSet();
    private Hashtable<String, TreeSet<VARNAGUIModel>> _criterionToFiles = new Hashtable();
    private Hashtable<String, DefaultMutableTreeNode> _criterionToNodes = new Hashtable();
    private ArrayList<DefaultMutableTreeNode> _fileNodes = new ArrayList();
    private SORT_MODE _mode = SORT_MODE.PATH;
    FilenameFilter _f = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".dbn") || name.toLowerCase().endsWith(".ct") || name.toLowerCase().endsWith(".bpseq") || name.toLowerCase().endsWith(".rnaml");
        }
    };

    public VARNAGUITreeModel() {
        super(new DefaultMutableTreeNode("Folders"));
    }

    public void removeFolder(String path) {
        if (this._mode == SORT_MODE.PATH) {
            int pos = this._folders.headSet(path).size();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getRoot().getChildAt(pos);
            parent.removeAllChildren();
            this.reload(parent);
            this.getRoot().remove(parent);
            this._criterionToNodes.remove(path);
            this._criterionToFiles.remove(path);
        } else if (this._mode == SORT_MODE.ID) {
            ArrayList<DefaultMutableTreeNode> toBeRemoved = new ArrayList<DefaultMutableTreeNode>();
            for (DefaultMutableTreeNode leafNode : this._fileNodes) {
                VARNAGUIModel m = (VARNAGUIModel)leafNode.getUserObject();
                if (!m.getFolder().equals(path)) continue;
                toBeRemoved.add(leafNode);
            }
            for (DefaultMutableTreeNode leafNode : toBeRemoved) {
                this._fileNodes.remove(leafNode);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)leafNode.getParent();
                parent.remove(leafNode);
            }
        }
        this._folders.remove(path);
    }

    public DefaultMutableTreeNode insertGroupNode(String crit, TreeSet<String> t) {
        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(crit);
        DefaultMutableTreeNode parent = this.getRoot();
        int pos = t.headSet(crit).size();
        parent.insert(groupNode, pos);
        this.reload(groupNode);
        return groupNode;
    }

    public void insertLeafNode(DefaultMutableTreeNode parent, VARNAGUIModel m, TreeSet<VARNAGUIModel> t) {
        DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(m);
        int pos = t.headSet(m).size();
        parent.insert(leafNode, pos);
        this._fileNodes.add(leafNode);
    }

    public DefaultMutableTreeNode addFolder(String path) {
        DefaultMutableTreeNode groupNode = null;
        try {
            if (!this._folders.contains(path)) {
                System.out.println("Folder: " + path);
                File dir = new File(path);
                if (dir.isDirectory()) {
                    path = dir.getCanonicalPath();
                    this._folders.add(path);
                    if (this._mode == SORT_MODE.PATH) {
                        System.out.println("  Adding: " + path);
                        groupNode = this.insertGroupNode(path, this._folders);
                        this._criterionToNodes.put(path, groupNode);
                        this._criterionToFiles.put(path, new TreeSet());
                    }
                    File[] fileArray = dir.listFiles(this._f);
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        this.addFile(path, f.getCanonicalPath());
                        ++n2;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return groupNode;
    }

    private void addFile(String folder, String path) {
        System.out.println("  => " + path);
        VARNAGUIModel m = new VARNAGUIModel(folder, path);
        if (this._mode == SORT_MODE.PATH) {
            this.addFolder(folder);
            this.insertLeafNode(this._criterionToNodes.get(folder), m, this._criterionToFiles.get(folder));
        } else if (this._mode == SORT_MODE.ID) {
            String id = m.getID();
            if (!this._criterionToNodes.containsKey(id)) {
                this._criterionToNodes.put(id, this.insertGroupNode(id, this._ids));
            }
            this.insertLeafNode(this._criterionToNodes.get(id), m, this._criterionToFiles.get(id));
        }
    }

    @Override
    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    public ArrayList<String> getFolders() {
        ArrayList<String> result = new ArrayList<String>(this._folders);
        return result;
    }

    public FilenameFilter getFileNameFilter() {
        return this._f;
    }

    public void setFileNameFilter(FilenameFilter f) {
        this._f = f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SORT_MODE {
        PATH,
        ID;

    }
}

